/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Dot;
import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.Identifier;
import freemarker.core.InvalidReferenceException;
import freemarker.core.Macro;
import freemarker.core.TemplateElement;
import freemarker.core.TextBlock;
import freemarker.template.EmptyMap;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateTransformModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class UnifiedCall
extends TemplateElement {
    private Expression nameExp;
    private Map namedArgs;
    private List positionalArgs;
    private List bodyParameterNames;
    boolean legacySyntax;
    boolean notransform;

    UnifiedCall(Expression expression, Map map, TemplateElement templateElement, List list) {
        this.nameExp = expression;
        this.namedArgs = map;
        this.nestedBlock = templateElement;
        this.bodyParameterNames = list;
        this.notransform = this.legacySyntax || this.positionalArgs != null && this.positionalArgs.isEmpty() || list != null && !list.isEmpty();
    }

    UnifiedCall(Expression expression, List list, TemplateElement templateElement, List list2) {
        this.nameExp = expression;
        this.positionalArgs = list;
        if (templateElement == TextBlock.EMPTY_BLOCK) {
            templateElement = null;
        }
        this.nestedBlock = templateElement;
        this.bodyParameterNames = list2;
    }

    void accept(Environment environment) throws TemplateException, IOException {
        TemplateModel templateModel = this.nameExp.getAsTemplateModel(environment);
        if (templateModel == Macro.DO_NOTHING_MACRO) {
            return;
        }
        if (!this.notransform && templateModel instanceof TemplateTransformModel) {
            Map map;
            if (this.namedArgs != null && !this.namedArgs.isEmpty()) {
                map = new HashMap();
                Iterator iterator = this.namedArgs.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String string = (String)entry.getKey();
                    Expression expression = (Expression)entry.getValue();
                    TemplateModel templateModel2 = expression.getAsTemplateModel(environment);
                    map.put(string, templateModel2);
                }
            } else {
                map = EmptyMap.instance;
            }
            environment.visit(this.nestedBlock, (TemplateTransformModel)templateModel, map);
            return;
        }
        if (templateModel instanceof Macro) {
            Macro macro = (Macro)templateModel;
            if (macro.isFunction && !this.legacySyntax) {
                throw new TemplateException("Routine " + macro.getName() + " is a function. " + "A function can only be called within the evaluation of an expression.", environment);
            }
            environment.visit(macro, this.namedArgs, this.positionalArgs, this.bodyParameterNames, this.nestedBlock);
            return;
        }
        if (templateModel == null) {
            throw new InvalidReferenceException(this.getStartLocation() + " " + this.nameExp + " not found.", environment);
        }
        if (this.notransform) {
            throw new TemplateException(this.getStartLocation() + ": " + this.nameExp + " is not a Macro.", environment);
        }
        throw new TemplateException(this.getStartLocation() + ": " + this.nameExp + " is not a Macro or Transform.", environment);
    }

    public String getCanonicalForm() {
        StringBuffer stringBuffer = new StringBuffer("<@");
        stringBuffer.append(this.nameExp.getCanonicalForm());
        if (this.positionalArgs != null) {
            for (int i = 0; i < this.positionalArgs.size(); ++i) {
                Expression expression = (Expression)this.positionalArgs.get(i);
                if (i != 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(' ');
                stringBuffer.append(expression.getCanonicalForm());
            }
        } else {
            ArrayList arrayList = new ArrayList(this.namedArgs.keySet());
            Collections.sort(arrayList);
            for (int i = 0; i < arrayList.size(); ++i) {
                Expression expression = (Expression)this.namedArgs.get(arrayList.get(i));
                stringBuffer.append(' ');
                stringBuffer.append(arrayList.get(i));
                stringBuffer.append('=');
                stringBuffer.append(expression.getCanonicalForm());
            }
        }
        if (this.nestedBlock == null) {
            stringBuffer.append("/>");
        } else {
            stringBuffer.append('>');
            stringBuffer.append(this.nestedBlock.getCanonicalForm());
            stringBuffer.append("</@");
            if (this.nameExp instanceof Identifier || this.nameExp instanceof Dot && ((Dot)this.nameExp).onlyHasIdentifiers()) {
                stringBuffer.append(this.nameExp);
            }
            stringBuffer.append('>');
        }
        return stringBuffer.toString();
    }

    public String getDescription() {
        return "user-directive " + this.nameExp;
    }
}

