/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.ArithmeticEngine;
import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.NonNumericalException;
import freemarker.template.SimpleNumber;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateNumberModel;

final class UnaryPlusMinusExpression
extends Expression {
    private final Expression target;
    private final boolean isMinus;
    private static final Integer MINUS_ONE = new Integer(-1);

    UnaryPlusMinusExpression(Expression expression, boolean bl) {
        this.target = expression;
        this.isMinus = bl;
    }

    TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
        TemplateNumberModel templateNumberModel = null;
        try {
            templateNumberModel = (TemplateNumberModel)this.target.getAsTemplateModel(environment);
        }
        catch (ClassCastException classCastException) {
            String string = "Error " + this.getStartLocation();
            string = string + "\nExpression " + this.target + " is not numerical.";
            throw new NonNumericalException(string, environment);
        }
        if (!this.isMinus) {
            return templateNumberModel;
        }
        Number number = templateNumberModel.getAsNumber();
        number = ArithmeticEngine.CONSERVATIVE_ENGINE.multiply(MINUS_ONE, number);
        return new SimpleNumber(number);
    }

    public String getCanonicalForm() {
        String string = this.isMinus ? "-" : "+";
        return string + this.target.getCanonicalForm();
    }

    boolean isLiteral() {
        return this.target.isLiteral();
    }

    Expression _deepClone(String string, Expression expression) {
        return new UnaryPlusMinusExpression(this.target.deepClone(string, expression), this.isMinus);
    }
}

