/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.TemplateElement;
import freemarker.template.EmptyMap;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateTransformModel;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

final class TransformBlock
extends TemplateElement {
    private Expression transformExpression;
    Map namedArgs;

    TransformBlock(Expression expression, Map map, TemplateElement templateElement) {
        this.transformExpression = expression;
        this.namedArgs = map;
        this.nestedBlock = templateElement;
    }

    void accept(Environment environment) throws TemplateException, IOException {
        Map map;
        TemplateTransformModel templateTransformModel = environment.getTransform(this.transformExpression);
        if (templateTransformModel != null) {
            if (this.namedArgs != null && !this.namedArgs.isEmpty()) {
                map = new HashMap();
                Iterator iterator = this.namedArgs.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String string = (String)entry.getKey();
                    Expression expression = (Expression)entry.getValue();
                    TemplateModel templateModel = expression.getAsTemplateModel(environment);
                    map.put(string, templateModel);
                }
            } else {
                map = EmptyMap.instance;
            }
        } else {
            TemplateModel templateModel = this.transformExpression.getAsTemplateModel(environment);
            throw TransformBlock.invalidTypeException(templateModel, this.transformExpression, environment, "transform");
        }
        environment.visit(this.nestedBlock, templateTransformModel, map);
    }

    public String getCanonicalForm() {
        StringBuffer stringBuffer = new StringBuffer("<#transform ");
        stringBuffer.append(this.transformExpression);
        if (this.namedArgs != null) {
            Iterator iterator = this.namedArgs.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                stringBuffer.append(' ');
                stringBuffer.append(entry.getKey());
                stringBuffer.append('=');
                Expression expression = (Expression)entry.getValue();
                stringBuffer.append(expression.getCanonicalForm());
            }
        }
        stringBuffer.append(">");
        if (this.nestedBlock != null) {
            stringBuffer.append(this.nestedBlock.getCanonicalForm());
        }
        stringBuffer.append("</#transform>");
        return stringBuffer.toString();
    }

    public String getDescription() {
        return "transform " + this.transformExpression;
    }
}

