/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Assignment;
import freemarker.core.AssignmentInstruction;
import freemarker.core.Comment;
import freemarker.core.Environment;
import freemarker.core.LibraryLoad;
import freemarker.core.Macro;
import freemarker.core.PropertySetting;
import freemarker.core.TemplateElement;
import freemarker.core.TrimInstruction;
import java.io.IOException;

public final class TextBlock
extends TemplateElement {
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];
    static final TextBlock EMPTY_BLOCK = new TextBlock(EMPTY_CHAR_ARRAY, false);
    private char[] text;
    private final boolean unparsed;

    public TextBlock(String string) {
        this(string, false);
    }

    public TextBlock(String string, boolean bl) {
        this(string.toCharArray(), bl);
    }

    private TextBlock(char[] cArray, boolean bl) {
        this.text = cArray;
        this.unparsed = bl;
    }

    public void accept(Environment environment) throws IOException {
        environment.getOut().write(this.text);
    }

    public String getCanonicalForm() {
        String string = new String(this.text);
        if (this.unparsed) {
            return "<#noparse>" + string + "</#noparse>";
        }
        return string;
    }

    public String getDescription() {
        String string = new String(this.text).trim();
        if (string.length() == 0) {
            return "whitespace";
        }
        if (string.length() > 20) {
            string = string.substring(0, 20) + "...";
            string = string.replace('\n', ' ');
            string = string.replace('\r', ' ');
        }
        return "text block (" + string + ")";
    }

    TemplateElement postParseCleanup(boolean bl) {
        if (this.text.length == 0) {
            return this;
        }
        int n = 0;
        int n2 = 0;
        boolean bl2 = this.deliberateLeftTrim();
        boolean bl3 = this.deliberateRightTrim();
        if (!bl || this.text.length == 0) {
            return this;
        }
        if (this.parent.parent == null && this.previousSibling() == null) {
            return this;
        }
        if (!bl2) {
            n2 = this.trailingCharsToStrip();
        }
        if (!bl3) {
            n = this.openingCharsToStrip();
        }
        if (n == 0 && n2 == 0) {
            return this;
        }
        this.text = TextBlock.substring(this.text, n, this.text.length - n2);
        if (n > 0) {
            ++this.beginLine;
            this.beginColumn = 1;
        }
        if (n2 > 0) {
            this.endColumn = 0;
        }
        return this;
    }

    private boolean deliberateLeftTrim() {
        boolean bl = false;
        for (TemplateElement templateElement = this.nextTerminalNode(); templateElement != null && templateElement.beginLine == this.endLine; templateElement = templateElement.nextTerminalNode()) {
            if (!(templateElement instanceof TrimInstruction)) continue;
            TrimInstruction trimInstruction = (TrimInstruction)templateElement;
            if (!trimInstruction.left && !trimInstruction.right) {
                bl = true;
            }
            if (!trimInstruction.left) continue;
            bl = true;
            int n = this.lastNewLineIndex();
            if (n < 0 && this.beginColumn != 1) continue;
            char[] cArray = TextBlock.substring(this.text, 0, n + 1);
            char[] cArray2 = TextBlock.substring(this.text, 1 + n);
            if (TextBlock.trim(cArray2).length == 0) {
                this.text = cArray;
                this.endColumn = 0;
                continue;
            }
            int n2 = 0;
            while (Character.isWhitespace(cArray2[n2])) {
                ++n2;
            }
            char[] cArray3 = TextBlock.substring(cArray2, n2);
            this.text = TextBlock.concat(cArray, cArray3);
        }
        if (bl) {
            // empty if block
        }
        return bl;
    }

    private boolean deliberateRightTrim() {
        boolean bl = false;
        for (TemplateElement templateElement = this.prevTerminalNode(); templateElement != null && templateElement.endLine == this.beginLine; templateElement = templateElement.prevTerminalNode()) {
            if (!(templateElement instanceof TrimInstruction)) continue;
            TrimInstruction trimInstruction = (TrimInstruction)templateElement;
            if (!trimInstruction.left && !trimInstruction.right) {
                bl = true;
            }
            if (!trimInstruction.right) continue;
            bl = true;
            int n = this.firstNewLineIndex() + 1;
            if (n == 0) {
                return false;
            }
            if (this.text.length > n && this.text[n - 1] == '\r' && this.text[n] == '\n') {
                ++n;
            }
            char[] cArray = TextBlock.substring(this.text, n);
            char[] cArray2 = TextBlock.substring(this.text, 0, n);
            if (TextBlock.trim(cArray2).length == 0) {
                this.text = cArray;
                ++this.beginLine;
                this.beginColumn = 1;
                continue;
            }
            int n2 = cArray2.length - 1;
            while (Character.isWhitespace(this.text[n2])) {
                --n2;
            }
            char[] cArray3 = TextBlock.substring(this.text, 0, n2 + 1);
            if (TextBlock.trim(cArray).length == 0) {
                boolean bl2 = true;
                for (TemplateElement templateElement2 = this.nextTerminalNode(); templateElement2 != null && templateElement2.beginLine == this.endLine; templateElement2 = templateElement2.nextTerminalNode()) {
                    if (templateElement2.heedsOpeningWhitespace()) {
                        bl2 = false;
                    }
                    if (!(templateElement2 instanceof TrimInstruction) || !((TrimInstruction)templateElement2).left) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) {
                    cArray = EMPTY_CHAR_ARRAY;
                }
            }
            this.text = TextBlock.concat(cArray3, cArray);
        }
        return bl;
    }

    private int firstNewLineIndex() {
        int n;
        String string = new String(this.text);
        int n2 = string.indexOf(10);
        int n3 = string.indexOf(13);
        int n4 = n = n2 >= 0 ? n2 : n3;
        if (n2 >= 0 && n3 >= 0) {
            n = Math.min(n2, n3);
        }
        return n;
    }

    private int lastNewLineIndex() {
        String string = new String(this.text);
        return Math.max(string.lastIndexOf(13), string.lastIndexOf(10));
    }

    private int openingCharsToStrip() {
        int n = this.firstNewLineIndex();
        if (n == -1 && this.beginColumn != 1) {
            return 0;
        }
        if (this.text.length > ++n && n > 0 && this.text[n - 1] == '\r' && this.text[n] == '\n') {
            ++n;
        }
        if (new String(this.text).substring(0, n).trim().length() > 0) {
            return 0;
        }
        for (TemplateElement templateElement = this.prevTerminalNode(); templateElement != null && templateElement.endLine == this.beginLine; templateElement = templateElement.prevTerminalNode()) {
            if (!templateElement.heedsOpeningWhitespace()) continue;
            return 0;
        }
        return n;
    }

    private int trailingCharsToStrip() {
        String string = new String(this.text);
        int n = this.lastNewLineIndex();
        if (n == -1 && this.beginColumn != 1) {
            return 0;
        }
        String string2 = string.substring(n + 1);
        if (string2.trim().length() > 0) {
            return 0;
        }
        for (TemplateElement templateElement = this.nextTerminalNode(); templateElement != null && templateElement.beginLine == this.endLine; templateElement = templateElement.nextTerminalNode()) {
            if (!templateElement.heedsTrailingWhitespace()) continue;
            return 0;
        }
        return string2.length();
    }

    boolean heedsTrailingWhitespace() {
        if (this.isIgnorable()) {
            return false;
        }
        for (int i = 0; i < this.text.length; ++i) {
            char c = this.text[i];
            if (c == '\n' || c == '\r') {
                return false;
            }
            if (Character.isWhitespace(c)) continue;
            return true;
        }
        return true;
    }

    boolean heedsOpeningWhitespace() {
        if (this.isIgnorable()) {
            return false;
        }
        for (int i = this.text.length - 1; i >= 0; --i) {
            char c = this.text[i];
            if (c == '\n' || c == '\r') {
                return false;
            }
            if (Character.isWhitespace(c)) continue;
            return true;
        }
        return true;
    }

    boolean isIgnorable() {
        if (this.text == null || this.text.length == 0) {
            return true;
        }
        if (!this.isWhitespace()) {
            return false;
        }
        boolean bl = this.getParent().getParent() == null;
        TemplateElement templateElement = this.previousSibling();
        TemplateElement templateElement2 = this.nextSibling();
        return (templateElement == null && bl || this.nonOutputtingType(templateElement)) && (templateElement2 == null && bl || this.nonOutputtingType(templateElement2));
    }

    private boolean nonOutputtingType(TemplateElement templateElement) {
        return templateElement instanceof Macro || templateElement instanceof Assignment || templateElement instanceof AssignmentInstruction || templateElement instanceof PropertySetting || templateElement instanceof LibraryLoad || templateElement instanceof Comment;
    }

    private static char[] substring(char[] cArray, int n, int n2) {
        char[] cArray2 = new char[n2 - n];
        System.arraycopy(cArray, n, cArray2, 0, cArray2.length);
        return cArray2;
    }

    private static char[] substring(char[] cArray, int n) {
        return TextBlock.substring(cArray, n, cArray.length);
    }

    private static char[] trim(char[] cArray) {
        if (cArray.length == 0) {
            return cArray;
        }
        return new String(cArray).trim().toCharArray();
    }

    private static char[] concat(char[] cArray, char[] cArray2) {
        char[] cArray3 = new char[cArray.length + cArray2.length];
        System.arraycopy(cArray, 0, cArray3, 0, cArray.length);
        System.arraycopy(cArray2, 0, cArray3, cArray.length, cArray2.length);
        return cArray3;
    }

    boolean isWhitespace() {
        return this.text == null || TextBlock.trim(this.text).length == 0;
    }
}

