/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.InvalidReferenceException;
import freemarker.core.ParseException;
import freemarker.core.Token;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;

public abstract class TemplateObject {
    private Template template;
    int beginColumn;
    int beginLine;
    int endColumn;
    int endLine;

    final void setLocation(Template template, Token token, Token token2) throws ParseException {
        this.setLocation(template, token.beginColumn, token.beginLine, token2.endColumn, token2.endLine);
    }

    final void setLocation(Template template, Token token, TemplateObject templateObject) throws ParseException {
        this.setLocation(template, token.beginColumn, token.beginLine, templateObject.endColumn, templateObject.endLine);
    }

    final void setLocation(Template template, TemplateObject templateObject, Token token) throws ParseException {
        this.setLocation(template, templateObject.beginColumn, templateObject.beginLine, token.endColumn, token.endLine);
    }

    final void setLocation(Template template, TemplateObject templateObject, TemplateObject templateObject2) throws ParseException {
        this.setLocation(template, templateObject.beginColumn, templateObject.beginLine, templateObject2.endColumn, templateObject2.endLine);
    }

    public final int getBeginColumn() {
        return this.beginColumn;
    }

    public final int getBeginLine() {
        return this.beginLine;
    }

    public final int getEndColumn() {
        return this.endColumn;
    }

    public final int getEndLine() {
        return this.endLine;
    }

    void setLocation(Template template, int n, int n2, int n3, int n4) throws ParseException {
        this.template = template;
        this.beginColumn = n;
        this.beginLine = n2;
        this.endColumn = n3;
        this.endLine = n4;
    }

    static void assertNonNull(TemplateModel templateModel, Expression expression, Environment environment) throws InvalidReferenceException {
        if (templateModel == null) {
            throw new InvalidReferenceException("Expression " + expression + " is undefined " + expression.getStartLocation() + ".", environment);
        }
    }

    static TemplateException invalidTypeException(TemplateModel templateModel, Expression expression, Environment environment, String string) throws TemplateException {
        TemplateObject.assertNonNull(templateModel, expression, environment);
        return new TemplateException("Expected " + string + ". " + expression + " evaluated instead to " + templateModel.getClass().getName() + " " + expression.getStartLocation() + ".", environment);
    }

    public String getStartLocation() {
        String string = this.template != null ? this.template.getName() : "input";
        return "on line " + this.beginLine + ", column " + this.beginColumn + " in " + string;
    }

    public String getEndLocation() {
        String string = this.template != null ? this.template.getName() : "input";
        return "on line " + this.endLine + ", column " + this.endColumn + " in " + string;
    }

    public final String getSource() {
        if (this.template != null) {
            return this.template.getSource(this.beginColumn, this.beginLine, this.endColumn, this.endLine);
        }
        return this.getCanonicalForm();
    }

    public String toString() {
        try {
            return this.getSource();
        }
        catch (Exception exception) {
            return this.getCanonicalForm();
        }
    }

    public boolean contains(int n, int n2) {
        if (n2 < this.beginLine || n2 > this.endLine) {
            return false;
        }
        if (n2 == this.beginLine && n < this.beginColumn) {
            return false;
        }
        return n2 != this.endLine || n <= this.endColumn;
    }

    public Template getTemplate() {
        return this.template;
    }

    TemplateObject copyLocationFrom(TemplateObject templateObject) {
        this.template = templateObject.template;
        this.beginColumn = templateObject.beginColumn;
        this.beginLine = templateObject.beginLine;
        this.endColumn = templateObject.endColumn;
        this.endLine = templateObject.endLine;
        return this;
    }

    public abstract String getCanonicalForm();
}

