/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.BlockAssignment;
import freemarker.core.Environment;
import freemarker.core.Macro;
import freemarker.core.MixedContent;
import freemarker.core.ParseException;
import freemarker.core.TemplateObject;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateException;
import freemarker.template.TemplateNodeModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.utility.Collections12;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.TreeNode;

public abstract class TemplateElement
extends TemplateObject
implements TreeNode {
    TemplateElement parent;
    TemplateElement nestedBlock;
    List nestedElements;

    abstract void accept(Environment var1) throws TemplateException, IOException;

    public abstract String getDescription();

    public TemplateNodeModel getParentNode() {
        return null;
    }

    public String getNodeNamespace() {
        return null;
    }

    public String getNodeType() {
        return "element";
    }

    public TemplateSequenceModel getChildNodes() {
        if (this.nestedElements != null) {
            return new SimpleSequence(this.nestedElements);
        }
        SimpleSequence simpleSequence = null;
        if (this.nestedBlock != null) {
            simpleSequence.add(this.nestedBlock);
        }
        return simpleSequence;
    }

    public String getNodeName() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46) + 1;
        return string.substring(n);
    }

    public boolean isLeaf() {
        return this.nestedBlock == null && (this.nestedElements == null || this.nestedElements.isEmpty());
    }

    public boolean getAllowsChildren() {
        return !this.isLeaf();
    }

    public int getIndex(TreeNode treeNode) {
        if (this.nestedBlock instanceof MixedContent) {
            return this.nestedBlock.getIndex(treeNode);
        }
        if (this.nestedBlock != null) {
            if (treeNode == this.nestedBlock) {
                return 0;
            }
        } else if (this.nestedElements != null) {
            return this.nestedElements.indexOf(treeNode);
        }
        return -1;
    }

    public int getChildCount() {
        if (this.nestedBlock instanceof MixedContent) {
            return this.nestedBlock.getChildCount();
        }
        if (this.nestedBlock != null) {
            return 1;
        }
        if (this.nestedElements != null) {
            return this.nestedElements.size();
        }
        return 0;
    }

    public Enumeration children() {
        if (this.nestedBlock instanceof MixedContent) {
            return this.nestedBlock.children();
        }
        if (this.nestedBlock != null) {
            return Collections.enumeration(Collections12.singletonList(this.nestedBlock));
        }
        if (this.nestedElements != null) {
            return Collections.enumeration(this.nestedElements);
        }
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    public TreeNode getChildAt(int n) {
        if (this.nestedBlock instanceof MixedContent) {
            return this.nestedBlock.getChildAt(n);
        }
        if (this.nestedBlock != null) {
            if (n == 0) {
                return this.nestedBlock;
            }
            throw new ArrayIndexOutOfBoundsException("invalid index");
        }
        if (this.nestedElements != null) {
            return (TreeNode)this.nestedElements.get(n);
        }
        throw new ArrayIndexOutOfBoundsException("element has no children");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setChildAt(int n, TemplateElement templateElement) {
        if (this.nestedBlock instanceof MixedContent) {
            this.nestedBlock.setChildAt(n, templateElement);
            return;
        } else if (this.nestedBlock != null) {
            if (n != 0) throw new IndexOutOfBoundsException("invalid index");
            this.nestedBlock = templateElement;
            templateElement.parent = this;
            return;
        } else {
            if (this.nestedElements == null) throw new IndexOutOfBoundsException("element has no children");
            this.nestedElements.set(n, templateElement);
            templateElement.parent = this;
        }
    }

    public TreeNode getParent() {
        return this.parent;
    }

    void setParentRecursively(TemplateElement templateElement) {
        this.parent = templateElement;
        int n = this.nestedElements == null ? 0 : this.nestedElements.size();
        for (int i = 0; i < n; ++i) {
            ((TemplateElement)this.nestedElements.get(i)).setParentRecursively(this);
        }
        if (this.nestedBlock != null) {
            this.nestedBlock.setParentRecursively(this);
        }
    }

    TemplateElement postParseCleanup(boolean bl) throws ParseException {
        if (this.nestedElements != null) {
            TemplateElement templateElement;
            for (int i = 0; i < this.nestedElements.size(); ++i) {
                templateElement = (TemplateElement)this.nestedElements.get(i);
                templateElement = templateElement.postParseCleanup(bl);
                this.nestedElements.set(i, templateElement);
                templateElement.parent = this;
            }
            if (bl) {
                Iterator iterator = this.nestedElements.iterator();
                while (iterator.hasNext()) {
                    templateElement = (TemplateElement)iterator.next();
                    if (!templateElement.isIgnorable()) continue;
                    iterator.remove();
                }
            }
            if (this.nestedElements instanceof ArrayList) {
                ((ArrayList)this.nestedElements).trimToSize();
            }
        }
        if (this.nestedBlock != null) {
            this.nestedBlock = this.nestedBlock.postParseCleanup(bl);
            if (this.nestedBlock.isIgnorable()) {
                this.nestedBlock = null;
            } else {
                this.nestedBlock.parent = this;
            }
        }
        return this;
    }

    boolean isIgnorable() {
        return false;
    }

    TemplateElement prevTerminalNode() {
        TemplateElement templateElement = this.previousSibling();
        if (templateElement != null) {
            return templateElement.getLastLeaf();
        }
        if (this.parent != null) {
            return this.parent.prevTerminalNode();
        }
        return null;
    }

    TemplateElement nextTerminalNode() {
        TemplateElement templateElement = this.nextSibling();
        if (templateElement != null) {
            return templateElement.getFirstLeaf();
        }
        if (this.parent != null) {
            return this.parent.nextTerminalNode();
        }
        return null;
    }

    TemplateElement previousSibling() {
        if (this.parent == null) {
            return null;
        }
        List list = this.parent.nestedElements;
        if (list == null) {
            return null;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            if (list.get(i) != this) continue;
            return i > 0 ? (TemplateElement)list.get(i - 1) : null;
        }
        return null;
    }

    TemplateElement nextSibling() {
        if (this.parent == null) {
            return null;
        }
        List list = this.parent.nestedElements;
        if (list == null) {
            return null;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) != this) continue;
            return i + 1 < list.size() ? (TemplateElement)list.get(i + 1) : null;
        }
        return null;
    }

    private TemplateElement getFirstChild() {
        if (this.nestedBlock != null) {
            return this.nestedBlock;
        }
        if (this.nestedElements != null && this.nestedElements.size() > 0) {
            return (TemplateElement)this.nestedElements.get(0);
        }
        return null;
    }

    private TemplateElement getLastChild() {
        if (this.nestedBlock != null) {
            return this.nestedBlock;
        }
        if (this.nestedElements != null && this.nestedElements.size() > 0) {
            return (TemplateElement)this.nestedElements.get(this.nestedElements.size() - 1);
        }
        return null;
    }

    private TemplateElement getFirstLeaf() {
        TemplateElement templateElement = this;
        while (!(templateElement.isLeaf() || templateElement instanceof Macro || templateElement instanceof BlockAssignment)) {
            templateElement = templateElement.getFirstChild();
        }
        return templateElement;
    }

    private TemplateElement getLastLeaf() {
        TemplateElement templateElement = this;
        while (!(templateElement.isLeaf() || templateElement instanceof Macro || templateElement instanceof BlockAssignment)) {
            templateElement = templateElement.getLastChild();
        }
        return templateElement;
    }

    boolean heedsOpeningWhitespace() {
        return false;
    }

    boolean heedsTrailingWhitespace() {
        return false;
    }
}

