/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.BreakInstruction;
import freemarker.core.Case;
import freemarker.core.ComparisonExpression;
import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.TemplateElement;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;

final class SwitchBlock
extends TemplateElement {
    private Case defaultCase;
    private Expression testExpression;

    SwitchBlock(Expression expression) {
        this.testExpression = expression;
        this.nestedElements = new LinkedList();
    }

    void addCase(Case case_) {
        if (case_.isDefault) {
            this.defaultCase = case_;
        }
        this.nestedElements.add(case_);
    }

    void accept(Environment environment) throws TemplateException, IOException {
        boolean bl = false;
        Iterator iterator = this.nestedElements.iterator();
        try {
            while (iterator.hasNext()) {
                Case case_ = (Case)iterator.next();
                boolean bl2 = false;
                if (bl) {
                    bl2 = true;
                } else if (!case_.isDefault) {
                    ComparisonExpression comparisonExpression = new ComparisonExpression(this.testExpression, case_.expression, "==");
                    bl2 = comparisonExpression.isTrue(environment);
                }
                if (!bl2) continue;
                environment.visit(case_);
                bl = true;
            }
            if (!bl && this.defaultCase != null) {
                environment.visit(this.defaultCase);
            }
        }
        catch (BreakInstruction.Break break_) {
            // empty catch block
        }
    }

    public String getCanonicalForm() {
        StringBuffer stringBuffer = new StringBuffer("<#switch ");
        stringBuffer.append(this.testExpression.getCanonicalForm());
        stringBuffer.append(">");
        for (int i = 0; i < this.nestedElements.size(); ++i) {
            Case case_ = (Case)this.nestedElements.get(i);
            stringBuffer.append(case_.getCanonicalForm());
        }
        if (this.defaultCase != null) {
            stringBuffer.append(this.defaultCase.getCanonicalForm());
        }
        stringBuffer.append("</#switch>");
        return stringBuffer.toString();
    }

    public String getDescription() {
        return "switch " + this.testExpression;
    }
}

