/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.FMParser;
import freemarker.core.FMParserTokenManager;
import freemarker.core.ParseException;
import freemarker.core.SimpleCharStream;
import freemarker.core.TemplateElement;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateScalarModel;
import java.io.IOException;
import java.io.StringReader;
import java.util.StringTokenizer;

final class StringLiteral
extends Expression
implements TemplateScalarModel {
    private final String value;
    private TemplateElement interpolatedOutput;

    StringLiteral(String string) {
        this.value = string;
    }

    void checkInterpolation() throws ParseException {
        if (this.value.indexOf("${") >= 0 || this.value.indexOf("#{") >= 0) {
            SimpleCharStream simpleCharStream = new SimpleCharStream(new StringReader(this.value), this.beginLine, this.beginColumn + 1, this.value.length());
            FMParserTokenManager fMParserTokenManager = new FMParserTokenManager(simpleCharStream);
            fMParserTokenManager.onlyTextOutput = true;
            FMParser fMParser = new FMParser(fMParserTokenManager);
            fMParser.template = this.getTemplate();
            this.interpolatedOutput = fMParser.FreeMarkerText();
            this.constantValue = null;
        }
    }

    TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
        return new SimpleScalar(this.getStringValue(environment));
    }

    public String getAsString() {
        return this.value;
    }

    String getStringValue(Environment environment) throws TemplateException {
        if (this.interpolatedOutput == null) {
            return this.value;
        }
        TemplateExceptionHandler templateExceptionHandler = environment.getTemplateExceptionHandler();
        environment.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        try {
            String string = environment.renderElementToString(this.interpolatedOutput);
            return string;
        }
        catch (IOException iOException) {
            throw new TemplateException(iOException, environment);
        }
        finally {
            environment.setTemplateExceptionHandler(templateExceptionHandler);
        }
    }

    public String getCanonicalForm() {
        return "\"" + StringLiteral.escapeString(this.value) + "\"";
    }

    boolean isLiteral() {
        return this.interpolatedOutput == null;
    }

    Expression _deepClone(String string, Expression expression) {
        StringLiteral stringLiteral = new StringLiteral(this.value);
        stringLiteral.interpolatedOutput = this.interpolatedOutput;
        return stringLiteral;
    }

    private static String escapeString(String string) {
        if (string.indexOf(34) == -1) {
            return string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\"", true);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("\"")) {
                stringBuffer.append('\\');
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }
}

