/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.BuiltIn;
import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.FMParser;
import freemarker.core.FMParserTokenManager;
import freemarker.core.NonNumericalException;
import freemarker.core.ParseException;
import freemarker.core.SimpleCharStream;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateException;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import freemarker.template.utility.StringUtil;
import java.io.StringReader;
import java.util.List;
import java.util.StringTokenizer;

abstract class StringBuiltins {
    StringBuiltins() {
    }

    static abstract class StringBuiltIn
    extends BuiltIn {
        StringBuiltIn() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            return this.calculateResult(this.target.getStringValue(environment), environment);
        }

        abstract TemplateModel calculateResult(String var1, Environment var2) throws TemplateException;
    }

    static class cap_firstBI
    extends StringBuiltIn {
        cap_firstBI() {
        }

        TemplateModel calculateResult(String string, Environment environment) {
            int n;
            int n2 = string.length();
            for (n = 0; n < n2 && Character.isWhitespace(string.charAt(n)); ++n) {
            }
            if (n < n2) {
                StringBuffer stringBuffer = new StringBuffer(string);
                stringBuffer.setCharAt(n, Character.toUpperCase(string.charAt(n)));
                string = stringBuffer.toString();
            }
            return new SimpleScalar(string);
        }
    }

    static class capitalizeBI
    extends StringBuiltIn {
        capitalizeBI() {
        }

        TemplateModel calculateResult(String string, Environment environment) {
            return new SimpleScalar(StringUtil.capitalize(string));
        }
    }

    static class chop_linebreakBI
    extends StringBuiltIn {
        chop_linebreakBI() {
        }

        TemplateModel calculateResult(String string, Environment environment) {
            return new SimpleScalar(StringUtil.chomp(string));
        }
    }

    static class evalBI
    extends StringBuiltIn {
        evalBI() {
        }

        TemplateModel calculateResult(String string, Environment environment) throws TemplateException {
            SimpleCharStream simpleCharStream = new SimpleCharStream(new StringReader("(" + string + ")"), this.target.beginLine, this.target.beginColumn, string.length() + 2);
            FMParserTokenManager fMParserTokenManager = new FMParserTokenManager(simpleCharStream);
            fMParserTokenManager.SwitchTo(2);
            FMParser fMParser = new FMParser(fMParserTokenManager);
            fMParser.template = this.getTemplate();
            Expression expression = null;
            try {
                expression = fMParser.Expression();
            }
            catch (ParseException parseException) {
                throw new TemplateException(parseException, environment);
            }
            return expression.getAsTemplateModel(environment);
        }
    }

    static class j_stringBI
    extends StringBuiltIn {
        j_stringBI() {
        }

        TemplateModel calculateResult(String string, Environment environment) {
            return new SimpleScalar(StringUtil.javaStringEnc(string));
        }
    }

    static class js_stringBI
    extends StringBuiltIn {
        js_stringBI() {
        }

        TemplateModel calculateResult(String string, Environment environment) {
            return new SimpleScalar(StringUtil.javaScriptStringEnc(string));
        }
    }

    static class lower_caseBI
    extends StringBuiltIn {
        lower_caseBI() {
        }

        TemplateModel calculateResult(String string, Environment environment) {
            return new SimpleScalar(string.toLowerCase(environment.getLocale()));
        }
    }

    static class numberBI
    extends StringBuiltIn {
        numberBI() {
        }

        TemplateModel calculateResult(String string, Environment environment) throws TemplateException {
            try {
                return new SimpleNumber(environment.getArithmeticEngine().toNumber(string));
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = "Error: " + this.getStartLocation() + "\nExpecting a number here, found: " + string;
                throw new NonNumericalException(string2, environment);
            }
        }
    }

    static class substringBI
    extends StringBuiltIn {
        substringBI() {
        }

        TemplateModel calculateResult(final String string, Environment environment) throws TemplateException {
            return new TemplateMethodModelEx(){

                public Object exec(List list) throws TemplateModelException {
                    int n = list.size();
                    int n2 = 0;
                    int n3 = 0;
                    if (n != 1 && n != 2) {
                        throw new TemplateModelException("Error: +getStartLocation() + \nExpecting 1 or 2 numerical arguments here");
                    }
                    try {
                        TemplateNumberModel templateNumberModel = (TemplateNumberModel)list.get(0);
                        n2 = templateNumberModel.getAsNumber().intValue();
                        if (n == 2) {
                            templateNumberModel = (TemplateNumberModel)list.get(1);
                            n3 = templateNumberModel.getAsNumber().intValue();
                        }
                    }
                    catch (ClassCastException classCastException) {
                        String string2 = "Error: " + substringBI.this.getStartLocation() + "\nExpecting numerical argument here";
                        throw new TemplateModelException(string2);
                    }
                    if (n == 1) {
                        return new SimpleScalar(string.substring(n2));
                    }
                    return new SimpleScalar(string.substring(n2, n3));
                }
            };
        }
    }

    static class uncap_firstBI
    extends StringBuiltIn {
        uncap_firstBI() {
        }

        TemplateModel calculateResult(String string, Environment environment) {
            int n;
            int n2 = string.length();
            for (n = 0; n < n2 && Character.isWhitespace(string.charAt(n)); ++n) {
            }
            if (n < n2) {
                StringBuffer stringBuffer = new StringBuffer(string);
                stringBuffer.setCharAt(n, Character.toLowerCase(string.charAt(n)));
                string = stringBuffer.toString();
            }
            return new SimpleScalar(string);
        }
    }

    static class upper_caseBI
    extends StringBuiltIn {
        upper_caseBI() {
        }

        TemplateModel calculateResult(String string, Environment environment) {
            return new SimpleScalar(string.toUpperCase(environment.getLocale()));
        }
    }

    static class word_listBI
    extends StringBuiltIn {
        word_listBI() {
        }

        TemplateModel calculateResult(String string, Environment environment) {
            SimpleSequence simpleSequence = new SimpleSequence();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                simpleSequence.add(stringTokenizer.nextToken());
            }
            return simpleSequence;
        }
    }
}

