/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.ArithmeticEngine;
import freemarker.core.BuiltIn;
import freemarker.core.Environment;
import freemarker.template.SimpleNumber;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateModelListSequence;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.utility.Constants;
import freemarker.template.utility.StringUtil;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

abstract class SequenceBuiltins {
    SequenceBuiltins() {
    }

    public static boolean modelsEqual(TemplateModel templateModel, TemplateModel templateModel2, Environment environment) throws TemplateModelException {
        if (environment.isClassicCompatible()) {
            if (templateModel == null) {
                templateModel = TemplateScalarModel.EMPTY_STRING;
            }
            if (templateModel2 == null) {
                templateModel2 = TemplateScalarModel.EMPTY_STRING;
            }
        }
        int n = -1;
        if (templateModel instanceof TemplateNumberModel && templateModel2 instanceof TemplateNumberModel) {
            Number number = ((TemplateNumberModel)templateModel).getAsNumber();
            Number number2 = ((TemplateNumberModel)templateModel2).getAsNumber();
            ArithmeticEngine arithmeticEngine = environment != null ? environment.getArithmeticEngine() : environment.getTemplate().getArithmeticEngine();
            try {
                n = arithmeticEngine.compareNumbers(number, number2);
            }
            catch (TemplateException templateException) {
                throw new TemplateModelException(templateException);
            }
        } else if (templateModel instanceof TemplateDateModel && templateModel2 instanceof TemplateDateModel) {
            int n2;
            TemplateDateModel templateDateModel = (TemplateDateModel)templateModel;
            TemplateDateModel templateDateModel2 = (TemplateDateModel)templateModel2;
            int n3 = templateDateModel.getDateType();
            if (n3 != (n2 = templateDateModel2.getDateType())) {
                throw new TemplateModelException("Can not compare dates of different type. Left date is of " + TemplateDateModel.TYPE_NAMES.get(n3) + " type, right date is of " + TemplateDateModel.TYPE_NAMES.get(n2) + " type.");
            }
            if (n3 == 0) {
                throw new TemplateModelException("Left date is of UNKNOWN type, and can not be compared.");
            }
            if (n2 == 0) {
                throw new TemplateModelException("Right date is of UNKNOWN type, and can not be compared.");
            }
            Date date = templateDateModel.getAsDate();
            Date date2 = templateDateModel2.getAsDate();
            n = date.compareTo(date2);
        } else if (templateModel instanceof TemplateScalarModel && templateModel2 instanceof TemplateScalarModel) {
            String string = ((TemplateScalarModel)templateModel).getAsString();
            String string2 = ((TemplateScalarModel)templateModel2).getAsString();
            n = environment.getCollator().compare(string, string2);
        } else if (templateModel instanceof TemplateBooleanModel && templateModel2 instanceof TemplateBooleanModel) {
            boolean bl = ((TemplateBooleanModel)templateModel).getAsBoolean();
            boolean bl2 = ((TemplateBooleanModel)templateModel2).getAsBoolean();
            n = (bl ? 1 : 0) - (bl2 ? 1 : 0);
        }
        return n == 0;
    }

    static abstract class SequenceBuiltIn
    extends BuiltIn {
        SequenceBuiltIn() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            TemplateModel templateModel = this.target.getAsTemplateModel(environment);
            if (!(templateModel instanceof TemplateSequenceModel)) {
                throw SequenceBuiltIn.invalidTypeException(templateModel, this.target, environment, "sequence");
            }
            return this.calculateResult((TemplateSequenceModel)templateModel);
        }

        abstract TemplateModel calculateResult(TemplateSequenceModel var1) throws TemplateModelException;
    }

    static class chunkBI
    extends SequenceBuiltIn {
        chunkBI() {
        }

        TemplateModel calculateResult(TemplateSequenceModel templateSequenceModel) throws TemplateModelException {
            return new BIMethod(templateSequenceModel);
        }

        private static class BIMethod
        implements TemplateMethodModelEx {
            private final TemplateSequenceModel tsm;

            private BIMethod(TemplateSequenceModel templateSequenceModel) {
                this.tsm = templateSequenceModel;
            }

            public Object exec(List list) throws TemplateModelException {
                int n = list.size();
                if (n != 1 && n != 2) {
                    throw new TemplateModelException("?chunk(...) expects 1 or 2 arguments.");
                }
                Object e = list.get(0);
                if (!(e instanceof TemplateNumberModel)) {
                    throw new TemplateModelException("?chunk(...) expects a number as its 1st argument.");
                }
                return new ChunkedSequence(this.tsm, ((TemplateNumberModel)e).getAsNumber().intValue(), n > 1 ? (TemplateModel)list.get(1) : null);
            }
        }

        private static class ChunkedSequence
        implements TemplateSequenceModel {
            private final TemplateSequenceModel wrappedTsm;
            private final int chunkSize;
            private final TemplateModel fillerItem;
            private final int numberOfChunks;

            private ChunkedSequence(TemplateSequenceModel templateSequenceModel, int n, TemplateModel templateModel) throws TemplateModelException {
                if (n < 1) {
                    throw new TemplateModelException("The 1st argument to ?chunk(...) must be at least 1.");
                }
                this.wrappedTsm = templateSequenceModel;
                this.chunkSize = n;
                this.fillerItem = templateModel;
                this.numberOfChunks = (templateSequenceModel.size() + n - 1) / n;
            }

            public TemplateModel get(final int n) throws TemplateModelException {
                if (n >= this.numberOfChunks) {
                    return null;
                }
                return new TemplateSequenceModel(){
                    private final int baseIndex;
                    {
                        this.baseIndex = n * ChunkedSequence.this.chunkSize;
                    }

                    public TemplateModel get(int n3) throws TemplateModelException {
                        int n2 = this.baseIndex + n3;
                        if (n2 < ChunkedSequence.this.wrappedTsm.size()) {
                            return ChunkedSequence.this.wrappedTsm.get(n2);
                        }
                        return n2 < ChunkedSequence.this.numberOfChunks * ChunkedSequence.this.chunkSize ? ChunkedSequence.this.fillerItem : null;
                    }

                    public int size() throws TemplateModelException {
                        return ChunkedSequence.this.fillerItem != null || n + 1 < ChunkedSequence.this.numberOfChunks ? ChunkedSequence.this.chunkSize : ChunkedSequence.this.wrappedTsm.size() - this.baseIndex;
                    }
                };
            }

            public int size() throws TemplateModelException {
                return this.numberOfChunks;
            }
        }
    }

    static class firstBI
    extends SequenceBuiltIn {
        firstBI() {
        }

        TemplateModel calculateResult(TemplateSequenceModel templateSequenceModel) throws TemplateModelException {
            if (templateSequenceModel.size() == 0) {
                return null;
            }
            return templateSequenceModel.get(0);
        }
    }

    static class lastBI
    extends SequenceBuiltIn {
        lastBI() {
        }

        TemplateModel calculateResult(TemplateSequenceModel templateSequenceModel) throws TemplateModelException {
            if (templateSequenceModel.size() == 0) {
                return null;
            }
            return templateSequenceModel.get(templateSequenceModel.size() - 1);
        }
    }

    static class reverseBI
    extends SequenceBuiltIn {
        reverseBI() {
        }

        TemplateModel calculateResult(TemplateSequenceModel templateSequenceModel) {
            if (templateSequenceModel instanceof ReverseSequence) {
                return ((ReverseSequence)templateSequenceModel).seq;
            }
            return new ReverseSequence(templateSequenceModel);
        }

        private static class ReverseSequence
        implements TemplateSequenceModel {
            private final TemplateSequenceModel seq;

            ReverseSequence(TemplateSequenceModel templateSequenceModel) {
                this.seq = templateSequenceModel;
            }

            public int size() throws TemplateModelException {
                return this.seq.size();
            }

            public TemplateModel get(int n) throws TemplateModelException {
                return this.seq.get(this.seq.size() - 1 - n);
            }
        }
    }

    static class seq_containsBI
    extends BuiltIn {
        seq_containsBI() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            TemplateModel templateModel = this.target.getAsTemplateModel(environment);
            if (templateModel instanceof TemplateSequenceModel) {
                return new BIMethodForSequence((TemplateSequenceModel)templateModel, environment);
            }
            if (templateModel instanceof TemplateCollectionModel) {
                return new BIMethodForCollection((TemplateCollectionModel)templateModel, environment);
            }
            throw seq_containsBI.invalidTypeException(templateModel, this.target, environment, "sequence or collection");
        }

        private class BIMethodForCollection
        implements TemplateMethodModelEx {
            private TemplateCollectionModel m_coll;
            private Environment m_env;

            private BIMethodForCollection(TemplateCollectionModel templateCollectionModel, Environment environment) {
                this.m_coll = templateCollectionModel;
                this.m_env = environment;
            }

            public Object exec(List list) throws TemplateModelException {
                if (list.size() != 1) {
                    throw new TemplateModelException("?seq_contains(...) expects one argument.");
                }
                TemplateModel templateModel = (TemplateModel)list.get(0);
                TemplateModelIterator templateModelIterator = this.m_coll.iterator();
                while (templateModelIterator.hasNext()) {
                    if (!SequenceBuiltins.modelsEqual(templateModelIterator.next(), templateModel, this.m_env)) continue;
                    return TemplateBooleanModel.TRUE;
                }
                return TemplateBooleanModel.FALSE;
            }
        }

        private class BIMethodForSequence
        implements TemplateMethodModelEx {
            private TemplateSequenceModel m_seq;
            private Environment m_env;

            private BIMethodForSequence(TemplateSequenceModel templateSequenceModel, Environment environment) {
                this.m_seq = templateSequenceModel;
                this.m_env = environment;
            }

            public Object exec(List list) throws TemplateModelException {
                if (list.size() != 1) {
                    throw new TemplateModelException("?seq_contains(...) expects one argument.");
                }
                TemplateModel templateModel = (TemplateModel)list.get(0);
                int n = this.m_seq.size();
                for (int i = 0; i < n; ++i) {
                    if (!SequenceBuiltins.modelsEqual(this.m_seq.get(i), templateModel, this.m_env)) continue;
                    return TemplateBooleanModel.TRUE;
                }
                return TemplateBooleanModel.FALSE;
            }
        }
    }

    static class seq_index_ofBI
    extends BuiltIn {
        private int m_dir;

        public seq_index_ofBI(int n) {
            this.m_dir = n;
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            TemplateModel templateModel = this.target.getAsTemplateModel(environment);
            if (!(templateModel instanceof TemplateSequenceModel)) {
                throw seq_index_ofBI.invalidTypeException(templateModel, this.target, environment, "sequence");
            }
            return new BIMethod((TemplateSequenceModel)templateModel, environment);
        }

        private class BIMethod
        implements TemplateMethodModelEx {
            private TemplateSequenceModel m_seq;
            private Environment m_env;

            private BIMethod(TemplateSequenceModel templateSequenceModel, Environment environment) {
                this.m_seq = templateSequenceModel;
                this.m_env = environment;
            }

            public Object exec(List list) throws TemplateModelException {
                int n;
                int n2 = list.size();
                if (n2 != 1 && n2 != 2) {
                    throw new TemplateModelException(this.getBuiltinTemplate() + " expects 1 or 2 arguments.");
                }
                int n3 = this.m_seq.size();
                TemplateModel templateModel = (TemplateModel)list.get(0);
                if (n2 > 1) {
                    Object e = list.get(1);
                    if (!(e instanceof TemplateNumberModel)) {
                        throw new TemplateModelException(this.getBuiltinTemplate() + "expects a number as its second argument.");
                    }
                    n = ((TemplateNumberModel)e).getAsNumber().intValue();
                    if (seq_index_ofBI.this.m_dir == 1) {
                        if (n >= n3) {
                            return Constants.MINUS_ONE;
                        }
                        if (n < 0) {
                            n = 0;
                        }
                    } else {
                        if (n >= n3) {
                            n = n3 - 1;
                        }
                        if (n < 0) {
                            return Constants.MINUS_ONE;
                        }
                    }
                } else {
                    n = seq_index_ofBI.this.m_dir == 1 ? 0 : n3 - 1;
                }
                if (seq_index_ofBI.this.m_dir == 1) {
                    for (int i = n; i < n3; ++i) {
                        if (!SequenceBuiltins.modelsEqual(this.m_seq.get(i), templateModel, this.m_env)) continue;
                        return new SimpleNumber(i);
                    }
                } else {
                    for (int i = n; i >= 0; --i) {
                        if (!SequenceBuiltins.modelsEqual(this.m_seq.get(i), templateModel, this.m_env)) continue;
                        return new SimpleNumber(i);
                    }
                }
                return Constants.MINUS_ONE;
            }

            private String getBuiltinTemplate() {
                if (seq_index_ofBI.this.m_dir == 1) {
                    return "?seq_indexOf(...)";
                }
                return "?seq_lastIndexOf(...)";
            }
        }
    }

    static class sortBI
    extends SequenceBuiltIn {
        static final int KEY_TYPE_STRING = 1;
        static final int KEY_TYPE_NUMBER = 2;
        static final int KEY_TYPE_DATE = 3;

        sortBI() {
        }

        TemplateModel calculateResult(TemplateSequenceModel templateSequenceModel) throws TemplateModelException {
            return sortBI.sort(templateSequenceModel, null);
        }

        static String startErrorMessage(Object object) {
            return (object == null ? "?sort" : "?sort_by(...)") + " failed: ";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static TemplateSequenceModel sort(TemplateSequenceModel templateSequenceModel, String[] stringArray) throws TemplateModelException {
            Object object;
            int n;
            int n2;
            int n3;
            int n4 = templateSequenceModel.size();
            if (n4 == 0) {
                return templateSequenceModel;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>(n4);
            TemplateModel templateModel = templateSequenceModel.get(0);
            if (stringArray != null) {
                n3 = stringArray.length;
                if (n3 == 0) {
                    stringArray = null;
                } else {
                    for (n2 = 0; n2 < n3; ++n2) {
                        if (!(templateModel instanceof TemplateHashModel)) {
                            throw new TemplateModelException(sortBI.startErrorMessage(stringArray) + (n2 == 0 ? "You can't use ?sort_by when the sequence items are not hashes." : "The subvariable " + StringUtil.jQuote(stringArray[n2 - 1]) + " is not a hash, so ?sort_by " + "can't proceed by getting the " + StringUtil.jQuote(stringArray[n2]) + " subvariable."));
                        }
                        if ((templateModel = ((TemplateHashModel)templateModel).get(stringArray[n2])) != null) continue;
                        throw new TemplateModelException(sortBI.startErrorMessage(stringArray) + "The " + StringUtil.jQuote(stringArray[n2]) + " subvariable " + (n3 == 1 ? "was not found." : "(specified by ?sort_by argument number " + (n2 + 1) + ") was not found."));
                    }
                }
            } else {
                n3 = 0;
            }
            if (templateModel instanceof TemplateScalarModel) {
                n = 1;
            } else if (templateModel instanceof TemplateNumberModel) {
                n = 2;
            } else {
                if (!(templateModel instanceof TemplateDateModel)) throw new TemplateModelException(sortBI.startErrorMessage(stringArray) + "Values used for sorting must be numbers, strings, or date/time values.");
                n = 3;
            }
            if (stringArray == null) {
                if (n == 1) {
                    for (n2 = 0; n2 < n4; ++n2) {
                        templateModel = templateSequenceModel.get(n2);
                        try {
                            arrayList.add(new KVP(((TemplateScalarModel)templateModel).getAsString(), templateModel));
                            continue;
                        }
                        catch (ClassCastException classCastException) {
                            if (templateModel instanceof TemplateScalarModel) throw classCastException;
                            throw new TemplateModelException(sortBI.startErrorMessage(stringArray) + "All values in the sequence must be " + "strings, because the first value " + "was a string. " + "The value at index " + n2 + " is not string.");
                        }
                    }
                } else if (n == 2) {
                    for (n2 = 0; n2 < n4; ++n2) {
                        templateModel = templateSequenceModel.get(n2);
                        try {
                            arrayList.add(new KVP(((TemplateNumberModel)templateModel).getAsNumber(), templateModel));
                            continue;
                        }
                        catch (ClassCastException classCastException) {
                            if (templateModel instanceof TemplateNumberModel) throw classCastException;
                            throw new TemplateModelException(sortBI.startErrorMessage(stringArray) + "All values in the sequence must be " + "numbers, because the first value " + "was a number. " + "The value at index " + n2 + " is not number.");
                        }
                    }
                } else {
                    if (n != 3) throw new RuntimeException("FreeMarker bug: Bad key type");
                    for (n2 = 0; n2 < n4; ++n2) {
                        templateModel = templateSequenceModel.get(n2);
                        try {
                            arrayList.add(new KVP(((TemplateDateModel)templateModel).getAsDate(), templateModel));
                            continue;
                        }
                        catch (ClassCastException classCastException) {
                            if (templateModel instanceof TemplateNumberModel) throw classCastException;
                            throw new TemplateModelException(sortBI.startErrorMessage(stringArray) + "All values in the sequence must be " + "date/time values, because the first " + "value was a date/time. " + "The value at index " + n2 + " is not date/time.");
                        }
                    }
                }
            } else {
                for (n2 = 0; n2 < n4; ++n2) {
                    templateModel = templateSequenceModel.get(n2);
                    object = templateModel;
                    for (int i = 0; i < n3; ++i) {
                        try {
                            object = ((TemplateHashModel)object).get(stringArray[i]);
                        }
                        catch (ClassCastException classCastException) {
                            if (object instanceof TemplateHashModel) throw classCastException;
                            throw new TemplateModelException(sortBI.startErrorMessage(stringArray) + "Problem with the sequence item at index " + n2 + ": " + "Can't get the " + StringUtil.jQuote(stringArray[i]) + " subvariable, because the value is not a hash.");
                        }
                        if (object != null) continue;
                        throw new TemplateModelException(sortBI.startErrorMessage(stringArray) + "Problem with the sequence item at index " + n2 + ": " + "The " + StringUtil.jQuote(stringArray[i]) + " subvariable was not found.");
                    }
                    if (n == 1) {
                        try {
                            arrayList.add(new KVP(((TemplateScalarModel)object).getAsString(), templateModel));
                            continue;
                        }
                        catch (ClassCastException classCastException) {
                            if (object instanceof TemplateScalarModel) throw classCastException;
                            throw new TemplateModelException(sortBI.startErrorMessage(stringArray) + "All key values in the sequence must be " + "date/time values, because the first key " + "value was a date/time. The key value at " + "index " + n2 + " is not a date/time.");
                        }
                    }
                    if (n == 2) {
                        try {
                            arrayList.add(new KVP(((TemplateNumberModel)object).getAsNumber(), templateModel));
                            continue;
                        }
                        catch (ClassCastException classCastException) {
                            if (object instanceof TemplateNumberModel) continue;
                            throw new TemplateModelException(sortBI.startErrorMessage(stringArray) + "All key values in the sequence must be " + "numbers, because the first key " + "value was a number. The key value at " + "index " + n2 + " is not a number.");
                        }
                    }
                    if (n != 3) throw new RuntimeException("FreeMarker bug: Bad key type");
                    try {
                        arrayList.add(new KVP(((TemplateDateModel)object).getAsDate(), templateModel));
                        continue;
                    }
                    catch (ClassCastException classCastException) {
                        if (object instanceof TemplateDateModel) continue;
                        throw new TemplateModelException(sortBI.startErrorMessage(stringArray) + "All key values in the sequence must be " + "dates, because the first key " + "value was a date. The key value at " + "index " + n2 + " is not a date.");
                    }
                }
            }
            if (n == 1) {
                object = new LexicalKVPComparator(Environment.getCurrentEnvironment().getCollator());
            } else if (n == 2) {
                object = new NumericalKVPComparator(Environment.getCurrentEnvironment().getArithmeticEngine());
            } else {
                if (n != 3) throw new RuntimeException("FreeMarker bug: Bad key type");
                object = new DateKVPComparator();
            }
            try {
                Collections.sort(arrayList, object);
            }
            catch (ClassCastException classCastException) {
                throw new TemplateModelException(sortBI.startErrorMessage(stringArray) + "Unexpected error while sorting:" + classCastException, classCastException);
            }
            for (n2 = 0; n2 < n4; ++n2) {
                arrayList.set(n2, ((KVP)arrayList.get(n2)).value);
            }
            return new TemplateModelListSequence(arrayList);
        }

        private static class DateKVPComparator
        implements Comparator {
            private DateKVPComparator() {
            }

            public int compare(Object object, Object object2) {
                return ((Date)((KVP)object).key).compareTo((Date)((KVP)object2).key);
            }
        }

        private static class KVP {
            private Object key;
            private Object value;

            private KVP(Object object, Object object2) {
                this.key = object;
                this.value = object2;
            }
        }

        private static class LexicalKVPComparator
        implements Comparator {
            private Collator collator;

            LexicalKVPComparator(Collator collator) {
                this.collator = collator;
            }

            public int compare(Object object, Object object2) {
                return this.collator.compare(((KVP)object).key, ((KVP)object2).key);
            }
        }

        private static class NumericalKVPComparator
        implements Comparator {
            private ArithmeticEngine ae;

            private NumericalKVPComparator(ArithmeticEngine arithmeticEngine) {
                this.ae = arithmeticEngine;
            }

            public int compare(Object object, Object object2) {
                try {
                    return this.ae.compareNumbers((Number)((KVP)object).key, (Number)((KVP)object2).key);
                }
                catch (TemplateException templateException) {
                    throw new ClassCastException("Failed to compare numbers: " + templateException);
                }
            }
        }
    }

    static class sort_byBI
    extends sortBI {
        sort_byBI() {
        }

        TemplateModel calculateResult(TemplateSequenceModel templateSequenceModel) {
            return new BIMethod(templateSequenceModel);
        }

        static class BIMethod
        implements TemplateMethodModelEx {
            TemplateSequenceModel seq;

            BIMethod(TemplateSequenceModel templateSequenceModel) {
                this.seq = templateSequenceModel;
            }

            public Object exec(List list) throws TemplateModelException {
                String[] stringArray;
                if (list.size() == 0) {
                    throw new TemplateModelException("?sort_by(key) needs exactly 1 argument.");
                }
                Object e = list.get(0);
                if (e instanceof TemplateScalarModel) {
                    stringArray = new String[]{((TemplateScalarModel)e).getAsString()};
                } else if (e instanceof TemplateSequenceModel) {
                    TemplateSequenceModel templateSequenceModel = (TemplateSequenceModel)e;
                    int n = templateSequenceModel.size();
                    stringArray = new String[n];
                    for (int i = 0; i < n; ++i) {
                        TemplateModel templateModel = templateSequenceModel.get(i);
                        try {
                            stringArray[i] = ((TemplateScalarModel)templateModel).getAsString();
                            continue;
                        }
                        catch (ClassCastException classCastException) {
                            if (templateModel instanceof TemplateScalarModel) continue;
                            throw new TemplateModelException("The argument to ?sort_by(key), when it is a sequence, must be a sequence of strings, but the item at index " + i + " is not a string.");
                        }
                    }
                } else {
                    throw new TemplateModelException("The argument to ?sort_by(key) must be a string (the name of the subvariable), or a sequence of strings (the \"path\" to the subvariable).");
                }
                return sortBI.sort(this.seq, stringArray);
            }
        }
    }
}

