/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.Macro;
import freemarker.core.TemplateElement;
import freemarker.template.TemplateException;

public final class ReturnInstruction
extends TemplateElement {
    private Expression exp;

    ReturnInstruction(Expression expression) {
        this.exp = expression;
    }

    void accept(Environment environment) throws TemplateException {
        if (this.exp != null) {
            environment.setLastReturnValue(this.exp.getAsTemplateModel(environment));
        }
        if (this.nextSibling() != null) {
            throw new Return();
        }
        if (!(this.getParent() instanceof Macro) && !(this.getParent().getParent() instanceof Macro)) {
            throw new Return();
        }
    }

    public String getCanonicalForm() {
        String string = this.exp == null ? "" : " " + this.exp.getCanonicalForm();
        return "<#return" + string + "/>";
    }

    public String getDescription() {
        return "return [" + this.getStartLocation() + "]";
    }

    public static class Return
    extends RuntimeException {
        Return() {
        }
    }
}

