/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.BuiltIn;
import freemarker.core.Environment;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.utility.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

abstract class RegexBuiltins {
    static HashMap patternLookup = new HashMap();
    static LinkedList patterns = new LinkedList();
    static final int PATTERN_CACHE_SIZE = 100;

    RegexBuiltins() {
    }

    static Pattern getPattern(String string, String string2) throws TemplateModelException {
        int n = 0;
        String string3 = string + '\u0000' + string2;
        Pattern pattern = (Pattern)patternLookup.get(string3);
        if (pattern != null) {
            return pattern;
        }
        if (string2 == null || string2.length() == 0) {
            try {
                pattern = Pattern.compile(string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new TemplateModelException(patternSyntaxException);
            }
        }
        if (string2.indexOf(105) >= 0) {
            n |= 2;
        }
        if (string2.indexOf(109) >= 0) {
            n |= 8;
        }
        if (string2.indexOf(99) >= 0) {
            n |= 4;
        }
        if (string2.indexOf(115) >= 0) {
            n |= 0x20;
        }
        try {
            pattern = Pattern.compile(string, n);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new TemplateModelException(patternSyntaxException);
        }
        patterns.add(string3);
        patternLookup.put(string3, pattern);
        if (patterns.size() > 100) {
            Object e = patterns.removeFirst();
            patterns.remove(e);
        }
        return pattern;
    }

    static class MatcherBuilder
    implements TemplateMethodModel {
        String matchString;

        MatcherBuilder(TemplateScalarModel templateScalarModel) throws TemplateModelException {
            this.matchString = templateScalarModel.getAsString();
        }

        public Object exec(List list) throws TemplateModelException {
            int n = list.size();
            if (n == 0) {
                throw new TemplateModelException("Expecting at least one argument");
            }
            if (n > 2) {
                throw new TemplateModelException("Expecting at most two argumnets");
            }
            String string = (String)list.get(0);
            String string2 = n > 1 ? (String)list.get(1) : "";
            Pattern pattern = RegexBuiltins.getPattern(string, string2);
            Matcher matcher = pattern.matcher(this.matchString);
            return new RegexMatchModel(matcher, this.matchString);
        }
    }

    static class RegexMatchModel
    implements TemplateBooleanModel,
    TemplateCollectionModel,
    TemplateSequenceModel {
        Matcher matcher;
        String input;
        String matchedString;
        final boolean matches;
        TemplateSequenceModel groups;
        private ArrayList data;

        RegexMatchModel(Matcher matcher, String string) {
            this.matcher = matcher;
            this.input = string;
            this.matches = matcher.matches();
            if (this.matches) {
                this.matchedString = string.substring(matcher.start(), matcher.end());
            }
        }

        public boolean getAsBoolean() {
            return this.matches;
        }

        public TemplateModel get(int n) throws TemplateModelException {
            if (this.data == null) {
                this.initSequence();
            }
            return (TemplateModel)this.data.get(n);
        }

        public int size() throws TemplateModelException {
            if (this.data == null) {
                this.initSequence();
            }
            return this.data.size();
        }

        private void initSequence() throws TemplateModelException {
            this.data = new ArrayList();
            TemplateModelIterator templateModelIterator = this.iterator();
            while (templateModelIterator.hasNext()) {
                this.data.add(templateModelIterator.next());
            }
        }

        public TemplateModel getGroups() {
            if (this.groups == null) {
                this.groups = new TemplateSequenceModel(){

                    public int size() throws TemplateModelException {
                        try {
                            return RegexMatchModel.this.matcher.groupCount() + 1;
                        }
                        catch (Exception exception) {
                            throw new TemplateModelException(exception);
                        }
                    }

                    public TemplateModel get(int n) throws TemplateModelException {
                        try {
                            return new SimpleScalar(RegexMatchModel.this.matcher.group(n));
                        }
                        catch (Exception exception) {
                            throw new TemplateModelException(exception);
                        }
                    }
                };
            }
            return this.groups;
        }

        public TemplateModelIterator iterator() {
            this.matcher.reset();
            return new TemplateModelIterator(){
                boolean hasFindInfo;
                {
                    this.hasFindInfo = RegexMatchModel.this.matcher.find();
                }

                public boolean hasNext() {
                    return this.hasFindInfo;
                }

                public TemplateModel next() throws TemplateModelException {
                    if (!this.hasNext()) {
                        throw new TemplateModelException("No more matches");
                    }
                    Match match = new Match();
                    this.hasFindInfo = RegexMatchModel.this.matcher.find();
                    return match;
                }
            };
        }

        class Match
        implements TemplateScalarModel {
            String match;
            SimpleSequence subs = new SimpleSequence();

            Match() {
                this.match = RegexMatchModel.this.input.substring(RegexMatchModel.this.matcher.start(), RegexMatchModel.this.matcher.end());
                for (int i = 0; i < RegexMatchModel.this.matcher.groupCount() + 1; ++i) {
                    this.subs.add(RegexMatchModel.this.matcher.group(i));
                }
            }

            public String getAsString() {
                return this.match;
            }
        }
    }

    static class ReplaceMethod
    implements TemplateMethodModel {
        private String s;

        ReplaceMethod(String string) {
            this.s = string;
        }

        public Object exec(List list) throws TemplateModelException {
            int n = list.size();
            if (n < 2 || n > 3) {
                throw new TemplateModelException("?replace(...) needs 2 or 3 arguments.");
            }
            String string = (String)list.get(0);
            String string2 = (String)list.get(1);
            String string3 = n > 2 ? (String)list.get(2) : "";
            boolean bl = string3.indexOf(105) >= 0;
            boolean bl2 = string3.indexOf(114) >= 0;
            boolean bl3 = string3.indexOf(102) >= 0;
            String string4 = null;
            if (!bl2) {
                string4 = StringUtil.replace(this.s, string, string2, bl, bl3);
            } else {
                Pattern pattern = RegexBuiltins.getPattern(string, string3);
                Matcher matcher = pattern.matcher(this.s);
                string4 = bl3 ? matcher.replaceFirst(string2) : matcher.replaceAll(string2);
            }
            return new SimpleScalar(string4);
        }
    }

    static class SplitMethod
    implements TemplateMethodModel {
        private String s;

        SplitMethod(String string) {
            this.s = string;
        }

        public Object exec(List list) throws TemplateModelException {
            int n = list.size();
            if (n < 1 || n > 2) {
                throw new TemplateModelException("?replace(...) needs 1 or 2 arguments.");
            }
            String string = (String)list.get(0);
            String string2 = n > 1 ? (String)list.get(1) : "";
            boolean bl = string2.indexOf(105) >= 0;
            boolean bl2 = string2.indexOf(114) >= 0;
            String[] stringArray = null;
            if (!bl2) {
                stringArray = StringUtil.split(this.s, string, bl);
            } else {
                Pattern pattern = RegexBuiltins.getPattern(string, string2);
                stringArray = pattern.split(this.s);
            }
            return ObjectWrapper.DEFAULT_WRAPPER.wrap(stringArray);
        }
    }

    static class groupsBI
    extends BuiltIn {
        groupsBI() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            TemplateModel templateModel = this.target.getAsTemplateModel(environment);
            groupsBI.assertNonNull(templateModel, this, environment);
            if (templateModel instanceof RegexMatchModel) {
                return ((RegexMatchModel)templateModel).getGroups();
            }
            if (templateModel instanceof RegexMatchModel.Match) {
                return ((RegexMatchModel.Match)templateModel).subs;
            }
            throw groupsBI.invalidTypeException(templateModel, this.target, environment, "a regular expression matcher");
        }
    }

    static class matchesBI
    extends BuiltIn {
        matchesBI() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            TemplateModel templateModel = this.target.getAsTemplateModel(environment);
            matchesBI.assertNonNull(templateModel, this, environment);
            if (!(templateModel instanceof TemplateScalarModel)) {
                throw matchesBI.invalidTypeException(templateModel, this.target, environment, "string");
            }
            return new MatcherBuilder((TemplateScalarModel)templateModel);
        }
    }

    static class replace_reBI
    extends BuiltIn {
        replace_reBI() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            TemplateModel templateModel = this.target.getAsTemplateModel(environment);
            if (templateModel instanceof TemplateScalarModel) {
                return new ReplaceMethod(((TemplateScalarModel)templateModel).getAsString());
            }
            throw replace_reBI.invalidTypeException(templateModel, this.target, environment, "string");
        }
    }

    static class split_reBI
    extends BuiltIn {
        split_reBI() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            TemplateModel templateModel = this.target.getAsTemplateModel(environment);
            if (templateModel instanceof TemplateScalarModel) {
                return new SplitMethod(((TemplateScalarModel)templateModel).getAsString());
            }
            throw split_reBI.invalidTypeException(templateModel, this.target, environment, "string");
        }
    }
}

