/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.ListLiteral;
import freemarker.core.StringLiteral;
import freemarker.core.TemplateElement;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateNodeModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import java.io.IOException;

final class RecurseNode
extends TemplateElement {
    Expression targetNode;
    Expression namespaces;

    RecurseNode(Expression expression, Expression expression2) {
        this.targetNode = expression;
        this.namespaces = expression2;
    }

    void accept(Environment environment) throws IOException, TemplateException {
        TemplateModel templateModel;
        TemplateModel templateModel2 = this.targetNode == null ? null : this.targetNode.getAsTemplateModel(environment);
        TemplateModel templateModel3 = templateModel = this.namespaces == null ? null : this.namespaces.getAsTemplateModel(environment);
        if (this.namespaces instanceof StringLiteral) {
            templateModel = environment.importLib(((TemplateScalarModel)templateModel).getAsString(), null);
        } else if (this.namespaces instanceof ListLiteral) {
            templateModel = ((ListLiteral)this.namespaces).evaluateStringsToNamespaces(environment);
        }
        if (templateModel2 != null && !(templateModel2 instanceof TemplateNodeModel)) {
            throw new TemplateException("Expecting an XML node here, for expression: " + this.targetNode + ", found a: " + templateModel2.getClass().getName(), environment);
        }
        if (templateModel != null) {
            if (templateModel instanceof TemplateHashModel) {
                SimpleSequence simpleSequence = new SimpleSequence(1);
                simpleSequence.add(templateModel);
                templateModel = simpleSequence;
            } else if (!(templateModel instanceof TemplateSequenceModel)) {
                throw new TemplateException("Expecting a sequence of namespaces after 'using'", environment);
            }
        }
        environment.recurse((TemplateNodeModel)templateModel2, (TemplateSequenceModel)templateModel);
    }

    public String getCanonicalForm() {
        String string = "<#recurse";
        if (this.targetNode != null) {
            string = string + " " + this.targetNode.getCanonicalForm();
        }
        if (this.namespaces != null) {
            string = string + " using " + this.namespaces.getCanonicalForm();
        }
        return string + "/>";
    }

    public String getDescription() {
        return "recurse instruction";
    }
}

