/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.EvaluationUtil;
import freemarker.core.Expression;
import freemarker.core.NonBooleanException;
import freemarker.core.NumericalRange;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;

final class Range
extends Expression {
    final Expression left;
    final Expression right;

    Range(Expression expression, Expression expression2) {
        this.left = expression;
        this.right = expression2;
    }

    boolean hasRhs() {
        return this.right != null;
    }

    TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
        int n = EvaluationUtil.getNumber(this.left, environment).intValue();
        int n2 = 0;
        if (this.right != null) {
            n2 = EvaluationUtil.getNumber(this.right, environment).intValue();
            return new NumericalRange(n, n2);
        }
        return new NumericalRange(n);
    }

    boolean isTrue(Environment environment) throws TemplateException {
        String string = "Error " + this.getStartLocation() + ". " + "\nExpecting a boolean here." + " Expression " + this + " is a range.";
        throw new NonBooleanException(string, environment);
    }

    public String getCanonicalForm() {
        String string = this.right != null ? this.right.getCanonicalForm() : "";
        return this.left.getCanonicalForm() + ".." + string;
    }

    boolean isLiteral() {
        boolean bl = this.right == null || this.right.isLiteral();
        return this.constantValue != null || this.left.isLiteral() && bl;
    }

    Expression _deepClone(String string, Expression expression) {
        return new Range(this.left.deepClone(string, expression), this.right.deepClone(string, expression));
    }
}

