/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.ParseException;
import freemarker.core.TemplateElement;
import freemarker.template.Template;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;

final class PropertySetting
extends TemplateElement {
    private final String key;
    private final Expression value;

    PropertySetting(String string, Expression expression) {
        this.key = string;
        this.value = expression;
    }

    void setLocation(Template template, int n, int n2, int n3, int n4) throws ParseException {
        super.setLocation(template, n, n2, n3, n4);
        if (!(this.key.equals("locale") || this.key.equals("number_format") || this.key.equals("time_format") || this.key.equals("date_format") || this.key.equals("datetime_format") || this.key.equals("time_zone") || this.key.equals("boolean_format") || this.key.equals("classic_compatible") || this.key.equals("url_escaping_charset"))) {
            throw new ParseException("Error " + this.getStartLocation() + "\nInvalid setting name, or it is not allowed to change " + "the value of the setting with FTL: " + this.key, n2, n);
        }
    }

    void accept(Environment environment) throws TemplateException {
        TemplateModel templateModel = this.value.getAsTemplateModel(environment);
        String string = templateModel instanceof TemplateScalarModel ? ((TemplateScalarModel)templateModel).getAsString() : (templateModel instanceof TemplateBooleanModel ? (((TemplateBooleanModel)templateModel).getAsBoolean() ? "true" : "false") : (templateModel instanceof TemplateNumberModel ? ((TemplateNumberModel)templateModel).getAsNumber().toString() : this.value.getStringValue(environment)));
        environment.setSetting(this.key, string);
    }

    public String getCanonicalForm() {
        return "<#setting " + this.key + "=" + this.value.getCanonicalForm() + "/>";
    }

    public String getDescription() {
        return "setting " + this.key + " set to " + "\"" + this.value + "\" " + "[" + this.getStartLocation() + "]";
    }
}

