/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.FMParserConstants;
import freemarker.core.TemplateObject;
import freemarker.core.Token;
import freemarker.template.utility.SecurityUtilities;
import java.io.IOException;

public class ParseException
extends IOException
implements FMParserConstants {
    protected boolean specialConstructor;
    public Token currentToken;
    public int columnNumber;
    public int lineNumber;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    protected String eol = SecurityUtilities.getSystemProperty("line.separator", "\n");

    public ParseException(Token token, int[][] nArray, String[] stringArray) {
        super("");
        this.specialConstructor = true;
        this.currentToken = token;
        this.expectedTokenSequences = nArray;
        this.tokenImage = stringArray;
    }

    protected ParseException() {
        this.specialConstructor = false;
    }

    public ParseException(String string, int n, int n2) {
        super(string);
        this.specialConstructor = false;
        this.lineNumber = n;
        this.columnNumber = n2;
    }

    public ParseException(String string, TemplateObject templateObject) {
        super(string);
        this.specialConstructor = false;
        this.lineNumber = templateObject.beginLine;
        this.columnNumber = templateObject.beginColumn;
    }

    public String getMessage() {
        int n;
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        String string = this.customGetMessage();
        if (string != null) {
            return string;
        }
        String string2 = "";
        int n2 = 0;
        for (int i = 0; i < this.expectedTokenSequences.length; ++i) {
            if (n2 < this.expectedTokenSequences[i].length) {
                n2 = this.expectedTokenSequences[i].length;
            }
            for (n = 0; n < this.expectedTokenSequences[i].length; ++n) {
                string2 = string2 + this.tokenImage[this.expectedTokenSequences[i][n]] + " ";
            }
            if (this.expectedTokenSequences[i][this.expectedTokenSequences[i].length - 1] != 0) {
                string2 = string2 + "...";
            }
            string2 = string2 + this.eol + "    ";
        }
        string = "Encountered \"";
        Token token = this.currentToken.next;
        for (n = 0; n < n2; ++n) {
            if (n != 0) {
                string = string + " ";
            }
            if (token.kind == 0) {
                string = string + this.tokenImage[0];
                break;
            }
            string = string + this.add_escapes(token.image);
            token = token.next;
        }
        string = string + "\" at line " + this.currentToken.next.beginLine + ", column " + this.currentToken.next.beginColumn;
        string = string + "." + this.eol;
        string = this.expectedTokenSequences.length == 1 ? string + "Was expecting:" + this.eol + "    " : string + "Was expecting one of:" + this.eol + "    ";
        string = string + string2;
        return string;
    }

    public int getLineNumber() {
        return this.currentToken != null ? this.currentToken.next.beginLine : this.lineNumber;
    }

    public int getColumnNumber() {
        return this.currentToken != null ? this.currentToken.next.beginColumn : this.columnNumber;
    }

    private String customGetMessage() {
        Token token = this.currentToken.next;
        int n = token.kind;
        if (n == 0) {
            StringBuffer stringBuffer = new StringBuffer("Unexpected end of file reached.\n");
            block12: for (int i = 0; i < this.expectedTokenSequences.length; ++i) {
                int[] nArray = this.expectedTokenSequences[i];
                switch (nArray[0]) {
                    case 35: {
                        stringBuffer.append("Unclosed foreach directive.\n");
                        continue block12;
                    }
                    case 32: {
                        stringBuffer.append("Unclosed list directive.\n");
                        continue block12;
                    }
                    case 43: {
                        stringBuffer.append("Unclosed switch directive.\n");
                        continue block12;
                    }
                    case 31: {
                        stringBuffer.append("Unclosed if directive.\n");
                        continue block12;
                    }
                    case 41: {
                        stringBuffer.append("Unclosed compress directive.\n");
                        continue block12;
                    }
                    case 40: {
                        stringBuffer.append("Unclosed macro directive.\n");
                        continue block12;
                    }
                    case 39: {
                        stringBuffer.append("Unclosed function directive.\n");
                        continue block12;
                    }
                    case 42: {
                        stringBuffer.append("Unclosed transform directive.\n");
                        continue block12;
                    }
                    case 60: {
                        stringBuffer.append("Unclosed escape directive.\n");
                        continue block12;
                    }
                    case 62: {
                        stringBuffer.append("Unclosed noescape directive.\n");
                    }
                }
            }
            return stringBuffer.toString();
        }
        if (n == 31 || n == 9 || n == 44) {
            return "Found unexpected directive: " + token + " on line " + token.beginLine + ", column " + token.beginColumn + "\nCheck whether you have a well-formed if-else block.";
        }
        return null;
    }

    protected String add_escapes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block11: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block11;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block11;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block11;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block11;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block11;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    continue block11;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block11;
                }
                default: {
                    char c = string.charAt(i);
                    if (c < ' ' || c > '~') {
                        String string2 = "0000" + Integer.toString(c, 16);
                        stringBuffer.append("\\u" + string2.substring(string2.length() - 4, string2.length()));
                        continue block11;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }
}

