/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.template.SimpleNumber;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateSequenceModel;
import java.io.Serializable;

class NumericalRange
implements TemplateSequenceModel,
Serializable {
    private int lower;
    private int upper;
    private boolean descending;
    private boolean norhs;

    public NumericalRange(int n) {
        this.norhs = true;
        this.lower = n;
    }

    public NumericalRange(int n, int n2) {
        this.lower = Math.min(n, n2);
        this.upper = Math.max(n, n2);
        this.descending = n != this.lower;
    }

    public TemplateModel get(int n) throws TemplateModelException {
        int n2;
        int n3 = n2 = this.descending ? this.upper - n : this.lower + n;
        if (this.norhs && n2 > this.upper || n2 < this.lower) {
            throw new TemplateModelException("out of bounds of range");
        }
        return new SimpleNumber(n2);
    }

    public int size() {
        return 1 + this.upper - this.lower;
    }

    boolean hasRhs() {
        return !this.norhs;
    }
}

