/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.EvaluationUtil;
import freemarker.core.Expression;
import freemarker.core.TemplateElement;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Locale;

final class NumericalOutput
extends TemplateElement {
    private final Expression expression;
    private final boolean hasFormat;
    private final int minFracDigits;
    private final int maxFracDigits;
    private volatile FormatHolder formatCache;

    NumericalOutput(Expression expression) {
        this.expression = expression;
        this.hasFormat = false;
        this.minFracDigits = 0;
        this.maxFracDigits = 0;
    }

    NumericalOutput(Expression expression, int n, int n2) {
        this.expression = expression;
        this.hasFormat = true;
        this.minFracDigits = n;
        this.maxFracDigits = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void accept(Environment environment) throws TemplateException, IOException {
        Number number = EvaluationUtil.getNumber(this.expression, environment);
        FormatHolder formatHolder = this.formatCache;
        if (formatHolder == null || !formatHolder.locale.equals(environment.getLocale())) {
            NumericalOutput numericalOutput = this;
            synchronized (numericalOutput) {
                formatHolder = this.formatCache;
                if (formatHolder == null || !formatHolder.locale.equals(environment.getLocale())) {
                    NumberFormat numberFormat = NumberFormat.getNumberInstance(environment.getLocale());
                    if (this.hasFormat) {
                        numberFormat.setMinimumFractionDigits(this.minFracDigits);
                        numberFormat.setMaximumFractionDigits(this.maxFracDigits);
                    } else {
                        numberFormat.setMinimumFractionDigits(0);
                        numberFormat.setMaximumFractionDigits(50);
                    }
                    numberFormat.setGroupingUsed(false);
                    formatHolder = this.formatCache = new FormatHolder(numberFormat, environment.getLocale());
                }
            }
        }
        environment.getOut().write(formatHolder.format.format(number));
    }

    public String getCanonicalForm() {
        StringBuffer stringBuffer = new StringBuffer("#{");
        stringBuffer.append(this.expression.getCanonicalForm());
        if (this.hasFormat) {
            stringBuffer.append(" ; ");
            stringBuffer.append("m");
            stringBuffer.append(this.minFracDigits);
            stringBuffer.append("M");
            stringBuffer.append(this.maxFracDigits);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public String getDescription() {
        return this.getSource();
    }

    boolean heedsOpeningWhitespace() {
        return true;
    }

    boolean heedsTrailingWhitespace() {
        return true;
    }

    private class FormatHolder {
        final NumberFormat format;
        final Locale locale;

        FormatHolder(NumberFormat numberFormat, Locale locale) {
            this.format = numberFormat;
            this.locale = locale;
        }
    }
}

