/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.BuiltIn;
import freemarker.core.Environment;
import freemarker.core.EvaluationUtil;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;

abstract class NumericalBuiltins {
    NumericalBuiltins() {
    }

    static abstract class NumberBuiltIn
    extends BuiltIn {
        NumberBuiltIn() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            TemplateModel templateModel = this.target.getAsTemplateModel(environment);
            return this.calculateResult(EvaluationUtil.getNumber(templateModel, this.target, environment), templateModel);
        }

        abstract TemplateModel calculateResult(Number var1, TemplateModel var2);
    }

    static class byteBI
    extends NumberBuiltIn {
        byteBI() {
        }

        TemplateModel calculateResult(Number number, TemplateModel templateModel) {
            if (number instanceof Byte) {
                return templateModel;
            }
            return new SimpleNumber(new Byte(number.byteValue()));
        }
    }

    static class cBI
    extends NumberBuiltIn {
        cBI() {
        }

        TemplateModel calculateResult(Number number, TemplateModel templateModel) {
            return new SimpleScalar(number.toString());
        }
    }

    static class doubleBI
    extends NumberBuiltIn {
        doubleBI() {
        }

        TemplateModel calculateResult(Number number, TemplateModel templateModel) {
            if (number instanceof Double) {
                return templateModel;
            }
            return new SimpleNumber(number.doubleValue());
        }
    }

    static class floatBI
    extends NumberBuiltIn {
        floatBI() {
        }

        TemplateModel calculateResult(Number number, TemplateModel templateModel) {
            if (number instanceof Float) {
                return templateModel;
            }
            return new SimpleNumber(number.floatValue());
        }
    }

    static class intBI
    extends NumberBuiltIn {
        intBI() {
        }

        TemplateModel calculateResult(Number number, TemplateModel templateModel) {
            if (number instanceof Integer) {
                return templateModel;
            }
            return new SimpleNumber(number.intValue());
        }
    }

    static class longBI
    extends NumberBuiltIn {
        longBI() {
        }

        TemplateModel calculateResult(Number number, TemplateModel templateModel) {
            if (number instanceof Long) {
                return templateModel;
            }
            return new SimpleNumber(number.longValue());
        }
    }

    static class shortBI
    extends NumberBuiltIn {
        shortBI() {
        }

        TemplateModel calculateResult(Number number, TemplateModel templateModel) {
            if (number instanceof Short) {
                return templateModel;
            }
            return new SimpleNumber(new Short(number.shortValue()));
        }
    }
}

