/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.BuiltIn;
import freemarker.core.Environment;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateException;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNodeModel;
import freemarker.template.utility.StringUtil;
import java.util.List;

abstract class NodeBuiltins {
    NodeBuiltins() {
    }

    static class AncestorSequence
    extends SimpleSequence
    implements TemplateMethodModel {
        private Environment env;

        AncestorSequence(Environment environment) {
            this.env = environment;
        }

        public Object exec(List list) throws TemplateModelException {
            if (list == null || list.isEmpty()) {
                return this;
            }
            AncestorSequence ancestorSequence = new AncestorSequence(this.env);
            block0: for (int i = 0; i < this.size(); ++i) {
                TemplateNodeModel templateNodeModel = (TemplateNodeModel)this.get(i);
                String string = templateNodeModel.getNodeName();
                String string2 = templateNodeModel.getNodeNamespace();
                if (string2 == null) {
                    if (!list.contains(string)) continue;
                    ancestorSequence.add(templateNodeModel);
                    continue;
                }
                for (int j = 0; j < list.size(); ++j) {
                    if (!StringUtil.matchesName((String)list.get(j), string, string2, this.env)) continue;
                    ancestorSequence.add(templateNodeModel);
                    continue block0;
                }
            }
            return ancestorSequence;
        }
    }

    static abstract class NodeBuiltIn
    extends BuiltIn {
        NodeBuiltIn() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            TemplateModel templateModel = this.target.getAsTemplateModel(environment);
            if (!(templateModel instanceof TemplateNodeModel)) {
                throw NodeBuiltIn.invalidTypeException(templateModel, this.target, environment, "node model");
            }
            return this.calculateResult((TemplateNodeModel)templateModel, environment);
        }

        abstract TemplateModel calculateResult(TemplateNodeModel var1, Environment var2) throws TemplateModelException;
    }

    static class ancestorsBI
    extends NodeBuiltIn {
        ancestorsBI() {
        }

        TemplateModel calculateResult(TemplateNodeModel templateNodeModel, Environment environment) throws TemplateModelException {
            AncestorSequence ancestorSequence = new AncestorSequence(environment);
            for (TemplateNodeModel templateNodeModel2 = templateNodeModel.getParentNode(); templateNodeModel2 != null; templateNodeModel2 = templateNodeModel2.getParentNode()) {
                ancestorSequence.add(templateNodeModel2);
            }
            return ancestorSequence;
        }
    }

    static class childrenBI
    extends NodeBuiltIn {
        childrenBI() {
        }

        TemplateModel calculateResult(TemplateNodeModel templateNodeModel, Environment environment) throws TemplateModelException {
            return templateNodeModel.getChildNodes();
        }
    }

    static class node_nameBI
    extends NodeBuiltIn {
        node_nameBI() {
        }

        TemplateModel calculateResult(TemplateNodeModel templateNodeModel, Environment environment) throws TemplateModelException {
            return new SimpleScalar(templateNodeModel.getNodeName());
        }
    }

    static class node_namespaceBI
    extends NodeBuiltIn {
        node_namespaceBI() {
        }

        TemplateModel calculateResult(TemplateNodeModel templateNodeModel, Environment environment) throws TemplateModelException {
            String string = templateNodeModel.getNodeNamespace();
            return string == null ? null : new SimpleScalar(string);
        }
    }

    static class node_typeBI
    extends NodeBuiltIn {
        node_typeBI() {
        }

        TemplateModel calculateResult(TemplateNodeModel templateNodeModel, Environment environment) throws TemplateModelException {
            return new SimpleScalar(templateNodeModel.getNodeType());
        }
    }

    static class parentBI
    extends NodeBuiltIn {
        parentBI() {
        }

        TemplateModel calculateResult(TemplateNodeModel templateNodeModel, Environment environment) throws TemplateModelException {
            return templateNodeModel.getParentNode();
        }
    }

    static class rootBI
    extends NodeBuiltIn {
        rootBI() {
        }

        TemplateModel calculateResult(TemplateNodeModel templateNodeModel, Environment environment) throws TemplateModelException {
            TemplateNodeModel templateNodeModel2 = templateNodeModel;
            TemplateNodeModel templateNodeModel3 = templateNodeModel.getParentNode();
            while (templateNodeModel3 != null) {
                templateNodeModel2 = templateNodeModel3;
                templateNodeModel3 = templateNodeModel2.getParentNode();
            }
            return templateNodeModel2;
        }
    }
}

