/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.ParseException;
import freemarker.core.TemplateElement;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.ArrayList;

final class MixedContent
extends TemplateElement {
    MixedContent() {
        this.nestedElements = new ArrayList();
    }

    void addElement(TemplateElement templateElement) {
        this.nestedElements.add(templateElement);
    }

    TemplateElement postParseCleanup(boolean bl) throws ParseException {
        super.postParseCleanup(bl);
        if (this.nestedElements.size() == 1) {
            return (TemplateElement)this.nestedElements.get(0);
        }
        return this;
    }

    void accept(Environment environment) throws TemplateException, IOException {
        for (int i = 0; i < this.nestedElements.size(); ++i) {
            TemplateElement templateElement = (TemplateElement)this.nestedElements.get(i);
            environment.visit(templateElement);
        }
    }

    public String getCanonicalForm() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.nestedElements.size(); ++i) {
            TemplateElement templateElement = (TemplateElement)this.nestedElements.get(i);
            stringBuffer.append(templateElement.getCanonicalForm());
        }
        return stringBuffer.toString();
    }

    public String getDescription() {
        if (this.parent == null) {
            return "root element";
        }
        return "content";
    }

    boolean isIgnorable() {
        return this.nestedElements == null || this.nestedElements.size() == 0;
    }
}

