/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.ListLiteral;
import freemarker.core.Macro;
import freemarker.template.TemplateException;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

final class MethodCall
extends Expression {
    private final Expression target;
    private final ListLiteral arguments;

    MethodCall(Expression expression, ArrayList arrayList) {
        this(expression, new ListLiteral(arrayList));
    }

    private MethodCall(Expression expression, ListLiteral listLiteral) {
        this.target = expression;
        this.arguments = listLiteral;
    }

    TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
        TemplateModel templateModel = this.target.getAsTemplateModel(environment);
        if (templateModel instanceof TemplateMethodModel) {
            TemplateMethodModel templateMethodModel = (TemplateMethodModel)templateModel;
            List list = templateMethodModel instanceof TemplateMethodModelEx ? this.arguments.getModelList(environment) : this.arguments.getValueList(environment);
            Object object = templateMethodModel.exec(list);
            return environment.getObjectWrapper().wrap(object);
        }
        if (templateModel instanceof Macro) {
            Macro macro = (Macro)templateModel;
            environment.setLastReturnValue(null);
            if (!macro.isFunction) {
                throw new TemplateException("A macro cannot be called in an expression.", environment);
            }
            Writer writer = environment.getOut();
            try {
                environment.setOut(Environment.NULL_WRITER);
                environment.visit(macro, null, this.arguments.values, null, null);
            }
            catch (IOException iOException) {
                throw new InternalError("This should be impossible.");
            }
            finally {
                environment.setOut(writer);
            }
            return environment.getLastReturnValue();
        }
        throw MethodCall.invalidTypeException(templateModel, this.target, environment, "method");
    }

    public String getCanonicalForm() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.target.getCanonicalForm());
        stringBuffer.append("(");
        String string = this.arguments.getCanonicalForm();
        stringBuffer.append(string.substring(1, string.length() - 1));
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    TemplateModel getConstantValue() {
        return null;
    }

    boolean isLiteral() {
        return false;
    }

    Expression _deepClone(String string, Expression expression) {
        return new MethodCall(this.target.deepClone(string, expression), (ListLiteral)this.arguments.deepClone(string, expression));
    }
}

