/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.LocalContext;
import freemarker.core.TemplateElement;
import freemarker.core.TemplateObject;
import freemarker.core.TextBlock;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.utility.Collections12;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Macro
extends TemplateElement
implements TemplateModel {
    private final String name;
    private final String[] argumentNames;
    private Map args;
    private String catchAll;
    boolean isFunction;
    static final Macro DO_NOTHING_MACRO = new Macro(".pass", Collections.EMPTY_LIST, Collections12.EMPTY_MAP, TextBlock.EMPTY_BLOCK);

    Macro(String string, List list, Map map, TemplateElement templateElement) {
        this.name = string;
        this.argumentNames = list.toArray(new String[list.size()]);
        this.args = map;
        this.nestedBlock = templateElement;
    }

    public String getCatchAll() {
        return this.catchAll;
    }

    public void setCatchAll(String string) {
        this.catchAll = string;
    }

    public String[] getArgumentNames() {
        return this.argumentNames;
    }

    boolean hasArgNamed(String string) {
        return this.args.containsKey(string);
    }

    public String getName() {
        return this.name;
    }

    void accept(Environment environment) {
        environment.visitMacroDef(this);
    }

    public String getCanonicalForm() {
        StringBuffer stringBuffer = new StringBuffer("<#macro ");
        stringBuffer.append(this.name);
        stringBuffer.append("(");
        int n = this.argumentNames.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.argumentNames[i]);
            if (i == n - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(")>");
        if (this.nestedBlock != null) {
            stringBuffer.append(this.nestedBlock.getCanonicalForm());
        }
        stringBuffer.append("</#macro>");
        return stringBuffer.toString();
    }

    public String getDescription() {
        return "macro " + this.name;
    }

    public boolean isFunction() {
        return this.isFunction;
    }

    class Context
    implements LocalContext {
        Environment.Namespace localVars;
        TemplateElement body;
        Environment.Namespace bodyNamespace;
        List bodyParameterNames;
        Context prevMacroContext;
        ArrayList prevLocalContextStack;

        Context(Environment environment, TemplateElement templateElement, List list) {
            this.localVars = environment.new Environment.Namespace();
            this.prevMacroContext = environment.getCurrentMacroContext();
            this.bodyNamespace = environment.getCurrentNamespace();
            this.prevLocalContextStack = environment.getLocalContextStack();
            this.body = templateElement;
            this.bodyParameterNames = list;
        }

        Macro getMacro() {
            return Macro.this;
        }

        void runMacro(Environment environment) throws TemplateException, IOException {
            this.sanityCheck(environment);
            if (Macro.this.nestedBlock != null) {
                environment.visit(Macro.this.nestedBlock);
            }
        }

        void sanityCheck(Environment environment) throws TemplateException {
            Iterator iterator = Macro.this.args.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                if (this.localVars.get(string) != null) continue;
                Expression expression = (Expression)entry.getValue();
                if (expression != null) {
                    TemplateModel templateModel = expression.getAsTemplateModel(environment);
                    TemplateObject.assertNonNull(templateModel, expression, environment);
                    this.localVars.put(string, templateModel);
                    continue;
                }
                throw new TemplateException("Error executing macro: " + Macro.this.name + "\nrequired parameter: " + string + " is not specified.", environment);
            }
        }

        public TemplateModel getLocalVariable(String string) throws TemplateModelException {
            return this.localVars.get(string);
        }

        Environment.Namespace getLocals() {
            return this.localVars;
        }

        void setLocalVar(String string, TemplateModel templateModel) {
            this.localVars.put(string, templateModel);
        }

        public Set getLocalVariableNames() throws TemplateModelException {
            HashSet<String> hashSet = new HashSet<String>();
            TemplateModelIterator templateModelIterator = this.localVars.keys().iterator();
            while (templateModelIterator.hasNext()) {
                hashSet.add(templateModelIterator.next().toString());
            }
            return hashSet;
        }
    }
}

