/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.StringLiteral;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.utility.Collections12;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

final class ListLiteral
extends Expression {
    final ArrayList values;

    ListLiteral(ArrayList arrayList) {
        this.values = arrayList;
        arrayList.trimToSize();
    }

    TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
        SimpleSequence simpleSequence = new SimpleSequence(this.values.size());
        Iterator iterator = this.values.iterator();
        while (iterator.hasNext()) {
            Expression expression = (Expression)iterator.next();
            TemplateModel templateModel = expression.getAsTemplateModel(environment);
            ListLiteral.assertNonNull(templateModel, expression, environment);
            simpleSequence.add(templateModel);
        }
        return simpleSequence;
    }

    List getValueList(Environment environment) throws TemplateException {
        int n = this.values.size();
        switch (n) {
            case 0: {
                return Collections.EMPTY_LIST;
            }
            case 1: {
                return Collections12.singletonList(((Expression)this.values.get(0)).getStringValue(environment));
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>(this.values.size());
        ListIterator listIterator = this.values.listIterator();
        while (listIterator.hasNext()) {
            Expression expression = (Expression)listIterator.next();
            arrayList.add(expression.getStringValue(environment));
        }
        return arrayList;
    }

    List getModelList(Environment environment) throws TemplateException {
        int n = this.values.size();
        switch (n) {
            case 0: {
                return Collections.EMPTY_LIST;
            }
            case 1: {
                return Collections12.singletonList(((Expression)this.values.get(0)).getAsTemplateModel(environment));
            }
        }
        ArrayList<TemplateModel> arrayList = new ArrayList<TemplateModel>(this.values.size());
        ListIterator listIterator = this.values.listIterator();
        while (listIterator.hasNext()) {
            Expression expression = (Expression)listIterator.next();
            arrayList.add(expression.getAsTemplateModel(environment));
        }
        return arrayList;
    }

    public String getCanonicalForm() {
        StringBuffer stringBuffer = new StringBuffer("[");
        int n = this.values.size();
        for (int i = 0; i < n; ++i) {
            Expression expression = (Expression)this.values.get(i);
            stringBuffer.append(expression.getCanonicalForm());
            if (i == n - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    boolean isLiteral() {
        if (this.constantValue != null) {
            return true;
        }
        for (int i = 0; i < this.values.size(); ++i) {
            Expression expression = (Expression)this.values.get(i);
            if (expression.isLiteral()) continue;
            return false;
        }
        return true;
    }

    TemplateSequenceModel evaluateStringsToNamespaces(Environment environment) throws TemplateException {
        TemplateSequenceModel templateSequenceModel = (TemplateSequenceModel)this.getAsTemplateModel(environment);
        SimpleSequence simpleSequence = new SimpleSequence(templateSequenceModel.size());
        for (int i = 0; i < this.values.size(); ++i) {
            if (this.values.get(i) instanceof StringLiteral) {
                String string = ((StringLiteral)this.values.get(i)).getAsString();
                try {
                    Environment.Namespace namespace = environment.importLib(string, null);
                    simpleSequence.add(namespace);
                    continue;
                }
                catch (IOException iOException) {
                    throw new TemplateException("Could not import library '" + string + "', " + iOException.getMessage(), environment);
                }
            }
            simpleSequence.add(templateSequenceModel.get(i));
        }
        return simpleSequence;
    }

    Expression _deepClone(String string, Expression expression) {
        ArrayList arrayList = (ArrayList)this.values.clone();
        ListIterator<Expression> listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            listIterator.set(((Expression)listIterator.next()).deepClone(string, expression));
        }
        return new ListLiteral(arrayList);
    }
}

