/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.InvalidReferenceException;
import freemarker.core.ParseException;
import freemarker.core.TemplateElement;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;

public final class LibraryLoad
extends TemplateElement {
    private Expression templateName;
    private String namespace;
    private final String templatePath;

    LibraryLoad(Template template, Expression expression, String string) {
        this.namespace = string;
        String string2 = template.getName();
        int n = string2.lastIndexOf(47);
        this.templatePath = n == -1 ? "" : string2.substring(0, n + 1);
        this.templateName = expression;
    }

    void accept(Environment environment) throws TemplateException, IOException {
        Template template;
        String string = this.templateName.getStringValue(environment);
        if (string == null) {
            String string2 = "Error " + this.getStartLocation() + "The expression " + this.templateName + " is undefined.";
            throw new InvalidReferenceException(string2, environment);
        }
        try {
            if (!environment.isClassicCompatible() && string.indexOf("://") <= 0) {
                int n;
                string = string.length() > 0 && string.charAt(0) == '/' ? ((n = this.templatePath.indexOf("://")) > 0 ? this.templatePath.substring(0, n + 2) + string : string.substring(1)) : this.templatePath + string;
            }
            template = environment.getTemplateForImporting(string);
        }
        catch (ParseException parseException) {
            String string3 = "Error parsing imported template " + string;
            throw new TemplateException(string3, parseException, environment);
        }
        catch (IOException iOException) {
            String string4 = "Error reading imported file " + string;
            throw new TemplateException(string4, iOException, environment);
        }
        environment.importLib(template, this.namespace);
    }

    public String getCanonicalForm() {
        StringBuffer stringBuffer = new StringBuffer("<#import ");
        stringBuffer.append(this.templateName);
        stringBuffer.append(" as ");
        stringBuffer.append(this.namespace);
        stringBuffer.append("/>");
        return stringBuffer.toString();
    }

    public String getDescription() {
        return "import " + this.templateName + " as " + this.namespace;
    }

    public String getTemplateName() {
        return this.templateName.toString();
    }
}

