/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.LocalContext;
import freemarker.core.TemplateElement;
import freemarker.core.TemplateObject;
import freemarker.template.SimpleNumber;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateSequenceModel;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

final class IteratorBlock
extends TemplateElement {
    private Expression listExpression;
    private String indexName;
    private boolean isForEach;

    IteratorBlock(Expression expression, String string, TemplateElement templateElement, boolean bl) {
        this.listExpression = expression;
        this.indexName = string;
        this.isForEach = bl;
        this.nestedBlock = templateElement;
    }

    void accept(Environment environment) throws TemplateException, IOException {
        TemplateModel templateModel = this.listExpression.getAsTemplateModel(environment);
        if (templateModel == null) {
            if (environment.isClassicCompatible()) {
                return;
            }
            IteratorBlock.assertNonNull(templateModel, this.listExpression, environment);
        }
        environment.visit(new Context(templateModel));
    }

    public String getCanonicalForm() {
        if (this.isForEach) {
            StringBuffer stringBuffer = new StringBuffer("<#foreach ");
            stringBuffer.append(this.indexName);
            stringBuffer.append(" in ");
            stringBuffer.append(this.listExpression.getCanonicalForm());
            stringBuffer.append(">");
            if (this.nestedBlock != null) {
                stringBuffer.append(this.nestedBlock.getCanonicalForm());
            }
            stringBuffer.append("</#foreach>");
            return stringBuffer.toString();
        }
        StringBuffer stringBuffer = new StringBuffer("<#list ");
        stringBuffer.append(this.listExpression.getCanonicalForm());
        stringBuffer.append(" as ");
        stringBuffer.append(this.indexName);
        stringBuffer.append(">");
        if (this.nestedBlock != null) {
            stringBuffer.append(this.nestedBlock.getCanonicalForm());
        }
        stringBuffer.append("</#list>");
        return stringBuffer.toString();
    }

    public String getDescription() {
        if (this.isForEach) {
            return "foreach " + this.indexName + " in " + this.listExpression;
        }
        return "list " + this.listExpression + " as " + this.indexName;
    }

    class Context
    implements LocalContext {
        private boolean hasNext;
        private TemplateModel loopVar;
        private int index;
        private Set variableNames = null;
        private TemplateModel list;

        Context(TemplateModel templateModel) {
            this.list = templateModel;
        }

        void runLoop(Environment environment) throws TemplateException, IOException {
            if (this.list instanceof TemplateCollectionModel) {
                TemplateCollectionModel templateCollectionModel = (TemplateCollectionModel)this.list;
                TemplateModelIterator templateModelIterator = templateCollectionModel.iterator();
                this.hasNext = templateModelIterator.hasNext();
                while (this.hasNext) {
                    this.loopVar = templateModelIterator.next();
                    this.hasNext = templateModelIterator.hasNext();
                    if (IteratorBlock.this.nestedBlock != null) {
                        environment.visit(IteratorBlock.this.nestedBlock);
                    }
                    ++this.index;
                }
            } else if (this.list instanceof TemplateSequenceModel) {
                TemplateSequenceModel templateSequenceModel = (TemplateSequenceModel)this.list;
                int n = templateSequenceModel.size();
                this.index = 0;
                while (this.index < n) {
                    this.loopVar = templateSequenceModel.get(this.index);
                    boolean bl = this.hasNext = n > this.index + 1;
                    if (IteratorBlock.this.nestedBlock != null) {
                        environment.visit(IteratorBlock.this.nestedBlock);
                    }
                    ++this.index;
                }
            } else if (environment.isClassicCompatible()) {
                this.loopVar = this.list;
                if (IteratorBlock.this.nestedBlock != null) {
                    environment.visit(IteratorBlock.this.nestedBlock);
                }
            } else {
                throw TemplateObject.invalidTypeException(this.list, IteratorBlock.this.listExpression, environment, "collection or sequence");
            }
        }

        public TemplateModel getLocalVariable(String string) {
            if (string.startsWith(IteratorBlock.this.indexName)) {
                switch (string.length() - IteratorBlock.this.indexName.length()) {
                    case 0: {
                        return this.loopVar;
                    }
                    case 6: {
                        if (!string.endsWith("_index")) break;
                        return new SimpleNumber(this.index);
                    }
                    case 9: {
                        if (!string.endsWith("_has_next")) break;
                        return this.hasNext ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
                    }
                }
            }
            return null;
        }

        public Set getLocalVariableNames() {
            if (this.variableNames == null) {
                this.variableNames = new HashSet();
                this.variableNames.add(IteratorBlock.this.indexName);
                this.variableNames.add(IteratorBlock.this.indexName + "_index");
                this.variableNames.add(IteratorBlock.this.indexName + "_has_next");
            }
            return this.variableNames;
        }
    }
}

