/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.cache.TemplateCache;
import freemarker.core.Environment;
import freemarker.core.EvaluationUtil;
import freemarker.core.Expression;
import freemarker.core.InvalidReferenceException;
import freemarker.core.ParseException;
import freemarker.core.StringLiteral;
import freemarker.core.TemplateElement;
import freemarker.template.Template;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.utility.StringUtil;
import java.io.IOException;

final class Include
extends TemplateElement {
    private Expression includedTemplateName;
    private Expression encodingExp;
    private Expression parseExp;
    private String encoding;
    private boolean parse;
    private final String templatePath;

    Include(Template template, Expression expression, Expression expression2, Expression expression3) {
        String string = template.getName();
        int n = string.lastIndexOf(47);
        this.templatePath = n == -1 ? "" : string.substring(0, n + 1);
        this.includedTemplateName = expression;
        if (expression2 instanceof StringLiteral) {
            this.encoding = expression2.toString();
            this.encoding = this.encoding.substring(1, this.encoding.length() - 1);
        } else {
            this.encodingExp = expression2;
        }
        if (expression3 == null || expression3 == TemplateBooleanModel.TRUE) {
            this.parse = true;
        } else if (expression3 == TemplateBooleanModel.FALSE) {
            this.parse = false;
        } else if (expression3 instanceof StringLiteral) {
            this.parse = StringUtil.getYesNo(expression3.toString());
        } else {
            this.parseExp = expression3;
        }
    }

    void accept(Environment environment) throws TemplateException, IOException {
        Object object;
        String string = this.includedTemplateName.getStringValue(environment);
        if (string == null) {
            String string2 = "Error " + this.getStartLocation() + "The expression " + this.includedTemplateName + " is undefined.";
            throw new InvalidReferenceException(string2, environment);
        }
        String string3 = this.encoding;
        if (this.encoding == null && this.encodingExp != null) {
            string3 = this.encodingExp.getStringValue(environment);
        }
        boolean bl = this.parse;
        if (this.parseExp != null) {
            object = this.parseExp.getAsTemplateModel(environment);
            if (object == null) {
                if (environment.isClassicCompatible()) {
                    bl = false;
                } else {
                    Include.assertNonNull((TemplateModel)object, this.parseExp, environment);
                }
            }
            bl = object instanceof TemplateScalarModel ? this.getYesNo(EvaluationUtil.getString((TemplateScalarModel)object, this.parseExp, environment)) : this.parseExp.isTrue(environment);
        }
        try {
            string = TemplateCache.getFullTemplatePath(environment, this.templatePath, string);
            object = environment.getTemplateForInclusion(string, string3, bl);
        }
        catch (ParseException parseException) {
            String string4 = "Error parsing included template " + string + "\n" + parseException.getMessage();
            throw new TemplateException(string4, parseException, environment);
        }
        catch (IOException iOException) {
            String string5 = "Error reading included file " + string;
            throw new TemplateException(string5, iOException, environment);
        }
        environment.include((Template)object);
    }

    public String getCanonicalForm() {
        StringBuffer stringBuffer = new StringBuffer("<#include ");
        stringBuffer.append(this.includedTemplateName);
        if (this.encoding != null) {
            stringBuffer.append(" encoding=\"");
            stringBuffer.append(this.encodingExp.getCanonicalForm());
            stringBuffer.append("\"");
        }
        if (!this.parse) {
            stringBuffer.append(" parse=false");
        }
        stringBuffer.append("/>");
        return stringBuffer.toString();
    }

    public String getDescription() {
        return "include " + this.includedTemplateName;
    }

    private boolean getYesNo(String string) throws ParseException {
        try {
            return StringUtil.getYesNo(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException("Error " + this.getStartLocation() + "\nValue of include parse parameter " + "must be boolean or one of these strings: " + "\"n\", \"no\", \"f\", \"false\", \"y\", \"yes\", \"t\", \"true\"" + "\nFound: " + this.parseExp, this.parseExp);
        }
    }
}

