/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.ConditionalBlock;
import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.ParseException;
import freemarker.core.TemplateElement;
import freemarker.core.TemplateObject;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.ArrayList;

final class IfBlock
extends TemplateElement {
    IfBlock(ConditionalBlock conditionalBlock) {
        this.nestedElements = new ArrayList();
        this.addBlock(conditionalBlock);
    }

    void addBlock(ConditionalBlock conditionalBlock) {
        this.nestedElements.add(conditionalBlock);
    }

    void accept(Environment environment) throws TemplateException, IOException {
        for (int i = 0; i < this.nestedElements.size(); ++i) {
            ConditionalBlock conditionalBlock = (ConditionalBlock)this.nestedElements.get(i);
            Expression expression = conditionalBlock.condition;
            if (expression != null && !expression.isTrue(environment)) continue;
            if (conditionalBlock.nestedBlock != null) {
                environment.visit(conditionalBlock.nestedBlock);
            }
            return;
        }
    }

    public String getCanonicalForm() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.nestedElements.size(); ++i) {
            ConditionalBlock conditionalBlock = (ConditionalBlock)this.nestedElements.get(i);
            stringBuffer.append(conditionalBlock.getCanonicalForm());
        }
        stringBuffer.append("</#if>");
        return stringBuffer.toString();
    }

    TemplateElement postParseCleanup(boolean bl) throws ParseException {
        if (this.nestedElements.size() == 1) {
            ConditionalBlock conditionalBlock = (ConditionalBlock)this.nestedElements.get(0);
            conditionalBlock.isSimple = true;
            conditionalBlock.setLocation(this.getTemplate(), (TemplateObject)conditionalBlock, (TemplateObject)this);
            return conditionalBlock.postParseCleanup(bl);
        }
        return super.postParseCleanup(bl);
    }

    public String getDescription() {
        return "if-else ";
    }
}

