/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.CollectionAndSequence;
import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.TemplateObject;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;

final class HashLiteral
extends Expression {
    private final ArrayList keys;
    private final ArrayList values;
    private final int size;

    HashLiteral(ArrayList arrayList, ArrayList arrayList2) {
        this.keys = arrayList;
        this.values = arrayList2;
        this.size = arrayList.size();
        arrayList.trimToSize();
        arrayList2.trimToSize();
    }

    TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
        return new SequenceHash(environment);
    }

    public String getCanonicalForm() {
        StringBuffer stringBuffer = new StringBuffer("{");
        for (int i = 0; i < this.size; ++i) {
            Expression expression = (Expression)this.keys.get(i);
            Expression expression2 = (Expression)this.values.get(i);
            stringBuffer.append(expression.getCanonicalForm());
            stringBuffer.append(" : ");
            stringBuffer.append(expression2.getCanonicalForm());
            if (i == this.size - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    boolean isLiteral() {
        if (this.constantValue != null) {
            return true;
        }
        for (int i = 0; i < this.size; ++i) {
            Expression expression = (Expression)this.keys.get(i);
            Expression expression2 = (Expression)this.values.get(i);
            if (expression.isLiteral() && expression2.isLiteral()) continue;
            return false;
        }
        return true;
    }

    Expression _deepClone(String string, Expression expression) {
        ArrayList arrayList = (ArrayList)this.keys.clone();
        Object object = arrayList.listIterator();
        while (object.hasNext()) {
            object.set(((Expression)object.next()).deepClone(string, expression));
        }
        object = (ArrayList)this.values.clone();
        ListIterator<Expression> listIterator = ((ArrayList)object).listIterator();
        while (listIterator.hasNext()) {
            listIterator.set(((Expression)listIterator.next()).deepClone(string, expression));
        }
        return new HashLiteral(arrayList, (ArrayList)object);
    }

    private class SequenceHash
    implements TemplateHashModelEx {
        private HashMap keyMap = new HashMap();
        private TemplateCollectionModel keyCollection;
        private TemplateCollectionModel valueCollection;

        SequenceHash(Environment environment) throws TemplateException {
            ArrayList<String> arrayList = new ArrayList<String>(HashLiteral.this.size);
            ArrayList<TemplateModel> arrayList2 = new ArrayList<TemplateModel>(HashLiteral.this.size);
            for (int i = 0; i < HashLiteral.this.size; ++i) {
                Expression expression = (Expression)HashLiteral.this.keys.get(i);
                Expression expression2 = (Expression)HashLiteral.this.values.get(i);
                String string = expression.getStringValue(environment);
                TemplateModel templateModel = expression2.getAsTemplateModel(environment);
                TemplateObject.assertNonNull(templateModel, expression2, environment);
                this.keyMap.put(string, templateModel);
                arrayList.add(string);
                arrayList2.add(templateModel);
            }
            this.keyCollection = new CollectionAndSequence(new SimpleSequence(arrayList));
            this.valueCollection = new CollectionAndSequence(new SimpleSequence(arrayList2));
        }

        public int size() {
            return HashLiteral.this.size;
        }

        public TemplateCollectionModel keys() {
            return this.keyCollection;
        }

        public TemplateCollectionModel values() {
            return this.valueCollection;
        }

        public TemplateModel get(String string) {
            return (TemplateModel)this.keyMap.get(string);
        }

        public boolean isEmpty() {
            return HashLiteral.this.size == 0;
        }
    }
}

