/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.EvaluationUtil;
import freemarker.core.NonBooleanException;
import freemarker.core.NonStringException;
import freemarker.core.ParseException;
import freemarker.core.TemplateObject;
import freemarker.ext.beans.BeanModel;
import freemarker.template.Template;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;

public abstract class Expression
extends TemplateObject {
    TemplateModel constantValue;

    abstract TemplateModel _getAsTemplateModel(Environment var1) throws TemplateException;

    abstract boolean isLiteral();

    void setLocation(Template template, int n, int n2, int n3, int n4) throws ParseException {
        super.setLocation(template, n, n2, n3, n4);
        if (this.isLiteral()) {
            try {
                this.constantValue = this._getAsTemplateModel(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final TemplateModel getAsTemplateModel(Environment environment) throws TemplateException {
        return this.constantValue != null ? this.constantValue : this._getAsTemplateModel(environment);
    }

    String getStringValue(Environment environment) throws TemplateException {
        return Expression.getStringValue(this.getAsTemplateModel(environment), this, environment);
    }

    static String getStringValue(TemplateModel templateModel, Expression expression, Environment environment) throws TemplateException {
        if (templateModel instanceof TemplateNumberModel) {
            return environment.formatNumber(EvaluationUtil.getNumber((TemplateNumberModel)templateModel, expression, environment));
        }
        if (templateModel instanceof TemplateDateModel) {
            TemplateDateModel templateDateModel = (TemplateDateModel)templateModel;
            return environment.formatDate(EvaluationUtil.getDate(templateDateModel, expression, environment), templateDateModel.getDateType());
        }
        if (templateModel instanceof TemplateScalarModel) {
            return EvaluationUtil.getString((TemplateScalarModel)templateModel, expression, environment);
        }
        if (environment.isClassicCompatible()) {
            if (templateModel instanceof TemplateBooleanModel) {
                return ((TemplateBooleanModel)templateModel).getAsBoolean() ? "true" : "";
            }
            if (templateModel == null) {
                return "";
            }
        }
        Expression.assertNonNull(templateModel, expression, environment);
        String string = "Error " + expression.getStartLocation() + "\nExpecting a string, " + (environment.isClassicCompatible() ? "boolean, " : "") + "date or number here, Expression " + expression + " is instead a " + templateModel.getClass().getName();
        throw new NonStringException(string, environment);
    }

    Expression deepClone(String string, Expression expression) {
        Expression expression2 = this._deepClone(string, expression);
        expression2.copyLocationFrom(this);
        return expression2;
    }

    abstract Expression _deepClone(String var1, Expression var2);

    boolean isTrue(Environment environment) throws TemplateException {
        TemplateModel templateModel = this.getAsTemplateModel(environment);
        if (templateModel instanceof TemplateBooleanModel) {
            return ((TemplateBooleanModel)templateModel).getAsBoolean();
        }
        if (environment.isClassicCompatible()) {
            return templateModel != null && !Expression.isEmpty(templateModel);
        }
        Expression.assertNonNull(templateModel, this, environment);
        String string = "Error " + this.getStartLocation() + "\nExpecting a boolean (true/false) expression here" + "\nExpression " + this + " does not evaluate to true/false " + "\nit is an instance of " + templateModel.getClass().getName();
        throw new NonBooleanException(string, environment);
    }

    static boolean isEmpty(TemplateModel templateModel) throws TemplateModelException {
        if (templateModel instanceof BeanModel) {
            return ((BeanModel)templateModel).isEmpty();
        }
        if (templateModel instanceof TemplateSequenceModel) {
            return ((TemplateSequenceModel)templateModel).size() == 0;
        }
        if (templateModel instanceof TemplateScalarModel) {
            String string = ((TemplateScalarModel)templateModel).getAsString();
            return string == null || string.length() == 0;
        }
        if (templateModel instanceof TemplateCollectionModel) {
            return !((TemplateCollectionModel)templateModel).iterator().hasNext();
        }
        if (templateModel instanceof TemplateHashModel) {
            return ((TemplateHashModel)templateModel).isEmpty();
        }
        return !(templateModel instanceof TemplateNumberModel) && !(templateModel instanceof TemplateDateModel) && !(templateModel instanceof TemplateBooleanModel);
    }
}

