/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.InvalidReferenceException;
import freemarker.core.NonNumericalException;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import java.util.Date;

class EvaluationUtil {
    private EvaluationUtil() {
    }

    static String getString(TemplateScalarModel templateScalarModel, Expression expression, Environment environment) throws TemplateException {
        String string = templateScalarModel.getAsString();
        if (string == null) {
            if (environment.isClassicCompatible()) {
                return "";
            }
            throw new TemplateException(expression + " evaluated to null string.", environment);
        }
        return string;
    }

    static Number getNumber(Expression expression, Environment environment) throws TemplateException {
        TemplateModel templateModel = expression.getAsTemplateModel(environment);
        return EvaluationUtil.getNumber(templateModel, expression, environment);
    }

    static Number getNumber(TemplateModel templateModel, Expression expression, Environment environment) throws TemplateException {
        if (templateModel instanceof TemplateNumberModel) {
            return EvaluationUtil.getNumber((TemplateNumberModel)templateModel, expression, environment);
        }
        if (templateModel == null) {
            throw new InvalidReferenceException(expression + " is undefined.", environment);
        }
        throw new NonNumericalException(expression + " is not a number, it is " + templateModel.getClass().getName(), environment);
    }

    static Number getNumber(TemplateNumberModel templateNumberModel, Expression expression, Environment environment) throws TemplateModelException, TemplateException {
        Number number = templateNumberModel.getAsNumber();
        if (number == null) {
            throw new TemplateException(expression + " evaluated to null number.", environment);
        }
        return number;
    }

    static Date getDate(TemplateDateModel templateDateModel, Expression expression, Environment environment) throws TemplateModelException, TemplateException {
        Date date = templateDateModel.getAsDate();
        if (date == null) {
            throw new TemplateException(expression + " evaluated to null date.", environment);
        }
        return date;
    }
}

