/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.TemplateElement;
import freemarker.template.TemplateException;
import java.io.IOException;

class EscapeBlock
extends TemplateElement {
    private final String variable;
    private final Expression expr;
    private Expression escapedExpr;

    EscapeBlock(String string, Expression expression, Expression expression2) {
        this.variable = string;
        this.expr = expression;
        this.escapedExpr = expression2;
    }

    void setContent(TemplateElement templateElement) {
        this.nestedBlock = templateElement;
        this.escapedExpr = null;
    }

    void accept(Environment environment) throws TemplateException, IOException {
        if (this.nestedBlock != null) {
            environment.visit(this.nestedBlock);
        }
    }

    Expression doEscape(Expression expression) {
        return this.escapedExpr.deepClone(this.variable, expression);
    }

    public String getDescription() {
        return "escape " + this.variable + " as " + this.expr.toString();
    }

    public String getCanonicalForm() {
        return "<#escape " + this.variable + " as " + this.expr.getCanonicalForm() + ">" + this.nestedBlock.getCanonicalForm() + "</#escape>";
    }
}

