/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.BodyInstruction;
import freemarker.core.BreakInstruction;
import freemarker.core.Configurable;
import freemarker.core.Expression;
import freemarker.core.Identifier;
import freemarker.core.Include;
import freemarker.core.InvalidReferenceException;
import freemarker.core.IteratorBlock;
import freemarker.core.LocalContext;
import freemarker.core.Macro;
import freemarker.core.ReturnInstruction;
import freemarker.core.StopException;
import freemarker.core.TemplateElement;
import freemarker.core.UnifiedCall;
import freemarker.ext.beans.BeansWrapper;
import freemarker.log.Logger;
import freemarker.template.Configuration;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleSequence;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateNodeModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.TemplateTransformModel;
import freemarker.template.TransformControl;
import freemarker.template.WrappingTemplateModel;
import freemarker.template.utility.UndeclaredThrowableException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.Collator;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;

public final class Environment
extends Configurable {
    private static final ThreadLocal threadEnv = new ThreadLocal();
    private static final Logger logger = Logger.getLogger("freemarker.runtime");
    private static final Map localizedNumberFormats = new HashMap();
    private static final Map localizedDateFormats = new HashMap();
    private final TemplateHashModel rootDataModel;
    private final ArrayList elementStack = new ArrayList();
    private final ArrayList recoveredErrorStack = new ArrayList();
    private NumberFormat numberFormat;
    private Map numberFormats;
    private DateFormat timeFormat;
    private DateFormat dateFormat;
    private DateFormat dateTimeFormat;
    private Map[] dateFormats;
    private Collator collator;
    private Writer out;
    private Macro.Context currentMacroContext;
    private ArrayList localContextStack;
    private Namespace mainNamespace;
    private Namespace currentNamespace;
    private Namespace globalNamespace;
    private HashMap loadedLibs;
    private Throwable lastThrowable;
    private TemplateModel lastReturnValue;
    private HashMap macroToNamespaceLookup = new HashMap();
    private TemplateNodeModel currentVisitorNode;
    private TemplateSequenceModel nodeNamespaces;
    private int nodeNamespaceIndex;
    private String currentNodeName;
    private String currentNodeNS;
    private String cachedURLEscapingCharset;
    private boolean urlEscapingCharsetCached;
    static final Writer NULL_WRITER = new Writer(){

        public void write(char[] cArray, int n, int n2) {
        }

        public void flush() {
        }

        public void close() {
        }
    };
    private static final Writer EMPTY_BODY_WRITER = new Writer(){

        public void write(char[] cArray, int n, int n2) throws IOException {
            if (n2 > 0) {
                throw new IOException("This transform does not allow nested content.");
            }
        }

        public void flush() {
        }

        public void close() {
        }
    };

    public static Environment getCurrentEnvironment() {
        return (Environment)threadEnv.get();
    }

    public Environment(Template template, TemplateHashModel templateHashModel, Writer writer) {
        super(template);
        this.globalNamespace = new Namespace(null);
        this.currentNamespace = this.mainNamespace = new Namespace(template);
        this.out = writer;
        this.rootDataModel = templateHashModel;
        this.importMacros(template);
    }

    public Template getTemplate() {
        return (Template)this.getParent();
    }

    private void clearCachedValues() {
        this.numberFormats = null;
        this.numberFormat = null;
        this.dateFormats = null;
        this.collator = null;
        this.cachedURLEscapingCharset = null;
        this.urlEscapingCharsetCached = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() throws TemplateException, IOException {
        Object t = threadEnv.get();
        threadEnv.set(this);
        try {
            this.clearCachedValues();
            try {
                this.visit(this.getTemplate().getRootTreeNode());
                this.out.flush();
            }
            finally {
                this.clearCachedValues();
            }
        }
        finally {
            threadEnv.set(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void visit(TemplateElement templateElement) throws TemplateException, IOException {
        this.pushElement(templateElement);
        try {
            templateElement.accept(this);
        }
        catch (TemplateException templateException) {
            this.handleTemplateException(templateException);
        }
        finally {
            this.popElement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void visit(TemplateElement templateElement, TemplateTransformModel templateTransformModel, Map map) throws TemplateException, IOException {
        block17: {
            try {
                Writer writer = templateTransformModel.getWriter(this.out, map);
                if (writer == null) {
                    writer = EMPTY_BODY_WRITER;
                }
                TransformControl transformControl = writer instanceof TransformControl ? (TransformControl)((Object)writer) : null;
                Writer writer2 = this.out;
                this.out = writer;
                try {
                    if (transformControl == null || transformControl.onStart() != 0) {
                        do {
                            if (templateElement == null) continue;
                            this.visit(templateElement);
                        } while (transformControl != null && transformControl.afterBody() == 0);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (transformControl != null) {
                            transformControl.onError(throwable);
                            break block17;
                        }
                        throw throwable;
                    }
                    catch (TemplateException templateException) {
                        throw templateException;
                    }
                    catch (IOException iOException) {
                        throw iOException;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Error error) {
                        throw error;
                    }
                    catch (Throwable throwable2) {
                        throw new UndeclaredThrowableException(throwable2);
                    }
                }
                finally {
                    this.out = writer2;
                    writer.close();
                }
            }
            catch (TemplateException templateException) {
                this.handleTemplateException(templateException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void visit(TemplateElement templateElement, TemplateElement templateElement2) throws TemplateException, IOException {
        Writer writer = this.out;
        StringWriter stringWriter = new StringWriter();
        this.out = stringWriter;
        TemplateException templateException = null;
        try {
            this.visit(templateElement);
        }
        catch (TemplateException templateException2) {
            templateException = templateException2;
        }
        finally {
            this.out = writer;
        }
        if (templateException != null) {
            if (logger.isErrorEnabled()) {
                String string = "Error in attempt block " + templateElement.getStartLocation();
                logger.error(string, templateException);
            }
            try {
                this.recoveredErrorStack.add(templateException.getMessage());
                this.visit(templateElement2);
            }
            finally {
                this.recoveredErrorStack.remove(this.recoveredErrorStack.size() - 1);
            }
        } else {
            this.out.write(stringWriter.toString());
        }
    }

    String getCurrentRecoveredErrorMesssage() throws TemplateException {
        if (this.recoveredErrorStack.isEmpty()) {
            throw new TemplateException(".error is not available outside of a <#recover> block", this);
        }
        return (String)this.recoveredErrorStack.get(this.recoveredErrorStack.size() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void visit(BodyInstruction.Context context) throws TemplateException, IOException {
        Macro.Context context2 = this.getCurrentMacroContext();
        ArrayList arrayList = this.localContextStack;
        TemplateElement templateElement = context2.body;
        if (templateElement != null) {
            this.currentMacroContext = context2.prevMacroContext;
            this.currentNamespace = context2.bodyNamespace;
            Configurable configurable = this.getParent();
            this.setParent(this.currentNamespace.getTemplate());
            this.localContextStack = context2.prevLocalContextStack;
            if (context2.bodyParameterNames != null) {
                this.pushLocalContext(context);
            }
            try {
                this.visit(templateElement);
            }
            finally {
                if (context2.bodyParameterNames != null) {
                    this.popLocalContext();
                }
                this.currentMacroContext = context2;
                this.currentNamespace = this.getMacroNamespace(context2.getMacro());
                this.setParent(configurable);
                this.localContextStack = arrayList;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void visit(IteratorBlock.Context context) throws TemplateException, IOException {
        this.pushLocalContext(context);
        try {
            context.runLoop(this);
        }
        catch (BreakInstruction.Break break_) {
        }
        catch (TemplateException templateException) {
            this.handleTemplateException(templateException);
        }
        finally {
            this.popLocalContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void visit(TemplateNodeModel templateNodeModel, TemplateSequenceModel templateSequenceModel) throws TemplateException, IOException {
        block15: {
            if (this.nodeNamespaces == null) {
                SimpleSequence simpleSequence = new SimpleSequence(1);
                simpleSequence.add(this.currentNamespace);
                this.nodeNamespaces = simpleSequence;
            }
            int n = this.nodeNamespaceIndex;
            String string = this.currentNodeName;
            String string2 = this.currentNodeNS;
            TemplateSequenceModel templateSequenceModel2 = this.nodeNamespaces;
            TemplateNodeModel templateNodeModel2 = this.currentVisitorNode;
            this.currentVisitorNode = templateNodeModel;
            if (templateSequenceModel != null) {
                this.nodeNamespaces = templateSequenceModel;
            }
            try {
                TemplateModel templateModel = this.getNodeProcessor(templateNodeModel);
                if (templateModel instanceof Macro) {
                    this.visit((Macro)templateModel, null, null, null, null);
                    break block15;
                }
                if (templateModel instanceof TemplateTransformModel) {
                    this.visit(null, (TemplateTransformModel)templateModel, null);
                    break block15;
                }
                String string3 = templateNodeModel.getNodeType();
                if (string3 != null) {
                    if (string3.equals("text") && templateNodeModel instanceof TemplateScalarModel) {
                        this.out.write(((TemplateScalarModel)((Object)templateNodeModel)).getAsString());
                    } else if (string3.equals("document")) {
                        this.recurse(templateNodeModel, templateSequenceModel);
                    } else if (!(string3.equals("pi") || string3.equals("comment") || string3.equals("document_type"))) {
                        String string4 = "";
                        String string5 = templateNodeModel.getNodeNamespace();
                        if (string5 != null) {
                            string4 = string5.length() > 0 ? " and namespace " + string5 : " and no namespace";
                        }
                        throw new TemplateException("No macro or transform defined for node named " + templateNodeModel.getNodeName() + string4 + ", and there is no fallback handler called @" + string3 + " either.", this);
                    }
                    break block15;
                }
                String string6 = "";
                String string7 = templateNodeModel.getNodeNamespace();
                if (string7 != null) {
                    string6 = string7.length() > 0 ? " and namespace " + string7 : " and no namespace";
                }
                throw new TemplateException("No macro or transform defined for node with name " + templateNodeModel.getNodeName() + string6 + ", and there is no macro or transform called @default either.", this);
            }
            finally {
                this.currentVisitorNode = templateNodeModel2;
                this.nodeNamespaceIndex = n;
                this.currentNodeName = string;
                this.currentNodeNS = string2;
                this.nodeNamespaces = templateSequenceModel2;
            }
        }
    }

    void fallback() throws TemplateException, IOException {
        TemplateModel templateModel = this.getNodeProcessor(this.currentNodeName, this.currentNodeNS, this.nodeNamespaceIndex);
        if (templateModel instanceof Macro) {
            this.visit((Macro)templateModel, null, null, null, null);
        } else if (templateModel instanceof TemplateTransformModel) {
            this.visit(null, (TemplateTransformModel)templateModel, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void visit(Macro macro, Map map, List list, List list2, TemplateElement templateElement) throws TemplateException, IOException {
        block25: {
            if (macro == Macro.DO_NOTHING_MACRO) {
                return;
            }
            this.pushElement(macro);
            try {
                Object object;
                Macro.Context context = this.currentMacroContext;
                Macro macro2 = macro;
                macro2.getClass();
                Macro.Context context2 = new Macro.Context(macro2, this, templateElement, list2);
                String string = macro.getCatchAll();
                WrappingTemplateModel wrappingTemplateModel = null;
                if (map != null) {
                    if (string != null) {
                        wrappingTemplateModel = new SimpleHash();
                    }
                    object = map.entrySet().iterator();
                    while (object.hasNext()) {
                        Object object2;
                        Map.Entry entry = (Map.Entry)object.next();
                        String string2 = (String)entry.getKey();
                        boolean bl = macro.hasArgNamed(string2);
                        if (bl || string != null) {
                            object2 = (Expression)entry.getValue();
                            TemplateModel templateModel = ((Expression)object2).getAsTemplateModel(this);
                            if (bl) {
                                context2.setLocalVar(string2, templateModel);
                                continue;
                            }
                            ((SimpleHash)wrappingTemplateModel).put(string2, templateModel);
                            continue;
                        }
                        object2 = "Macro " + macro.getName() + " has no such argument: " + string2;
                        throw new TemplateException((String)object2, this);
                    }
                } else if (list != null) {
                    int n;
                    if (string != null) {
                        wrappingTemplateModel = new SimpleSequence();
                    }
                    if (((Object)(object = macro.getArgumentNames())).length < (n = list.size()) && string == null) {
                        throw new TemplateException("Macro " + macro.getName() + " only accepts " + ((Object)object).length + " parameters.", this);
                    }
                    for (int i = 0; i < n; ++i) {
                        Expression expression = (Expression)list.get(i);
                        TemplateModel templateModel = expression.getAsTemplateModel(this);
                        try {
                            if (i < ((Object)object).length) {
                                Object object3 = object[i];
                                context2.setLocalVar((String)object3, templateModel);
                                continue;
                            }
                            ((SimpleSequence)wrappingTemplateModel).add(templateModel);
                            continue;
                        }
                        catch (RuntimeException runtimeException) {
                            throw new TemplateException(runtimeException, this);
                        }
                    }
                }
                if (string != null) {
                    context2.setLocalVar(string, (TemplateModel)((Object)wrappingTemplateModel));
                }
                object = this.localContextStack;
                this.localContextStack = null;
                Namespace namespace = this.currentNamespace;
                Configurable configurable = this.getParent();
                this.currentNamespace = (Namespace)this.macroToNamespaceLookup.get(macro);
                this.currentMacroContext = context2;
                try {
                    context2.runMacro(this);
                }
                catch (ReturnInstruction.Return return_) {
                    this.currentMacroContext = context;
                    this.localContextStack = object;
                    this.currentNamespace = namespace;
                    this.setParent(configurable);
                }
                catch (TemplateException templateException) {
                    this.handleTemplateException(templateException);
                    break block25;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    this.currentMacroContext = context;
                    this.localContextStack = object;
                    this.currentNamespace = namespace;
                    this.setParent(configurable);
                }
            }
            finally {
                this.popElement();
            }
        }
    }

    void visitMacroDef(Macro macro) {
        this.macroToNamespaceLookup.put(macro, this.currentNamespace);
        this.currentNamespace.put(macro.getName(), macro);
    }

    Namespace getMacroNamespace(Macro macro) {
        return (Namespace)this.macroToNamespaceLookup.get(macro);
    }

    void recurse(TemplateNodeModel templateNodeModel, TemplateSequenceModel templateSequenceModel) throws TemplateException, IOException {
        if (templateNodeModel == null && (templateNodeModel = this.getCurrentVisitorNode()) == null) {
            throw new TemplateModelException("The target node of recursion is missing or null.");
        }
        TemplateSequenceModel templateSequenceModel2 = templateNodeModel.getChildNodes();
        if (templateSequenceModel2 == null) {
            return;
        }
        for (int i = 0; i < templateSequenceModel2.size(); ++i) {
            TemplateNodeModel templateNodeModel2 = (TemplateNodeModel)templateSequenceModel2.get(i);
            if (templateNodeModel2 == null) continue;
            this.visit(templateNodeModel2, templateSequenceModel);
        }
    }

    Macro.Context getCurrentMacroContext() {
        return this.currentMacroContext;
    }

    private void handleTemplateException(TemplateException templateException) throws TemplateException {
        if (this.lastThrowable == templateException) {
            throw templateException;
        }
        this.lastThrowable = templateException;
        if (logger.isErrorEnabled()) {
            logger.error("", templateException);
        }
        if (templateException instanceof StopException) {
            throw templateException;
        }
        this.getTemplateExceptionHandler().handleTemplateException(templateException, this, this.out);
    }

    public void setTemplateExceptionHandler(TemplateExceptionHandler templateExceptionHandler) {
        super.setTemplateExceptionHandler(templateExceptionHandler);
        this.lastThrowable = null;
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.numberFormats = null;
        this.numberFormat = null;
        this.dateFormats = null;
        this.dateTimeFormat = null;
        this.dateFormat = null;
        this.timeFormat = null;
        this.collator = null;
    }

    public void setTimeZone(TimeZone timeZone) {
        super.setTimeZone(timeZone);
        this.dateFormats = null;
        this.dateTimeFormat = null;
        this.dateFormat = null;
        this.timeFormat = null;
    }

    public void setURLEscapingCharset(String string) {
        this.urlEscapingCharsetCached = false;
        super.setURLEscapingCharset(string);
    }

    public void setOutputEncoding(String string) {
        this.urlEscapingCharsetCached = false;
        super.setOutputEncoding(string);
    }

    String getEffectiveURLEscapingCharset() {
        if (!this.urlEscapingCharsetCached) {
            this.cachedURLEscapingCharset = this.getURLEscapingCharset();
            if (this.cachedURLEscapingCharset == null) {
                this.cachedURLEscapingCharset = this.getOutputEncoding();
            }
            this.urlEscapingCharsetCached = true;
        }
        return this.cachedURLEscapingCharset;
    }

    Collator getCollator() {
        if (this.collator == null) {
            this.collator = Collator.getInstance(this.getLocale());
        }
        return this.collator;
    }

    public void setOut(Writer writer) {
        this.out = writer;
    }

    public Writer getOut() {
        return this.out;
    }

    String formatNumber(Number number) {
        if (this.numberFormat == null) {
            this.numberFormat = this.getNumberFormatObject(this.getNumberFormat());
        }
        return this.numberFormat.format(number);
    }

    public void setNumberFormat(String string) {
        super.setNumberFormat(string);
        this.numberFormat = null;
    }

    String formatDate(Date date, int n) throws TemplateModelException {
        DateFormat dateFormat = this.getDateFormatObject(n);
        if (dateFormat == null) {
            throw new TemplateModelException("Can't convert the date to string, because it is not known which parts of the date variable are in use. Use ?date, ?time or ?datetime built-in, or ?string.<format> or ?string(format) built-in with this date.");
        }
        return dateFormat.format(date);
    }

    public void setTimeFormat(String string) {
        super.setTimeFormat(string);
        this.timeFormat = null;
    }

    public void setDateFormat(String string) {
        super.setDateFormat(string);
        this.dateFormat = null;
    }

    public void setDateTimeFormat(String string) {
        super.setDateTimeFormat(string);
        this.dateTimeFormat = null;
    }

    public Configuration getConfiguration() {
        return this.getTemplate().getConfiguration();
    }

    TemplateModel getLastReturnValue() {
        return this.lastReturnValue;
    }

    void setLastReturnValue(TemplateModel templateModel) {
        this.lastReturnValue = templateModel;
    }

    void clearLastReturnValue() {
        this.lastReturnValue = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NumberFormat getNumberFormatObject(String string) {
        NumberFormat numberFormat;
        if (this.numberFormats == null) {
            this.numberFormats = new HashMap();
        }
        if ((numberFormat = (NumberFormat)this.numberFormats.get(string)) != null) {
            return numberFormat;
        }
        Map map = localizedNumberFormats;
        synchronized (map) {
            Locale locale = this.getLocale();
            NumberFormatKey numberFormatKey = new NumberFormatKey(string, locale);
            numberFormat = (NumberFormat)localizedNumberFormats.get(numberFormatKey);
            if (numberFormat == null) {
                numberFormat = "number".equals(string) ? NumberFormat.getNumberInstance(locale) : ("currency".equals(string) ? NumberFormat.getCurrencyInstance(locale) : ("percent".equals(string) ? NumberFormat.getPercentInstance(locale) : new DecimalFormat(string, new DecimalFormatSymbols(this.getLocale()))));
                localizedNumberFormats.put(numberFormatKey, numberFormat);
            }
        }
        numberFormat = (NumberFormat)numberFormat.clone();
        this.numberFormats.put(string, numberFormat);
        return numberFormat;
    }

    DateFormat getDateFormatObject(int n) throws TemplateModelException {
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                if (this.timeFormat == null) {
                    this.timeFormat = this.getDateFormatObject(n, this.getTimeFormat());
                }
                return this.timeFormat;
            }
            case 2: {
                if (this.dateFormat == null) {
                    this.dateFormat = this.getDateFormatObject(n, this.getDateFormat());
                }
                return this.dateFormat;
            }
            case 3: {
                if (this.dateTimeFormat == null) {
                    this.dateTimeFormat = this.getDateFormatObject(n, this.getDateTimeFormat());
                }
                return this.dateTimeFormat;
            }
        }
        throw new TemplateModelException("Unrecognized date type " + n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DateFormat getDateFormatObject(int n, String string) throws TemplateModelException {
        Map map;
        DateFormat dateFormat;
        if (this.dateFormats == null) {
            this.dateFormats = new Map[4];
            this.dateFormats[0] = new HashMap();
            this.dateFormats[1] = new HashMap();
            this.dateFormats[2] = new HashMap();
            this.dateFormats[3] = new HashMap();
        }
        if ((dateFormat = (DateFormat)(map = this.dateFormats[n]).get(string)) != null) {
            return dateFormat;
        }
        Map map2 = localizedDateFormats;
        synchronized (map2) {
            Locale locale = this.getLocale();
            TimeZone timeZone = this.getTimeZone();
            DateFormatKey dateFormatKey = new DateFormatKey(n, string, locale, timeZone);
            dateFormat = (DateFormat)localizedDateFormats.get(dateFormatKey);
            if (dateFormat == null) {
                int n2;
                StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
                int n3 = n2 = stringTokenizer.hasMoreTokens() ? this.parseDateStyleToken(stringTokenizer.nextToken()) : 2;
                if (n2 != -1) {
                    switch (n) {
                        case 0: {
                            throw new TemplateModelException("Can't convert the date to string using a built-in format, because it is not known which parts of the date variable are in use. Use ?date, ?time or ?datetime built-in, or ?string.<format> or ?string(<format>) built-in with explicit formatting pattern with this date.");
                        }
                        case 1: {
                            dateFormat = DateFormat.getTimeInstance(n2, locale);
                            break;
                        }
                        case 2: {
                            dateFormat = DateFormat.getDateInstance(n2, locale);
                            break;
                        }
                        case 3: {
                            int n4;
                            int n5 = n4 = stringTokenizer.hasMoreTokens() ? this.parseDateStyleToken(stringTokenizer.nextToken()) : n2;
                            if (n4 == -1) break;
                            dateFormat = DateFormat.getDateTimeInstance(n2, n4, locale);
                            break;
                        }
                    }
                }
                if (dateFormat == null) {
                    try {
                        dateFormat = new SimpleDateFormat(string, locale);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new TemplateModelException("Can't parse " + string + " to a date format.", illegalArgumentException);
                    }
                }
                dateFormat.setTimeZone(timeZone);
                localizedDateFormats.put(dateFormatKey, dateFormat);
            }
        }
        dateFormat = (DateFormat)dateFormat.clone();
        map.put(string, dateFormat);
        return dateFormat;
    }

    int parseDateStyleToken(String string) {
        if ("short".equals(string)) {
            return 3;
        }
        if ("medium".equals(string)) {
            return 2;
        }
        if ("long".equals(string)) {
            return 1;
        }
        if ("full".equals(string)) {
            return 0;
        }
        return -1;
    }

    TemplateTransformModel getTransform(Expression expression) throws TemplateException {
        TemplateTransformModel templateTransformModel = null;
        TemplateModel templateModel = expression.getAsTemplateModel(this);
        if (templateModel instanceof TemplateTransformModel) {
            templateTransformModel = (TemplateTransformModel)templateModel;
        } else if (expression instanceof Identifier && (templateModel = this.getConfiguration().getSharedVariable(expression.toString())) instanceof TemplateTransformModel) {
            templateTransformModel = (TemplateTransformModel)templateModel;
        }
        return templateTransformModel;
    }

    public TemplateModel getLocalVariable(String string) throws TemplateModelException {
        if (this.localContextStack != null) {
            for (int i = this.localContextStack.size() - 1; i >= 0; --i) {
                LocalContext localContext = (LocalContext)this.localContextStack.get(i);
                TemplateModel templateModel = localContext.getLocalVariable(string);
                if (templateModel == null) continue;
                return templateModel;
            }
        }
        return this.currentMacroContext == null ? null : this.currentMacroContext.getLocalVariable(string);
    }

    public TemplateModel getVariable(String string) throws TemplateModelException {
        TemplateModel templateModel = this.getLocalVariable(string);
        if (templateModel == null) {
            templateModel = this.currentNamespace.get(string);
        }
        if (templateModel == null) {
            templateModel = this.getGlobalVariable(string);
        }
        return templateModel;
    }

    public TemplateModel getGlobalVariable(String string) throws TemplateModelException {
        TemplateModel templateModel = this.globalNamespace.get(string);
        if (templateModel == null) {
            templateModel = this.rootDataModel.get(string);
        }
        if (templateModel == null) {
            templateModel = this.getConfiguration().getSharedVariable(string);
        }
        return templateModel;
    }

    public void setGlobalVariable(String string, TemplateModel templateModel) {
        this.globalNamespace.put(string, templateModel);
    }

    public void setVariable(String string, TemplateModel templateModel) {
        this.currentNamespace.put(string, templateModel);
    }

    public void setLocalVariable(String string, TemplateModel templateModel) {
        if (this.currentMacroContext == null) {
            throw new IllegalStateException("Not executing macro body");
        }
        this.currentMacroContext.setLocalVar(string, templateModel);
    }

    public Set getKnownVariableNames() throws TemplateModelException {
        TemplateModelIterator templateModelIterator;
        Set set = this.getConfiguration().getSharedVariableNames();
        if (this.rootDataModel instanceof TemplateHashModelEx) {
            templateModelIterator = ((TemplateHashModelEx)this.rootDataModel).keys().iterator();
            while (templateModelIterator.hasNext()) {
                set.add(((TemplateScalarModel)templateModelIterator.next()).getAsString());
            }
        }
        templateModelIterator = this.globalNamespace.keys().iterator();
        while (templateModelIterator.hasNext()) {
            set.add(((TemplateScalarModel)templateModelIterator.next()).getAsString());
        }
        templateModelIterator = this.currentNamespace.keys().iterator();
        while (templateModelIterator.hasNext()) {
            set.add(((TemplateScalarModel)templateModelIterator.next()).getAsString());
        }
        if (this.currentMacroContext != null) {
            set.addAll(this.currentMacroContext.getLocalVariableNames());
        }
        if (this.localContextStack != null) {
            for (int i = this.localContextStack.size() - 1; i >= 0; --i) {
                LocalContext localContext = (LocalContext)this.localContextStack.get(i);
                set.addAll(localContext.getLocalVariableNames());
            }
        }
        return set;
    }

    public void outputInstructionStack(PrintWriter printWriter) {
        TemplateElement templateElement;
        printWriter.println("----------");
        ListIterator listIterator = this.elementStack.listIterator(this.elementStack.size());
        if (listIterator.hasPrevious()) {
            printWriter.print("==> ");
            templateElement = (TemplateElement)listIterator.previous();
            printWriter.print(templateElement.getDescription());
            printWriter.print(" [");
            printWriter.print(templateElement.getStartLocation());
            printWriter.println("]");
        }
        while (listIterator.hasPrevious()) {
            String string;
            templateElement = (TemplateElement)listIterator.previous();
            if (!(templateElement instanceof UnifiedCall) && !(templateElement instanceof Include) || (string = templateElement.getDescription() + " [" + templateElement.getStartLocation() + "]") == null || string.length() <= 0) continue;
            printWriter.print(" in ");
            printWriter.println(string);
        }
        printWriter.println("----------");
        printWriter.flush();
    }

    private void pushLocalContext(LocalContext localContext) {
        if (this.localContextStack == null) {
            this.localContextStack = new ArrayList();
        }
        this.localContextStack.add(localContext);
    }

    private void popLocalContext() {
        this.localContextStack.remove(this.localContextStack.size() - 1);
    }

    ArrayList getLocalContextStack() {
        return this.localContextStack;
    }

    public Namespace getNamespace(String string) {
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (this.loadedLibs != null) {
            return (Namespace)this.loadedLibs.get(string);
        }
        return null;
    }

    public Namespace getMainNamespace() {
        return this.mainNamespace;
    }

    public Namespace getCurrentNamespace() {
        return this.currentNamespace;
    }

    public Namespace getGlobalNamespace() {
        return this.globalNamespace;
    }

    public TemplateHashModel getDataModel() {
        return new TemplateHashModel(){

            public boolean isEmpty() {
                return false;
            }

            public TemplateModel get(String string) throws TemplateModelException {
                TemplateModel templateModel = Environment.this.rootDataModel.get(string);
                if (templateModel == null) {
                    templateModel = Environment.this.getConfiguration().getSharedVariable(string);
                }
                return templateModel;
            }
        };
    }

    public TemplateHashModel getGlobalVariables() {
        return new TemplateHashModel(){

            public boolean isEmpty() {
                return false;
            }

            public TemplateModel get(String string) throws TemplateModelException {
                TemplateModel templateModel = Environment.this.globalNamespace.get(string);
                if (templateModel == null) {
                    templateModel = Environment.this.rootDataModel.get(string);
                }
                if (templateModel == null) {
                    templateModel = Environment.this.getConfiguration().getSharedVariable(string);
                }
                return templateModel;
            }
        };
    }

    private void pushElement(TemplateElement templateElement) {
        this.elementStack.add(templateElement);
    }

    private void popElement() {
        this.elementStack.remove(this.elementStack.size() - 1);
    }

    public TemplateNodeModel getCurrentVisitorNode() {
        return this.currentVisitorNode;
    }

    public void setCurrentVisitorNode(TemplateNodeModel templateNodeModel) {
        this.currentVisitorNode = templateNodeModel;
    }

    TemplateModel getNodeProcessor(TemplateNodeModel templateNodeModel) throws TemplateException {
        String string = templateNodeModel.getNodeName();
        if (string == null) {
            throw new TemplateException("Node name is null.", this);
        }
        TemplateModel templateModel = this.getNodeProcessor(string, templateNodeModel.getNodeNamespace(), 0);
        if (templateModel == null) {
            String string2 = templateNodeModel.getNodeType();
            if (string2 == null) {
                string2 = "default";
            }
            templateModel = this.getNodeProcessor("@" + string2, null, 0);
        }
        return templateModel;
    }

    private TemplateModel getNodeProcessor(String string, String string2, int n) throws TemplateException {
        int n2;
        TemplateModel templateModel = null;
        for (n2 = n; n2 < this.nodeNamespaces.size(); ++n2) {
            Namespace namespace = null;
            try {
                namespace = (Namespace)this.nodeNamespaces.get(n2);
            }
            catch (ClassCastException classCastException) {
                throw new InvalidReferenceException("A using clause should contain a sequence of namespaces or strings that indicate the location of importable macro libraries.", this);
            }
            templateModel = this.getNodeProcessor(namespace, string, string2);
            if (templateModel != null) break;
        }
        if (templateModel != null) {
            this.nodeNamespaceIndex = n2 + 1;
            this.currentNodeName = string;
            this.currentNodeNS = string2;
        }
        return templateModel;
    }

    private TemplateModel getNodeProcessor(Namespace namespace, String string, String string2) throws TemplateException {
        TemplateModel templateModel = null;
        if (string2 == null) {
            templateModel = namespace.get(string);
            if (!(templateModel instanceof Macro) && !(templateModel instanceof TemplateTransformModel)) {
                templateModel = null;
            }
        } else {
            Template template = namespace.getTemplate();
            String string3 = template.getPrefixForNamespace(string2);
            if (string3 == null) {
                return null;
            }
            if (string3.length() > 0) {
                templateModel = namespace.get(string3 + ":" + string);
                if (!(templateModel instanceof Macro) && !(templateModel instanceof TemplateTransformModel)) {
                    templateModel = null;
                }
            } else {
                if (string2.length() == 0 && !((templateModel = namespace.get("N:" + string)) instanceof Macro) && !(templateModel instanceof TemplateTransformModel)) {
                    templateModel = null;
                }
                if (string2.equals(template.getDefaultNS()) && !((templateModel = namespace.get("D:" + string)) instanceof Macro) && !(templateModel instanceof TemplateTransformModel)) {
                    templateModel = null;
                }
                if (templateModel == null && !((templateModel = namespace.get(string)) instanceof Macro) && !(templateModel instanceof TemplateTransformModel)) {
                    templateModel = null;
                }
            }
        }
        return templateModel;
    }

    public void include(String string, String string2, boolean bl) throws IOException, TemplateException {
        this.include(this.getTemplateForInclusion(string, string2, bl));
    }

    public Template getTemplateForInclusion(String string, String string2, boolean bl) throws IOException {
        if (string2 == null) {
            string2 = this.getTemplate().getEncoding();
        }
        if (string2 == null) {
            string2 = this.getConfiguration().getEncoding(this.getLocale());
        }
        return this.getConfiguration().getTemplate(string, this.getLocale(), string2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void include(Template template) throws TemplateException, IOException {
        Template template2 = this.getTemplate();
        this.setParent(template);
        this.importMacros(template);
        try {
            this.visit(template.getRootTreeNode());
        }
        finally {
            this.setParent(template2);
        }
    }

    public Namespace importLib(String string, String string2) throws IOException, TemplateException {
        return this.importLib(this.getTemplateForImporting(string), string2);
    }

    public Template getTemplateForImporting(String string) throws IOException {
        return this.getTemplateForInclusion(string, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Namespace importLib(Template template, String string) throws IOException, TemplateException {
        String string2;
        Namespace namespace;
        if (this.loadedLibs == null) {
            this.loadedLibs = new HashMap();
        }
        if ((namespace = (Namespace)this.loadedLibs.get(string2 = template.getName())) != null) {
            if (string != null) {
                this.setVariable(string, namespace);
            }
        } else {
            Namespace namespace2 = new Namespace(template);
            if (string != null) {
                this.currentNamespace.put(string, namespace2);
                if (this.currentNamespace == this.mainNamespace) {
                    this.globalNamespace.put(string, namespace2);
                }
            }
            Namespace namespace3 = this.currentNamespace;
            this.currentNamespace = namespace2;
            this.loadedLibs.put(string2, this.currentNamespace);
            Writer writer = this.out;
            this.out = NULL_WRITER;
            try {
                this.include(template);
            }
            finally {
                this.out = writer;
                this.currentNamespace = namespace3;
            }
        }
        return (Namespace)this.loadedLibs.get(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String renderElementToString(TemplateElement templateElement) throws IOException, TemplateException {
        Writer writer = this.out;
        try {
            StringWriter stringWriter = new StringWriter();
            this.out = stringWriter;
            this.visit(templateElement);
            String string = stringWriter.toString();
            return string;
        }
        finally {
            this.out = writer;
        }
    }

    void importMacros(Template template) {
        Iterator iterator = template.getMacros().values().iterator();
        while (iterator.hasNext()) {
            this.visitMacroDef((Macro)iterator.next());
        }
    }

    public String getNamespaceForPrefix(String string) {
        return this.currentNamespace.getTemplate().getNamespaceForPrefix(string);
    }

    public String getPrefixForNamespace(String string) {
        return this.currentNamespace.getTemplate().getPrefixForNamespace(string);
    }

    public String getDefaultNS() {
        return this.currentNamespace.getTemplate().getDefaultNS();
    }

    public Object __getitem__(String string) throws TemplateModelException {
        return BeansWrapper.getDefaultInstance().unwrap(this.getVariable(string));
    }

    public void __setitem__(String string, Object object) throws TemplateException {
        this.setGlobalVariable(string, this.getObjectWrapper().wrap(object));
    }

    private static final class DateFormatKey {
        private final int dateType;
        private final String pattern;
        private final Locale locale;
        private final TimeZone timeZone;

        DateFormatKey(int n, String string, Locale locale, TimeZone timeZone) {
            this.dateType = n;
            this.pattern = string;
            this.locale = locale;
            this.timeZone = timeZone;
        }

        public boolean equals(Object object) {
            if (object instanceof DateFormatKey) {
                DateFormatKey dateFormatKey = (DateFormatKey)object;
                return this.dateType == dateFormatKey.dateType && dateFormatKey.pattern.equals(this.pattern) && dateFormatKey.locale.equals(this.locale) && dateFormatKey.timeZone.equals(this.timeZone);
            }
            return false;
        }

        public int hashCode() {
            return this.dateType ^ this.pattern.hashCode() ^ this.locale.hashCode() ^ this.timeZone.hashCode();
        }
    }

    public class Namespace
    extends SimpleHash {
        private Template template;

        Namespace() {
            this.template = Environment.this.getTemplate();
        }

        Namespace(Template template) {
            this.template = template;
        }

        public Template getTemplate() {
            return this.template == null ? Environment.this.getTemplate() : this.template;
        }
    }

    private static final class NumberFormatKey {
        private final String pattern;
        private final Locale locale;

        NumberFormatKey(String string, Locale locale) {
            this.pattern = string;
            this.locale = locale;
        }

        public boolean equals(Object object) {
            if (object instanceof NumberFormatKey) {
                NumberFormatKey numberFormatKey = (NumberFormatKey)object;
                return numberFormatKey.pattern.equals(this.pattern) && numberFormatKey.locale.equals(this.locale);
            }
            return false;
        }

        public int hashCode() {
            return this.pattern.hashCode() ^ this.locale.hashCode();
        }
    }
}

