/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.EvaluationUtil;
import freemarker.core.Expression;
import freemarker.core.NonStringException;
import freemarker.core.Range;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import java.util.ArrayList;

final class DynamicKeyName
extends Expression {
    private final Expression nameExpression;
    private final Expression target;

    DynamicKeyName(Expression expression, Expression expression2) {
        this.target = expression;
        this.nameExpression = expression2;
    }

    TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
        TemplateModel templateModel = this.target.getAsTemplateModel(environment);
        DynamicKeyName.assertNonNull(templateModel, this.target, environment);
        if (this.nameExpression instanceof Range) {
            return this.dealWithRangeKey(templateModel, (Range)this.nameExpression, environment);
        }
        TemplateModel templateModel2 = this.nameExpression.getAsTemplateModel(environment);
        if (templateModel2 == null) {
            if (environment.isClassicCompatible()) {
                templateModel2 = TemplateScalarModel.EMPTY_STRING;
            } else {
                DynamicKeyName.assertNonNull(templateModel2, this.nameExpression, environment);
            }
        }
        if (templateModel2 instanceof TemplateNumberModel) {
            int n = EvaluationUtil.getNumber(templateModel2, this.nameExpression, environment).intValue();
            return this.dealWithNumericalKey(templateModel, n, environment);
        }
        if (templateModel2 instanceof TemplateScalarModel) {
            String string = EvaluationUtil.getString((TemplateScalarModel)templateModel2, this.nameExpression, environment);
            return this.dealWithStringKey(templateModel, string, environment);
        }
        throw DynamicKeyName.invalidTypeException(templateModel2, this.nameExpression, environment, "number, range, or string");
    }

    private TemplateModel dealWithNumericalKey(TemplateModel templateModel, int n, Environment environment) throws TemplateException {
        if (templateModel instanceof TemplateSequenceModel) {
            TemplateSequenceModel templateSequenceModel = (TemplateSequenceModel)templateModel;
            int n2 = Integer.MAX_VALUE;
            try {
                n2 = templateSequenceModel.size();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return n < n2 ? templateSequenceModel.get(n) : null;
        }
        try {
            String string = this.target.getStringValue(environment);
            try {
                return new SimpleScalar(string.substring(n, n + 1));
            }
            catch (RuntimeException runtimeException) {
                throw new TemplateException("", runtimeException, environment);
            }
        }
        catch (NonStringException nonStringException) {
            throw DynamicKeyName.invalidTypeException(templateModel, this.target, environment, "number, sequence, or string");
        }
    }

    private TemplateModel dealWithStringKey(TemplateModel templateModel, String string, Environment environment) throws TemplateException {
        if (templateModel instanceof TemplateHashModel) {
            return ((TemplateHashModel)templateModel).get(string);
        }
        throw DynamicKeyName.invalidTypeException(templateModel, this.target, environment, "hash");
    }

    private TemplateModel dealWithRangeKey(TemplateModel templateModel, Range range, Environment environment) throws TemplateException {
        int n = EvaluationUtil.getNumber(range.left, environment).intValue();
        int n2 = 0;
        boolean bl = range.hasRhs();
        if (bl) {
            n2 = EvaluationUtil.getNumber(range.right, environment).intValue();
        }
        if (templateModel instanceof TemplateSequenceModel) {
            TemplateSequenceModel templateSequenceModel = (TemplateSequenceModel)templateModel;
            if (!bl) {
                n2 = templateSequenceModel.size() - 1;
            }
            if (n < 0) {
                String string = range.left.getStartLocation() + "\nNegative starting index for range, is " + range;
                throw new TemplateException(string, environment);
            }
            if (n2 < 0) {
                String string = range.left.getStartLocation() + "\nNegative ending index for range, is " + range;
                throw new TemplateException(string, environment);
            }
            if (n >= templateSequenceModel.size()) {
                String string = range.left.getStartLocation() + "\nLeft side index of range out of bounds, is " + n + ", but the sequence has only " + templateSequenceModel.size() + " element(s) " + "(note that indices are 0 based, and ranges are inclusive).";
                throw new TemplateException(string, environment);
            }
            if (n2 >= templateSequenceModel.size()) {
                String string = range.right.getStartLocation() + "\nRight side index of range out of bounds, is " + n2 + ", but the sequence has only " + templateSequenceModel.size() + " element(s)." + "(note that indices are 0 based, and ranges are inclusive).";
                throw new TemplateException(string, environment);
            }
            ArrayList<TemplateModel> arrayList = new ArrayList<TemplateModel>(1 + Math.abs(n - n2));
            if (n > n2) {
                for (int i = n; i >= n2; --i) {
                    arrayList.add(templateSequenceModel.get(i));
                }
            } else {
                for (int i = n; i <= n2; ++i) {
                    arrayList.add(templateSequenceModel.get(i));
                }
            }
            return new SimpleSequence(arrayList);
        }
        try {
            String string = this.target.getStringValue(environment);
            if (!bl) {
                n2 = string.length() - 1;
            }
            if (n < 0) {
                String string2 = range.left.getStartLocation() + "\nNegative starting index for range " + range + " : " + n;
                throw new TemplateException(string2, environment);
            }
            if (n2 < 0) {
                String string3 = range.left.getStartLocation() + "\nNegative ending index for range " + range + " : " + n2;
                throw new TemplateException(string3, environment);
            }
            if (n > string.length()) {
                String string4 = range.left.getStartLocation() + "\nLeft side of range out of bounds, is: " + n + "\nbut string " + templateModel + " has " + string.length() + " elements.";
                throw new TemplateException(string4, environment);
            }
            if (n2 > string.length()) {
                String string5 = range.right.getStartLocation() + "\nRight side of range out of bounds, is: " + n2 + "\nbut string " + templateModel + " is only " + string.length() + " characters.";
                throw new TemplateException(string5, environment);
            }
            try {
                return new SimpleScalar(string.substring(n, n2 + 1));
            }
            catch (RuntimeException runtimeException) {
                String string6 = "Error " + this.getStartLocation();
                throw new TemplateException(string6, runtimeException, environment);
            }
        }
        catch (NonStringException nonStringException) {
            throw DynamicKeyName.invalidTypeException(this.target.getAsTemplateModel(environment), this.target, environment, "number, scalar, or sequence");
        }
    }

    public String getCanonicalForm() {
        return this.target.getCanonicalForm() + "[" + this.nameExpression.getCanonicalForm() + "]";
    }

    boolean isLiteral() {
        return this.constantValue != null || this.target.isLiteral() && this.nameExpression.isLiteral();
    }

    Expression _deepClone(String string, Expression expression) {
        return new DynamicKeyName(this.target.deepClone(string, expression), this.nameExpression.deepClone(string, expression));
    }
}

