/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.TemplateElement;
import freemarker.template.TemplateException;
import java.io.IOException;

final class DollarVariable
extends TemplateElement {
    private final Expression expression;
    private final Expression escapedExpression;

    DollarVariable(Expression expression, Expression expression2) {
        this.expression = expression;
        this.escapedExpression = expression2;
    }

    void accept(Environment environment) throws TemplateException, IOException {
        environment.getOut().write(this.escapedExpression.getStringValue(environment));
    }

    public String getCanonicalForm() {
        return "${" + this.expression.getCanonicalForm() + "}";
    }

    public String getDescription() {
        return this.getSource() + (this.expression == this.escapedExpression ? "" : " escaped ${" + this.escapedExpression.getCanonicalForm() + "}");
    }

    boolean heedsOpeningWhitespace() {
        return true;
    }

    boolean heedsTrailingWhitespace() {
        return true;
    }
}

