/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.InvalidReferenceException;
import freemarker.core.ParentheticalExpression;
import freemarker.template.SimpleCollection;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import java.util.ArrayList;

class DefaultToExpression
extends Expression {
    private static final TemplateCollectionModel EMPTY_COLLECTION = new SimpleCollection(new ArrayList(0));
    static final TemplateModel EMPTY_STRING_AND_SEQUENCE = new EmptyStringAndSequence();
    private Expression lhs;
    private Expression rhs;

    DefaultToExpression(Expression expression, Expression expression2) {
        this.lhs = expression;
        this.rhs = expression2;
    }

    TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
        TemplateModel templateModel;
        block4: {
            templateModel = null;
            try {
                templateModel = this.lhs.getAsTemplateModel(environment);
            }
            catch (InvalidReferenceException invalidReferenceException) {
                if (this.lhs instanceof ParentheticalExpression) break block4;
                throw invalidReferenceException;
            }
        }
        if (templateModel != null) {
            return templateModel;
        }
        if (this.rhs == null) {
            return EMPTY_STRING_AND_SEQUENCE;
        }
        return this.rhs.getAsTemplateModel(environment);
    }

    boolean isLiteral() {
        return false;
    }

    Expression _deepClone(String string, Expression expression) {
        if (this.rhs == null) {
            return new DefaultToExpression(this.lhs.deepClone(string, expression), null);
        }
        return new DefaultToExpression(this.lhs.deepClone(string, expression), this.rhs.deepClone(string, expression));
    }

    public String getCanonicalForm() {
        if (this.rhs == null) {
            return this.lhs.getCanonicalForm() + "!";
        }
        return this.lhs.getCanonicalForm() + "!" + this.rhs.getCanonicalForm();
    }

    private static class EmptyStringAndSequence
    implements TemplateScalarModel,
    TemplateSequenceModel,
    TemplateHashModelEx {
        private EmptyStringAndSequence() {
        }

        public String getAsString() {
            return "";
        }

        public TemplateModel get(int n) {
            return null;
        }

        public TemplateModel get(String string) {
            return null;
        }

        public int size() {
            return 0;
        }

        public boolean isEmpty() {
            return true;
        }

        public TemplateCollectionModel keys() {
            return EMPTY_COLLECTION;
        }

        public TemplateCollectionModel values() {
            return EMPTY_COLLECTION;
        }
    }
}

