/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Configurable;
import freemarker.core.Environment;
import freemarker.template.Template;

public class CustomAttribute {
    public static final int SCOPE_ENVIRONMENT = 0;
    public static final int SCOPE_TEMPLATE = 1;
    public static final int SCOPE_CONFIGURATION = 2;
    private final Object key = new Object();
    private final int scope;

    public CustomAttribute(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException();
        }
        this.scope = n;
    }

    protected Object create() {
        return null;
    }

    public final Object get() {
        return this.getScopeConfigurable().getCustomAttribute(this.key, this);
    }

    public final Object get(Template template) {
        if (this.scope != 1) {
            throw new UnsupportedOperationException("This is not a template-scope attribute");
        }
        return template.getCustomAttribute(this.key, this);
    }

    public final void set(Object object) {
        this.getScopeConfigurable().setCustomAttribute(this.key, object);
    }

    public final void set(Object object, Template template) {
        if (this.scope != 1) {
            throw new UnsupportedOperationException("This is not a template-scope attribute");
        }
        template.setCustomAttribute(this.key, object);
    }

    private Configurable getScopeConfigurable() {
        Environment environment = Environment.getCurrentEnvironment();
        if (environment == null) {
            throw new IllegalStateException("No current environment");
        }
        switch (this.scope) {
            case 0: {
                return environment;
            }
            case 1: {
                return environment.getParent();
            }
            case 2: {
                return environment.getParent().getParent();
            }
        }
        throw new Error();
    }
}

