/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.ArithmeticEngine;
import freemarker.core.CustomAttribute;
import freemarker.core.Environment;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.utility.ClassUtil;
import freemarker.template.utility.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;

public class Configurable {
    public static final String LOCALE_KEY = "locale";
    public static final String NUMBER_FORMAT_KEY = "number_format";
    public static final String TIME_FORMAT_KEY = "time_format";
    public static final String DATE_FORMAT_KEY = "date_format";
    public static final String DATETIME_FORMAT_KEY = "datetime_format";
    public static final String TIME_ZONE_KEY = "time_zone";
    public static final String CLASSIC_COMPATIBLE_KEY = "classic_compatible";
    public static final String TEMPLATE_EXCEPTION_HANDLER_KEY = "template_exception_handler";
    public static final String ARITHMETIC_ENGINE_KEY = "arithmetic_engine";
    public static final String OBJECT_WRAPPER_KEY = "object_wrapper";
    public static final String BOOLEAN_FORMAT_KEY = "boolean_format";
    public static final String OUTPUT_ENCODING_KEY = "output_encoding";
    public static final String URL_ESCAPING_CHARSET_KEY = "url_escaping_charset";
    public static final String STRICT_BEAN_MODELS = "strict_bean_models";
    private static final char COMMA = ',';
    private Configurable parent;
    private Properties properties;
    private HashMap customAttributes;
    private Locale locale;
    private String numberFormat;
    private String timeFormat;
    private String dateFormat;
    private String dateTimeFormat;
    private TimeZone timeZone;
    private String trueFormat;
    private String falseFormat;
    private Boolean classicCompatible;
    private TemplateExceptionHandler templateExceptionHandler;
    private ArithmeticEngine arithmeticEngine;
    private ObjectWrapper objectWrapper;
    private String outputEncoding;
    private boolean outputEncodingSet;
    private String urlEscapingCharset;
    private boolean urlEscapingCharsetSet;

    public Configurable() {
        this.parent = null;
        this.locale = Locale.getDefault();
        this.timeZone = TimeZone.getDefault();
        this.numberFormat = "number";
        this.timeFormat = "";
        this.dateFormat = "";
        this.dateTimeFormat = "";
        this.trueFormat = "true";
        this.falseFormat = "false";
        this.classicCompatible = Boolean.FALSE;
        this.templateExceptionHandler = TemplateExceptionHandler.DEBUG_HANDLER;
        this.arithmeticEngine = ArithmeticEngine.BIGDECIMAL_ENGINE;
        this.objectWrapper = ObjectWrapper.DEFAULT_WRAPPER;
        this.properties = new Properties();
        this.properties.setProperty(LOCALE_KEY, this.locale.toString());
        this.properties.setProperty(TIME_FORMAT_KEY, this.timeFormat);
        this.properties.setProperty(DATE_FORMAT_KEY, this.dateFormat);
        this.properties.setProperty(DATETIME_FORMAT_KEY, this.dateTimeFormat);
        this.properties.setProperty(TIME_ZONE_KEY, this.timeZone.getID());
        this.properties.setProperty(NUMBER_FORMAT_KEY, this.numberFormat);
        this.properties.setProperty(CLASSIC_COMPATIBLE_KEY, this.classicCompatible.toString());
        this.properties.setProperty(TEMPLATE_EXCEPTION_HANDLER_KEY, this.templateExceptionHandler.getClass().getName());
        this.properties.setProperty(ARITHMETIC_ENGINE_KEY, this.arithmeticEngine.getClass().getName());
        this.properties.setProperty(BOOLEAN_FORMAT_KEY, "true,false");
        this.customAttributes = new HashMap();
    }

    public Configurable(Configurable configurable) {
        this.parent = configurable;
        this.locale = null;
        this.numberFormat = null;
        this.trueFormat = null;
        this.falseFormat = null;
        this.classicCompatible = null;
        this.templateExceptionHandler = null;
        this.properties = new Properties(configurable.properties);
        this.customAttributes = new HashMap();
    }

    protected Object clone() throws CloneNotSupportedException {
        Configurable configurable = (Configurable)super.clone();
        configurable.properties = new Properties(this.properties);
        configurable.customAttributes = (HashMap)this.customAttributes.clone();
        return configurable;
    }

    public final Configurable getParent() {
        return this.parent;
    }

    final void setParent(Configurable configurable) {
        this.parent = configurable;
    }

    public void setClassicCompatible(boolean bl) {
        this.classicCompatible = bl ? Boolean.TRUE : Boolean.FALSE;
        this.properties.setProperty(CLASSIC_COMPATIBLE_KEY, this.classicCompatible.toString());
    }

    public boolean isClassicCompatible() {
        return this.classicCompatible != null ? this.classicCompatible.booleanValue() : this.parent.isClassicCompatible();
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("Setting \"locale\" can't be null");
        }
        this.locale = locale;
        this.properties.setProperty(LOCALE_KEY, locale.toString());
    }

    public TimeZone getTimeZone() {
        return this.timeZone != null ? this.timeZone : this.parent.getTimeZone();
    }

    public void setTimeZone(TimeZone timeZone) {
        if (timeZone == null) {
            throw new IllegalArgumentException("Setting \"time_zone\" can't be null");
        }
        this.timeZone = timeZone;
        this.properties.setProperty(TIME_ZONE_KEY, timeZone.getID());
    }

    public Locale getLocale() {
        return this.locale != null ? this.locale : this.parent.getLocale();
    }

    public void setNumberFormat(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Setting \"number_format\" can't be null");
        }
        this.numberFormat = string;
        this.properties.setProperty(NUMBER_FORMAT_KEY, string);
    }

    public String getNumberFormat() {
        return this.numberFormat != null ? this.numberFormat : this.parent.getNumberFormat();
    }

    public void setBooleanFormat(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Setting \"boolean_format\" can't be null");
        }
        int n = string.indexOf(44);
        if (n == -1) {
            throw new IllegalArgumentException("Setting \"boolean_format\" must consist of two comma-separated values for true and false respectively");
        }
        this.trueFormat = string.substring(0, n);
        this.falseFormat = string.substring(n + 1);
        this.properties.setProperty(BOOLEAN_FORMAT_KEY, string);
    }

    public String getBooleanFormat() {
        if (this.trueFormat == null) {
            return this.parent.getBooleanFormat();
        }
        return this.trueFormat + ',' + this.falseFormat;
    }

    String getBooleanFormat(boolean bl) {
        return bl ? this.getTrueFormat() : this.getFalseFormat();
    }

    private String getTrueFormat() {
        return this.trueFormat != null ? this.trueFormat : this.parent.getTrueFormat();
    }

    private String getFalseFormat() {
        return this.falseFormat != null ? this.falseFormat : this.parent.getFalseFormat();
    }

    public void setTimeFormat(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Setting \"time_format\" can't be null");
        }
        this.timeFormat = string;
        this.properties.setProperty(TIME_FORMAT_KEY, string);
    }

    public String getTimeFormat() {
        return this.timeFormat != null ? this.timeFormat : this.parent.getTimeFormat();
    }

    public void setDateFormat(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Setting \"date_format\" can't be null");
        }
        this.dateFormat = string;
        this.properties.setProperty(DATE_FORMAT_KEY, string);
    }

    public String getDateFormat() {
        return this.dateFormat != null ? this.dateFormat : this.parent.getDateFormat();
    }

    public void setDateTimeFormat(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Setting \"datetime_format\" can't be null");
        }
        this.dateTimeFormat = string;
        this.properties.setProperty(DATETIME_FORMAT_KEY, string);
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat != null ? this.dateTimeFormat : this.parent.getDateTimeFormat();
    }

    public void setTemplateExceptionHandler(TemplateExceptionHandler templateExceptionHandler) {
        if (templateExceptionHandler == null) {
            throw new IllegalArgumentException("Setting \"template_exception_handler\" can't be null");
        }
        this.templateExceptionHandler = templateExceptionHandler;
        this.properties.setProperty(TEMPLATE_EXCEPTION_HANDLER_KEY, templateExceptionHandler.getClass().getName());
    }

    public TemplateExceptionHandler getTemplateExceptionHandler() {
        return this.templateExceptionHandler != null ? this.templateExceptionHandler : this.parent.getTemplateExceptionHandler();
    }

    public void setArithmeticEngine(ArithmeticEngine arithmeticEngine) {
        if (arithmeticEngine == null) {
            throw new IllegalArgumentException("Setting \"arithmetic_engine\" can't be null");
        }
        this.arithmeticEngine = arithmeticEngine;
        this.properties.setProperty(ARITHMETIC_ENGINE_KEY, arithmeticEngine.getClass().getName());
    }

    public ArithmeticEngine getArithmeticEngine() {
        return this.arithmeticEngine != null ? this.arithmeticEngine : this.parent.getArithmeticEngine();
    }

    public void setObjectWrapper(ObjectWrapper objectWrapper) {
        if (objectWrapper == null) {
            throw new IllegalArgumentException("Setting \"object_wrapper\" can't be null");
        }
        this.objectWrapper = objectWrapper;
        this.properties.setProperty(OBJECT_WRAPPER_KEY, objectWrapper.getClass().getName());
    }

    public ObjectWrapper getObjectWrapper() {
        return this.objectWrapper != null ? this.objectWrapper : this.parent.getObjectWrapper();
    }

    public void setOutputEncoding(String string) {
        this.outputEncoding = string;
        if (string != null) {
            this.properties.setProperty(OUTPUT_ENCODING_KEY, string);
        } else {
            this.properties.remove(OUTPUT_ENCODING_KEY);
        }
        this.outputEncodingSet = true;
    }

    public String getOutputEncoding() {
        return this.outputEncodingSet ? this.outputEncoding : (this.parent != null ? this.parent.getOutputEncoding() : null);
    }

    public void setURLEscapingCharset(String string) {
        this.urlEscapingCharset = string;
        if (string != null) {
            this.properties.setProperty(URL_ESCAPING_CHARSET_KEY, string);
        } else {
            this.properties.remove(URL_ESCAPING_CHARSET_KEY);
        }
        this.urlEscapingCharsetSet = true;
    }

    public String getURLEscapingCharset() {
        return this.urlEscapingCharsetSet ? this.urlEscapingCharset : (this.parent != null ? this.parent.getURLEscapingCharset() : null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSetting(String string, String string2) throws TemplateException {
        try {
            if (LOCALE_KEY.equals(string)) {
                this.setLocale(StringUtil.deduceLocale(string2));
                return;
            } else if (NUMBER_FORMAT_KEY.equals(string)) {
                this.setNumberFormat(string2);
                return;
            } else if (TIME_FORMAT_KEY.equals(string)) {
                this.setTimeFormat(string2);
                return;
            } else if (DATE_FORMAT_KEY.equals(string)) {
                this.setDateFormat(string2);
                return;
            } else if (DATETIME_FORMAT_KEY.equals(string)) {
                this.setDateTimeFormat(string2);
                return;
            } else if (TIME_ZONE_KEY.equals(string)) {
                this.setTimeZone(TimeZone.getTimeZone(string2));
                return;
            } else if (CLASSIC_COMPATIBLE_KEY.equals(string)) {
                this.setClassicCompatible(StringUtil.getYesNo(string2));
                return;
            } else if (TEMPLATE_EXCEPTION_HANDLER_KEY.equals(string)) {
                if (string2.indexOf(46) == -1) {
                    if ("debug".equalsIgnoreCase(string2)) {
                        this.setTemplateExceptionHandler(TemplateExceptionHandler.DEBUG_HANDLER);
                        return;
                    } else if ("html_debug".equalsIgnoreCase(string2)) {
                        this.setTemplateExceptionHandler(TemplateExceptionHandler.HTML_DEBUG_HANDLER);
                        return;
                    } else if ("ignore".equalsIgnoreCase(string2)) {
                        this.setTemplateExceptionHandler(TemplateExceptionHandler.IGNORE_HANDLER);
                        return;
                    } else {
                        if (!"rethrow".equalsIgnoreCase(string2)) throw this.invalidSettingValueException(string, string2);
                        this.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
                    }
                    return;
                } else {
                    this.setTemplateExceptionHandler((TemplateExceptionHandler)ClassUtil.forName(string2).newInstance());
                }
                return;
            } else if (ARITHMETIC_ENGINE_KEY.equals(string)) {
                if (string2.indexOf(46) == -1) {
                    if ("bigdecimal".equalsIgnoreCase(string2)) {
                        this.setArithmeticEngine(ArithmeticEngine.BIGDECIMAL_ENGINE);
                        return;
                    } else {
                        if (!"conservative".equalsIgnoreCase(string2)) throw this.invalidSettingValueException(string, string2);
                        this.setArithmeticEngine(ArithmeticEngine.CONSERVATIVE_ENGINE);
                    }
                    return;
                } else {
                    this.setArithmeticEngine((ArithmeticEngine)ClassUtil.forName(string2).newInstance());
                }
                return;
            } else if (OBJECT_WRAPPER_KEY.equals(string)) {
                if (string2.indexOf(46) == -1) {
                    if ("default".equalsIgnoreCase(string2)) {
                        this.setObjectWrapper(ObjectWrapper.DEFAULT_WRAPPER);
                        return;
                    } else if ("simple".equalsIgnoreCase(string2)) {
                        this.setObjectWrapper(ObjectWrapper.SIMPLE_WRAPPER);
                        return;
                    } else if ("beans".equalsIgnoreCase(string2)) {
                        this.setObjectWrapper(ObjectWrapper.BEANS_WRAPPER);
                        return;
                    } else {
                        if (!"jython".equalsIgnoreCase(string2)) throw this.invalidSettingValueException(string, string2);
                        Class<?> clazz = Class.forName("freemarker.ext.jython.JythonWrapper");
                        this.setObjectWrapper((ObjectWrapper)clazz.getField("INSTANCE").get(null));
                    }
                    return;
                } else {
                    this.setObjectWrapper((ObjectWrapper)ClassUtil.forName(string2).newInstance());
                }
                return;
            } else if (BOOLEAN_FORMAT_KEY.equals(string)) {
                this.setBooleanFormat(string2);
                return;
            } else if (OUTPUT_ENCODING_KEY.equals(string)) {
                this.setOutputEncoding(string2);
                return;
            } else if (URL_ESCAPING_CHARSET_KEY.equals(string)) {
                this.setURLEscapingCharset(string2);
                return;
            } else {
                if (!STRICT_BEAN_MODELS.equals(string)) throw this.unknownSettingException(string);
                this.setStrictBeanModels(StringUtil.getYesNo(string2));
            }
            return;
        }
        catch (TemplateException templateException) {
            throw templateException;
        }
        catch (Exception exception) {
            throw new TemplateException("Failed to set setting " + string + " to value " + string2, exception, this.getEnvironment());
        }
    }

    public void setStrictBeanModels(boolean bl) {
        if (!(this.objectWrapper instanceof BeansWrapper)) {
            throw new IllegalStateException("Not a beans wrapper");
        }
        ((BeansWrapper)this.objectWrapper).setStrict(bl);
    }

    public String getSetting(String string) {
        return this.properties.getProperty(string);
    }

    public Map getSettings() {
        return Collections.unmodifiableMap(this.properties);
    }

    protected Environment getEnvironment() {
        return this instanceof Environment ? (Environment)this : Environment.getCurrentEnvironment();
    }

    protected TemplateException unknownSettingException(String string) {
        return new UnknownSettingException(string, this.getEnvironment());
    }

    protected TemplateException invalidSettingValueException(String string, String string2) {
        return new TemplateException("Invalid value for setting " + string + ": " + string2, this.getEnvironment());
    }

    public void setSettings(Properties properties) throws TemplateException {
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.setSetting(string, properties.getProperty(string).trim());
        }
    }

    public void setSettings(InputStream inputStream) throws TemplateException, IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        this.setSettings(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCustomAttribute(Object object, Object object2) {
        HashMap hashMap = this.customAttributes;
        synchronized (hashMap) {
            this.customAttributes.put(object, object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getCustomAttribute(Object object, CustomAttribute customAttribute) {
        HashMap hashMap = this.customAttributes;
        synchronized (hashMap) {
            Object object2 = this.customAttributes.get(object);
            if (object2 == null && !this.customAttributes.containsKey(object)) {
                object2 = customAttribute.create();
                this.customAttributes.put(object, object2);
            }
            return object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCustomAttribute(String string, Object object) {
        HashMap hashMap = this.customAttributes;
        synchronized (hashMap) {
            this.customAttributes.put(string, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getCustomAttributeNames() {
        HashMap hashMap = this.customAttributes;
        synchronized (hashMap) {
            LinkedList linkedList = new LinkedList(this.customAttributes.keySet());
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() instanceof String) continue;
                iterator.remove();
            }
            return linkedList.toArray(new String[linkedList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCustomAttribute(String string) {
        HashMap hashMap = this.customAttributes;
        synchronized (hashMap) {
            this.customAttributes.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCustomAttribute(String string) {
        Object v;
        HashMap hashMap = this.customAttributes;
        synchronized (hashMap) {
            v = this.customAttributes.get(string);
            if (v == null && this.customAttributes.containsKey(string)) {
                return null;
            }
        }
        if (v == null && this.parent != null) {
            return this.parent.getCustomAttribute(string);
        }
        return v;
    }

    public class UnknownSettingException
    extends TemplateException {
        private UnknownSettingException(String string, Environment environment) {
            super("Unknown setting: " + string, environment);
        }
    }
}

