/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.TemplateElement;
import freemarker.template.TemplateException;
import java.io.IOException;

final class ConditionalBlock
extends TemplateElement {
    final Expression condition;
    private final boolean isFirst;
    boolean isSimple;

    ConditionalBlock(Expression expression, TemplateElement templateElement, boolean bl) {
        this.condition = expression;
        this.nestedBlock = templateElement;
        this.isFirst = bl;
    }

    void accept(Environment environment) throws TemplateException, IOException {
        if ((this.condition == null || this.condition.isTrue(environment)) && this.nestedBlock != null) {
            environment.visit(this.nestedBlock);
        }
    }

    public String getCanonicalForm() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.condition == null) {
            stringBuffer.append("<#else");
        } else if (this.isFirst) {
            stringBuffer.append("<#if ");
        } else {
            stringBuffer.append("<#elseif ");
        }
        if (this.condition != null) {
            stringBuffer.append(this.condition.getCanonicalForm());
        }
        stringBuffer.append(">");
        if (this.nestedBlock != null) {
            stringBuffer.append(this.nestedBlock.getCanonicalForm());
        }
        if (this.isSimple) {
            stringBuffer.append("</#if>");
        }
        return stringBuffer.toString();
    }

    public String getDescription() {
        String string = "if ";
        if (this.condition == null) {
            string = "else ";
        } else if (!this.isFirst) {
            string = "elseif ";
        }
        String string2 = this.condition != null ? this.condition.toString() : "";
        return string + string2;
    }
}

