/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.ArithmeticEngine;
import freemarker.core.BooleanExpression;
import freemarker.core.Environment;
import freemarker.core.EvaluationUtil;
import freemarker.core.Expression;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import java.util.Date;

final class ComparisonExpression
extends BooleanExpression {
    static final int EQUALS = 1;
    static final int NOT_EQUALS = 2;
    static final int LESS_THAN = 3;
    static final int GREATER_THAN = 4;
    static final int LESS_THAN_EQUALS = 5;
    static final int GREATER_THAN_EQUALS = 6;
    private final Expression left;
    private final Expression right;
    private final int operation;
    private final String opString;

    ComparisonExpression(Expression expression, Expression expression2, String string) {
        this.left = expression;
        this.right = expression2;
        this.opString = string = string.intern();
        if (string == "==" || string == "=") {
            this.operation = 1;
        } else if (string == "!=") {
            this.operation = 2;
        } else if (string == "gt" || string == "\\gt" || string == ">" || string == "&gt;") {
            this.operation = 4;
        } else if (string == "gte" || string == "\\gte" || string == ">=" || string == "&gt;=") {
            this.operation = 6;
        } else if (string == "lt" || string == "\\lt" || string == "<" || string == "&lt;") {
            this.operation = 3;
        } else if (string == "lte" || string == "\\lte" || string == "<=" || string == "&lt;=") {
            this.operation = 5;
        } else {
            throw new RuntimeException("Unknown comparison operator " + string);
        }
    }

    boolean isTrue(Environment environment) throws TemplateException {
        TemplateModel templateModel = this.left.getAsTemplateModel(environment);
        TemplateModel templateModel2 = this.right.getAsTemplateModel(environment);
        if (environment != null && environment.isClassicCompatible()) {
            if (templateModel == null) {
                templateModel = TemplateScalarModel.EMPTY_STRING;
            }
            if (templateModel2 == null) {
                templateModel2 = TemplateScalarModel.EMPTY_STRING;
            }
        }
        ComparisonExpression.assertNonNull(templateModel, this.left, environment);
        ComparisonExpression.assertNonNull(templateModel2, this.right, environment);
        int n = 0;
        if (templateModel instanceof TemplateNumberModel && templateModel2 instanceof TemplateNumberModel) {
            Number number = EvaluationUtil.getNumber((TemplateNumberModel)templateModel, this.left, environment);
            Number number2 = EvaluationUtil.getNumber((TemplateNumberModel)templateModel2, this.right, environment);
            ArithmeticEngine arithmeticEngine = environment != null ? environment.getArithmeticEngine() : this.getTemplate().getArithmeticEngine();
            n = arithmeticEngine.compareNumbers(number, number2);
        } else if (templateModel instanceof TemplateDateModel && templateModel2 instanceof TemplateDateModel) {
            int n2;
            TemplateDateModel templateDateModel = (TemplateDateModel)templateModel;
            TemplateDateModel templateDateModel2 = (TemplateDateModel)templateModel2;
            int n3 = templateDateModel.getDateType();
            if (n3 != (n2 = templateDateModel2.getDateType())) {
                throw new TemplateException("Can not compare dates of different type. Left date is of " + TemplateDateModel.TYPE_NAMES.get(n3) + " type, right date is of " + TemplateDateModel.TYPE_NAMES.get(n2) + " type.", environment);
            }
            if (n3 == 0) {
                throw new TemplateException("Left date is of UNKNOWN type, and can not be compared.", environment);
            }
            if (n2 == 0) {
                throw new TemplateException("Right date is of UNKNOWN type, and can not be compared.", environment);
            }
            Date date = EvaluationUtil.getDate(templateDateModel, this.left, environment);
            Date date2 = EvaluationUtil.getDate(templateDateModel2, this.right, environment);
            n = date.compareTo(date2);
        } else if (templateModel instanceof TemplateScalarModel && templateModel2 instanceof TemplateScalarModel) {
            if (this.operation != 1 && this.operation != 2) {
                throw new TemplateException("Can not use operator " + this.opString + " on string values.", environment);
            }
            String string = EvaluationUtil.getString((TemplateScalarModel)templateModel, this.left, environment);
            String string2 = EvaluationUtil.getString((TemplateScalarModel)templateModel2, this.right, environment);
            n = environment.getCollator().compare(string, string2);
        } else if (templateModel instanceof TemplateBooleanModel && templateModel2 instanceof TemplateBooleanModel) {
            if (this.operation != 1 && this.operation != 2) {
                throw new TemplateException("Can not use operator " + this.opString + " on boolean values.", environment);
            }
            boolean bl = ((TemplateBooleanModel)templateModel).getAsBoolean();
            boolean bl2 = ((TemplateBooleanModel)templateModel2).getAsBoolean();
            n = (bl ? 1 : 0) - (bl2 ? 1 : 0);
        } else if (environment.isClassicCompatible()) {
            String string = this.left.getStringValue(environment);
            String string3 = this.right.getStringValue(environment);
            n = environment.getCollator().compare(string, string3);
        } else {
            throw new TemplateException("The only legal comparisons are between two numbers, two strings, or two dates.\nLeft  hand operand is a " + templateModel.getClass().getName() + "\n" + "Right hand operand is a " + templateModel2.getClass().getName() + "\n", environment);
        }
        switch (this.operation) {
            case 1: {
                return n == 0;
            }
            case 2: {
                return n != 0;
            }
            case 3: {
                return n < 0;
            }
            case 4: {
                return n > 0;
            }
            case 5: {
                return n <= 0;
            }
            case 6: {
                return n >= 0;
            }
        }
        throw new TemplateException("unknown operation", environment);
    }

    public String getCanonicalForm() {
        return this.left.getCanonicalForm() + ' ' + this.opString + ' ' + this.right.getCanonicalForm();
    }

    boolean isLiteral() {
        return this.constantValue != null || this.left.isLiteral() && this.right.isLiteral();
    }

    Expression _deepClone(String string, Expression expression) {
        return new ComparisonExpression(this.left.deepClone(string, expression), this.right.deepClone(string, expression), this.opString);
    }
}

