/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateSequenceModel;
import java.io.Serializable;
import java.util.ArrayList;

public final class CollectionAndSequence
implements TemplateCollectionModel,
TemplateSequenceModel,
Serializable {
    private TemplateCollectionModel collection;
    private TemplateSequenceModel sequence;
    private ArrayList data;

    public CollectionAndSequence(TemplateCollectionModel templateCollectionModel) {
        this.collection = templateCollectionModel;
    }

    public CollectionAndSequence(TemplateSequenceModel templateSequenceModel) {
        this.sequence = templateSequenceModel;
    }

    public TemplateModelIterator iterator() throws TemplateModelException {
        if (this.collection != null) {
            return this.collection.iterator();
        }
        return new SequenceIterator(this.sequence);
    }

    public TemplateModel get(int n) throws TemplateModelException {
        if (this.sequence != null) {
            return this.sequence.get(n);
        }
        this.initSequence();
        return (TemplateModel)this.data.get(n);
    }

    public int size() throws TemplateModelException {
        if (this.sequence != null) {
            return this.sequence.size();
        }
        this.initSequence();
        return this.data.size();
    }

    private void initSequence() throws TemplateModelException {
        if (this.data == null) {
            this.data = new ArrayList();
            TemplateModelIterator templateModelIterator = this.collection.iterator();
            while (templateModelIterator.hasNext()) {
                this.data.add(templateModelIterator.next());
            }
        }
    }

    private static class SequenceIterator
    implements TemplateModelIterator {
        private final TemplateSequenceModel sequence;
        private final int size;
        private int index = 0;

        SequenceIterator(TemplateSequenceModel templateSequenceModel) throws TemplateModelException {
            this.sequence = templateSequenceModel;
            this.size = templateSequenceModel.size();
        }

        public TemplateModel next() throws TemplateModelException {
            return this.sequence.get(this.index++);
        }

        public boolean hasNext() {
            return this.index < this.size;
        }
    }
}

