/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.TemplateElement;
import freemarker.template.TemplateException;
import java.io.IOException;

final class Case
extends TemplateElement {
    boolean isDefault;
    Expression expression;

    Case(Expression expression, TemplateElement templateElement, boolean bl) {
        this.expression = expression;
        this.nestedBlock = templateElement;
        this.isDefault = bl;
    }

    void accept(Environment environment) throws TemplateException, IOException {
        if (this.nestedBlock != null) {
            environment.visit(this.nestedBlock);
        }
    }

    public String getCanonicalForm() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isDefault) {
            stringBuffer.append("<#default>");
        } else {
            stringBuffer.append("<#case ");
            stringBuffer.append(this.expression.getCanonicalForm());
            stringBuffer.append(">");
        }
        if (this.nestedBlock != null) {
            stringBuffer.append(this.nestedBlock.getCanonicalForm());
        }
        return stringBuffer.toString();
    }

    public String getDescription() {
        if (this.isDefault) {
            return "default case";
        }
        return "case " + this.expression;
    }
}

