/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.Macro;
import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;

final class BuiltinVariable
extends Expression {
    static final String NAMESPACE = "namespace";
    static final String MAIN = "main";
    static final String GLOBALS = "globals";
    static final String LOCALS = "locals";
    static final String DATA_MODEL = "data_model";
    static final String LANG = "lang";
    static final String LOCALE = "locale";
    static final String CURRENT_NODE = "current_node";
    static final String NODE = "node";
    static final String PASS = "pass";
    static final String VARS = "vars";
    static final String VERSION = "version";
    static final String ERROR = "error";
    static final String OUTPUT_ENCODING = "output_encoding";
    static final String URL_ESCAPING_CHARSET = "url_escaping_charset";
    private final String name;

    BuiltinVariable(String string) throws ParseException {
        this.name = string = string.intern();
        if (string != NAMESPACE && string != MAIN && string != GLOBALS && string != LOCALS && string != LANG && string != LOCALE && string != DATA_MODEL && string != CURRENT_NODE && string != NODE && string != PASS && string != VARS && string != VERSION && string != OUTPUT_ENCODING && string != URL_ESCAPING_CHARSET && string != ERROR) {
            throw new ParseException("Unknown built-in variable: " + string, this);
        }
    }

    TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
        if (this.name == NAMESPACE) {
            return environment.getCurrentNamespace();
        }
        if (this.name == MAIN) {
            return environment.getMainNamespace();
        }
        if (this.name == GLOBALS) {
            return environment.getGlobalVariables();
        }
        if (this.name == LOCALS) {
            return environment.getCurrentMacroContext().getLocals();
        }
        if (this.name == DATA_MODEL) {
            return environment.getDataModel();
        }
        if (this.name == VARS) {
            return new VarsHash(environment);
        }
        if (this.name == LOCALE) {
            return new SimpleScalar(environment.getLocale().toString());
        }
        if (this.name == LANG) {
            return new SimpleScalar(environment.getLocale().getLanguage());
        }
        if (this.name == CURRENT_NODE || this.name == NODE) {
            return environment.getCurrentVisitorNode();
        }
        if (this.name == PASS) {
            return Macro.DO_NOTHING_MACRO;
        }
        if (this.name == VERSION) {
            return new SimpleScalar(Configuration.getVersionNumber());
        }
        if (this.name == OUTPUT_ENCODING) {
            String string = environment.getOutputEncoding();
            return string != null ? new SimpleScalar(string) : null;
        }
        if (this.name == URL_ESCAPING_CHARSET) {
            String string = environment.getURLEscapingCharset();
            return string != null ? new SimpleScalar(string) : null;
        }
        if (this.name == ERROR) {
            return new SimpleScalar(environment.getCurrentRecoveredErrorMesssage());
        }
        throw new TemplateException("Invalid built-in variable: " + this, environment);
    }

    public String toString() {
        return "." + this.name;
    }

    public String getCanonicalForm() {
        return "." + this.name;
    }

    boolean isLiteral() {
        return false;
    }

    Expression _deepClone(String string, Expression expression) {
        return this;
    }

    class VarsHash
    implements TemplateHashModel {
        Environment env;

        VarsHash(Environment environment) {
            this.env = environment;
        }

        public TemplateModel get(String string) throws TemplateModelException {
            return this.env.getVariable(string);
        }

        public boolean isEmpty() {
            return false;
        }
    }
}

