/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.CollectionAndSequence;
import freemarker.core.Environment;
import freemarker.core.EvaluationUtil;
import freemarker.core.Expression;
import freemarker.core.Interpret;
import freemarker.core.InvalidReferenceException;
import freemarker.core.Macro;
import freemarker.core.NewBI;
import freemarker.core.NodeBuiltins;
import freemarker.core.NumericalBuiltins;
import freemarker.core.ParentheticalExpression;
import freemarker.core.ParseException;
import freemarker.core.SequenceBuiltins;
import freemarker.core.StringArraySequence;
import freemarker.core.StringBuiltins;
import freemarker.core.Token;
import freemarker.template.SimpleDate;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNodeModel;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.TemplateTransformModel;
import freemarker.template.utility.ClassUtil;
import freemarker.template.utility.StringUtil;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

abstract class BuiltIn
extends Expression
implements Cloneable {
    Expression target;
    String key;
    static final HashMap builtins = new HashMap();

    BuiltIn() {
    }

    private static Object instantiate(String string) throws Exception {
        return ClassUtil.forName(string).newInstance();
    }

    static BuiltIn newBuiltIn(Expression expression, String string, Token token, String string2) throws ParseException {
        BuiltIn builtIn = (BuiltIn)builtins.get(string);
        if (builtIn == null) {
            String string3 = "Error on line " + token.beginLine + ", column " + token.beginColumn + ", in template " + string2 + "\n";
            StringBuffer stringBuffer = new StringBuffer("Found " + string + ", expecting one of: ");
            Iterator iterator = builtins.keySet().iterator();
            while (iterator.hasNext()) {
                if (iterator.hasNext()) {
                    stringBuffer.append(" ");
                } else {
                    stringBuffer.append(" or ");
                }
                stringBuffer.append(iterator.next());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
            throw new ParseException(string3 + stringBuffer, expression);
        }
        try {
            builtIn = (BuiltIn)builtIn.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        builtIn.target = expression;
        builtIn.key = string;
        return builtIn;
    }

    public String getCanonicalForm() {
        return this.target.getCanonicalForm() + "?" + this.key;
    }

    boolean isLiteral() {
        return false;
    }

    Expression _deepClone(String string, Expression expression) {
        try {
            BuiltIn builtIn = (BuiltIn)this.clone();
            builtIn.target = this.target.deepClone(string, expression);
            return builtIn;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    static {
        builtins.put("ancestors", new NodeBuiltins.ancestorsBI());
        builtins.put("byte", new NumericalBuiltins.byteBI());
        builtins.put("c", new NumericalBuiltins.cBI());
        builtins.put("cap_first", new StringBuiltins.cap_firstBI());
        builtins.put("capitalize", new StringBuiltins.capitalizeBI());
        builtins.put("children", new NodeBuiltins.childrenBI());
        builtins.put("chop_linebreak", new StringBuiltins.chop_linebreakBI());
        builtins.put("contains", new containsBI());
        builtins.put("date", new dateBI(2));
        builtins.put("datetime", new dateBI(3));
        builtins.put("default", new defaultBI());
        builtins.put("double", new NumericalBuiltins.doubleBI());
        builtins.put("ends_with", new ends_withBI());
        builtins.put("eval", new StringBuiltins.evalBI());
        builtins.put("exists", new existsBI());
        builtins.put("first", new SequenceBuiltins.firstBI());
        builtins.put("float", new NumericalBuiltins.floatBI());
        builtins.put("chunk", new SequenceBuiltins.chunkBI());
        builtins.put("has_content", new has_contentBI());
        builtins.put("html", new htmlBI());
        builtins.put("if_exists", new if_existsBI());
        builtins.put("index_of", new index_ofBI());
        builtins.put("int", new NumericalBuiltins.intBI());
        builtins.put("interpret", new Interpret());
        builtins.put("is_boolean", new is_booleanBI());
        builtins.put("is_collection", new is_collectionBI());
        builtins.put("is_date", new is_dateBI());
        builtins.put("is_directive", new is_directiveBI());
        builtins.put("is_enumerable", new is_enumerableBI());
        builtins.put("is_hash_ex", new is_hash_exBI());
        builtins.put("is_hash", new is_hashBI());
        builtins.put("is_indexable", new is_indexableBI());
        builtins.put("is_macro", new is_macroBI());
        builtins.put("is_method", new is_methodBI());
        builtins.put("is_node", new is_nodeBI());
        builtins.put("is_number", new is_numberBI());
        builtins.put("is_sequence", new is_sequenceBI());
        builtins.put("is_string", new is_stringBI());
        builtins.put("is_transform", new is_transformBI());
        builtins.put("j_string", new StringBuiltins.j_stringBI());
        builtins.put("js_string", new StringBuiltins.js_stringBI());
        builtins.put("keys", new keysBI());
        builtins.put("last_index_of", new last_index_ofBI());
        builtins.put("last", new SequenceBuiltins.lastBI());
        builtins.put("left_pad", new left_padBI());
        builtins.put("length", new lengthBI());
        builtins.put("long", new NumericalBuiltins.longBI());
        builtins.put("lower_case", new StringBuiltins.lower_caseBI());
        builtins.put("namespace", new namespaceBI());
        builtins.put("new", new NewBI());
        builtins.put("node_name", new NodeBuiltins.node_nameBI());
        builtins.put("node_namespace", new NodeBuiltins.node_namespaceBI());
        builtins.put("node_type", new NodeBuiltins.node_typeBI());
        builtins.put("number", new StringBuiltins.numberBI());
        builtins.put("parent", new NodeBuiltins.parentBI());
        builtins.put("replace", new replaceBI());
        builtins.put("reverse", new SequenceBuiltins.reverseBI());
        builtins.put("right_pad", new right_padBI());
        builtins.put("root", new NodeBuiltins.rootBI());
        builtins.put("rtf", new rtfBI());
        builtins.put("seq_contains", new SequenceBuiltins.seq_containsBI());
        builtins.put("seq_index_of", new SequenceBuiltins.seq_index_ofBI(1));
        builtins.put("seq_last_index_of", new SequenceBuiltins.seq_index_ofBI(-1));
        builtins.put("short", new NumericalBuiltins.shortBI());
        builtins.put("size", new sizeBI());
        builtins.put("sort_by", new SequenceBuiltins.sort_byBI());
        builtins.put("sort", new SequenceBuiltins.sortBI());
        builtins.put("split", new splitBI());
        builtins.put("starts_with", new starts_withBI());
        builtins.put("string", new stringBI());
        builtins.put("substring", new StringBuiltins.substringBI());
        builtins.put("time", new dateBI(1));
        builtins.put("trim", new trimBI());
        builtins.put("uncap_first", new StringBuiltins.uncap_firstBI());
        builtins.put("upper_case", new StringBuiltins.upper_caseBI());
        builtins.put("url", new urlBI());
        builtins.put("values", new valuesBI());
        builtins.put("web_safe", builtins.get("html"));
        builtins.put("word_list", new StringBuiltins.word_listBI());
        builtins.put("xml", new xmlBI());
        try {
            Class.forName("java.util.regex.Pattern");
            builtins.put("matches", BuiltIn.instantiate("freemarker.core.RegexBuiltins$matchesBI"));
            builtins.put("groups", BuiltIn.instantiate("freemarker.core.RegexBuiltins$groupsBI"));
            builtins.put("replace", BuiltIn.instantiate("freemarker.core.RegexBuiltins$replace_reBI"));
            builtins.put("split", BuiltIn.instantiate("freemarker.core.RegexBuiltins$split_reBI"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class containsBI
    extends BuiltIn {
        containsBI() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            TemplateModel templateModel = this.target.getAsTemplateModel(environment);
            if (templateModel instanceof TemplateScalarModel) {
                return new BIMethod(((TemplateScalarModel)templateModel).getAsString());
            }
            throw containsBI.invalidTypeException(templateModel, this.target, environment, "string");
        }

        private class BIMethod
        implements TemplateMethodModelEx {
            private String s;

            private BIMethod(String string) {
                this.s = string;
            }

            public Object exec(List list) throws TemplateModelException {
                int n = list.size();
                if (n != 1) {
                    throw new TemplateModelException("?contains(...) expects one argument.");
                }
                Object e = list.get(0);
                if (!(e instanceof TemplateScalarModel)) {
                    throw new TemplateModelException("?contains(...) expects a string as its first argument.");
                }
                String string = ((TemplateScalarModel)e).getAsString();
                return this.s.indexOf(string) != -1 ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
            }
        }
    }

    static class dateBI
    extends BuiltIn {
        private final int dateType;

        dateBI(int n) {
            this.dateType = n;
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            TemplateModel templateModel = this.target.getAsTemplateModel(environment);
            if (templateModel instanceof TemplateDateModel) {
                TemplateDateModel templateDateModel = (TemplateDateModel)templateModel;
                int n = templateDateModel.getDateType();
                if (this.dateType == n) {
                    return templateModel;
                }
                if (n == 0 || n == 3) {
                    return new SimpleDate(templateDateModel.getAsDate(), this.dateType);
                }
                throw new TemplateException("Cannot convert " + TemplateDateModel.TYPE_NAMES.get(n) + " into " + TemplateDateModel.TYPE_NAMES.get(this.dateType), environment);
            }
            String string = this.target.getStringValue(environment);
            return new DateParser(string, environment);
        }

        private class DateParser
        implements TemplateDateModel,
        TemplateMethodModel,
        TemplateHashModel {
            private final String text;
            private final Environment env;
            private final DateFormat defaultFormat;
            private Date cachedValue;

            DateParser(String string, Environment environment) throws TemplateModelException {
                this.text = string;
                this.env = environment;
                this.defaultFormat = environment.getDateFormatObject(dateBI.this.dateType);
            }

            public Date getAsDate() throws TemplateModelException {
                if (this.cachedValue == null) {
                    this.cachedValue = this.parse(this.defaultFormat);
                }
                return this.cachedValue;
            }

            public int getDateType() {
                return dateBI.this.dateType;
            }

            public TemplateModel get(String string) throws TemplateModelException {
                return new SimpleDate(this.parse(this.env.getDateFormatObject(dateBI.this.dateType, string)), dateBI.this.dateType);
            }

            public Object exec(List list) throws TemplateModelException {
                if (list.size() != 1) {
                    throw new TemplateModelException("string?" + dateBI.this.key + "(...) requires exactly 1 argument.");
                }
                return this.get((String)list.get(0));
            }

            public boolean isEmpty() {
                return false;
            }

            private Date parse(DateFormat dateFormat) throws TemplateModelException {
                try {
                    return dateFormat.parse(this.text);
                }
                catch (java.text.ParseException parseException) {
                    String string = "Error: " + dateBI.this.getStartLocation() + "\nExpecting a date here, found: " + this.text;
                    throw new TemplateModelException(string);
                }
            }
        }
    }

    static class defaultBI
    extends BuiltIn {
        private static final TemplateMethodModelEx FIRST_NON_NULL_METHOD = new TemplateMethodModelEx(){

            public Object exec(List list) throws TemplateModelException {
                if (list.isEmpty()) {
                    throw new TemplateModelException("?default(arg) expects at least one argument.");
                }
                TemplateModel templateModel = null;
                for (int i = 0; i < list.size() && (templateModel = (TemplateModel)list.get(i)) == null; ++i) {
                }
                return templateModel;
            }
        };

        defaultBI() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            try {
                TemplateModel templateModel = this.target.getAsTemplateModel(environment);
                return templateModel == null ? FIRST_NON_NULL_METHOD : new ConstantMethod(templateModel);
            }
            catch (InvalidReferenceException invalidReferenceException) {
                if (this.target instanceof ParentheticalExpression) {
                    return FIRST_NON_NULL_METHOD;
                }
                throw invalidReferenceException;
            }
        }

        private static class ConstantMethod
        implements TemplateMethodModelEx {
            private final TemplateModel constant;

            ConstantMethod(TemplateModel templateModel) {
                this.constant = templateModel;
            }

            public Object exec(List list) {
                return this.constant;
            }
        }
    }

    static class ends_withBI
    extends BuiltIn {
        ends_withBI() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            TemplateModel templateModel = this.target.getAsTemplateModel(environment);
            if (templateModel instanceof TemplateScalarModel) {
                return new BIMethod(((TemplateScalarModel)templateModel).getAsString());
            }
            throw ends_withBI.invalidTypeException(templateModel, this.target, environment, "string");
        }

        private class BIMethod
        implements TemplateMethodModelEx {
            private String s;

            private BIMethod(String string) {
                this.s = string;
            }

            public Object exec(List list) throws TemplateModelException {
                if (list.size() != 1) {
                    throw new TemplateModelException("?ends_with(...) expects exactly 1 argument.");
                }
                Object e = list.get(0);
                if (!(e instanceof TemplateScalarModel)) {
                    throw new TemplateModelException("?ends_with(...) expects a string argument");
                }
                String string = ((TemplateScalarModel)e).getAsString();
                return this.s.endsWith(string) ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
            }
        }
    }

    static class existsBI
    extends BuiltIn {
        existsBI() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            try {
                TemplateModel templateModel = this.target.getAsTemplateModel(environment);
                return templateModel == null ? TemplateBooleanModel.FALSE : TemplateBooleanModel.TRUE;
            }
            catch (InvalidReferenceException invalidReferenceException) {
                if (this.target instanceof ParentheticalExpression) {
                    return TemplateBooleanModel.FALSE;
                }
                throw invalidReferenceException;
            }
        }

        boolean isTrue(Environment environment) throws TemplateException {
            return this._getAsTemplateModel(environment) == TemplateBooleanModel.TRUE;
        }
    }

    static class has_contentBI
    extends BuiltIn {
        has_contentBI() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            try {
                TemplateModel templateModel = this.target.getAsTemplateModel(environment);
                return Expression.isEmpty(templateModel) ? TemplateBooleanModel.FALSE : TemplateBooleanModel.TRUE;
            }
            catch (InvalidReferenceException invalidReferenceException) {
                if (this.target instanceof ParentheticalExpression) {
                    return TemplateBooleanModel.FALSE;
                }
                throw invalidReferenceException;
            }
        }

        boolean isTrue(Environment environment) throws TemplateException {
            return this._getAsTemplateModel(environment) == TemplateBooleanModel.TRUE;
        }
    }

    static class htmlBI
    extends StringBuiltins.StringBuiltIn {
        htmlBI() {
        }

        TemplateModel calculateResult(String string, Environment environment) {
            return new SimpleScalar(StringUtil.HTMLEnc(string));
        }
    }

    static class if_existsBI
    extends BuiltIn {
        if_existsBI() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            try {
                TemplateModel templateModel = this.target.getAsTemplateModel(environment);
                return templateModel == null ? TemplateModel.NOTHING : templateModel;
            }
            catch (InvalidReferenceException invalidReferenceException) {
                if (this.target instanceof ParentheticalExpression) {
                    return TemplateModel.NOTHING;
                }
                throw invalidReferenceException;
            }
        }
    }

    static class index_ofBI
    extends BuiltIn {
        index_ofBI() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            TemplateModel templateModel = this.target.getAsTemplateModel(environment);
            if (templateModel instanceof TemplateScalarModel) {
                return new BIMethod(((TemplateScalarModel)templateModel).getAsString());
            }
            throw index_ofBI.invalidTypeException(templateModel, this.target, environment, "string");
        }

        private class BIMethod
        implements TemplateMethodModelEx {
            private String s;

            private BIMethod(String string) {
                this.s = string;
            }

            public Object exec(List list) throws TemplateModelException {
                int n;
                int n2 = list.size();
                if (n2 == 0) {
                    throw new TemplateModelException("?index_of(...) expects at least one argument.");
                }
                if (n2 > 2) {
                    throw new TemplateModelException("?index_of(...) expects at most two arguments.");
                }
                Object e = list.get(0);
                if (!(e instanceof TemplateScalarModel)) {
                    throw new TemplateModelException("?index_of(...) expects a string as its first argument.");
                }
                String string = ((TemplateScalarModel)e).getAsString();
                if (n2 > 1) {
                    e = list.get(1);
                    if (!(e instanceof TemplateNumberModel)) {
                        throw new TemplateModelException("?index_of(...) expects a number as its second argument.");
                    }
                    n = ((TemplateNumberModel)e).getAsNumber().intValue();
                } else {
                    n = 0;
                }
                return new SimpleNumber(this.s.indexOf(string, n));
            }
        }
    }

    static class is_booleanBI
    extends BuiltIn {
        is_booleanBI() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            TemplateModel templateModel = this.target.getAsTemplateModel(environment);
            is_booleanBI.assertNonNull(templateModel, this.target, environment);
            return templateModel instanceof TemplateBooleanModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_collectionBI
    extends BuiltIn {
        is_collectionBI() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            TemplateModel templateModel = this.target.getAsTemplateModel(environment);
            is_collectionBI.assertNonNull(templateModel, this.target, environment);
            return templateModel instanceof TemplateCollectionModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_dateBI
    extends BuiltIn {
        is_dateBI() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            TemplateModel templateModel = this.target.getAsTemplateModel(environment);
            is_dateBI.assertNonNull(templateModel, this.target, environment);
            return templateModel instanceof TemplateDateModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_directiveBI
    extends BuiltIn {
        is_directiveBI() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            TemplateModel templateModel = this.target.getAsTemplateModel(environment);
            is_directiveBI.assertNonNull(templateModel, this.target, environment);
            return templateModel instanceof TemplateTransformModel || templateModel instanceof Macro ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_enumerableBI
    extends BuiltIn {
        is_enumerableBI() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            TemplateModel templateModel = this.target.getAsTemplateModel(environment);
            is_enumerableBI.assertNonNull(templateModel, this.target, environment);
            return templateModel instanceof TemplateSequenceModel || templateModel instanceof TemplateCollectionModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_hashBI
    extends BuiltIn {
        is_hashBI() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            TemplateModel templateModel = this.target.getAsTemplateModel(environment);
            is_hashBI.assertNonNull(templateModel, this.target, environment);
            return templateModel instanceof TemplateHashModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_hash_exBI
    extends BuiltIn {
        is_hash_exBI() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            TemplateModel templateModel = this.target.getAsTemplateModel(environment);
            is_hash_exBI.assertNonNull(templateModel, this.target, environment);
            return templateModel instanceof TemplateHashModelEx ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_indexableBI
    extends BuiltIn {
        is_indexableBI() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            TemplateModel templateModel = this.target.getAsTemplateModel(environment);
            is_indexableBI.assertNonNull(templateModel, this.target, environment);
            return templateModel instanceof TemplateSequenceModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_macroBI
    extends BuiltIn {
        is_macroBI() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            TemplateModel templateModel = this.target.getAsTemplateModel(environment);
            is_macroBI.assertNonNull(templateModel, this.target, environment);
            return templateModel instanceof Macro ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_methodBI
    extends BuiltIn {
        is_methodBI() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            TemplateModel templateModel = this.target.getAsTemplateModel(environment);
            is_methodBI.assertNonNull(templateModel, this.target, environment);
            return templateModel instanceof TemplateMethodModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_nodeBI
    extends BuiltIn {
        is_nodeBI() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            TemplateModel templateModel = this.target.getAsTemplateModel(environment);
            is_nodeBI.assertNonNull(templateModel, this.target, environment);
            return templateModel instanceof TemplateNodeModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_numberBI
    extends BuiltIn {
        is_numberBI() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            TemplateModel templateModel = this.target.getAsTemplateModel(environment);
            is_numberBI.assertNonNull(templateModel, this.target, environment);
            return templateModel instanceof TemplateNumberModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_sequenceBI
    extends BuiltIn {
        is_sequenceBI() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            TemplateModel templateModel = this.target.getAsTemplateModel(environment);
            is_sequenceBI.assertNonNull(templateModel, this.target, environment);
            return templateModel instanceof TemplateSequenceModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_stringBI
    extends BuiltIn {
        is_stringBI() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            TemplateModel templateModel = this.target.getAsTemplateModel(environment);
            is_stringBI.assertNonNull(templateModel, this.target, environment);
            return templateModel instanceof TemplateScalarModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_transformBI
    extends BuiltIn {
        is_transformBI() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            TemplateModel templateModel = this.target.getAsTemplateModel(environment);
            is_transformBI.assertNonNull(templateModel, this.target, environment);
            return templateModel instanceof TemplateTransformModel ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class keysBI
    extends BuiltIn {
        keysBI() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            TemplateModel templateModel = this.target.getAsTemplateModel(environment);
            if (templateModel instanceof TemplateHashModelEx) {
                TemplateCollectionModel templateCollectionModel = ((TemplateHashModelEx)templateModel).keys();
                keysBI.assertNonNull(templateCollectionModel, this, environment);
                if (!(templateCollectionModel instanceof TemplateSequenceModel)) {
                    templateCollectionModel = new CollectionAndSequence(templateCollectionModel);
                }
                return templateCollectionModel;
            }
            throw keysBI.invalidTypeException(templateModel, this.target, environment, "extended hash");
        }
    }

    static class last_index_ofBI
    extends BuiltIn {
        last_index_ofBI() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            TemplateModel templateModel = this.target.getAsTemplateModel(environment);
            if (templateModel instanceof TemplateScalarModel) {
                return new BIMethod(((TemplateScalarModel)templateModel).getAsString());
            }
            throw last_index_ofBI.invalidTypeException(templateModel, this.target, environment, "string");
        }

        private class BIMethod
        implements TemplateMethodModelEx {
            private String s;

            private BIMethod(String string) {
                this.s = string;
            }

            public Object exec(List list) throws TemplateModelException {
                int n = list.size();
                if (n == 0) {
                    throw new TemplateModelException("?last_index_of(...) expects at least one argument.");
                }
                if (n > 2) {
                    throw new TemplateModelException("?last_index_of(...) expects at most two arguments.");
                }
                Object e = list.get(0);
                if (!(e instanceof TemplateScalarModel)) {
                    throw new TemplateModelException("?last_index_of(...) expects a string as its first argument.");
                }
                String string = ((TemplateScalarModel)e).getAsString();
                if (n > 1) {
                    e = list.get(1);
                    if (!(e instanceof TemplateNumberModel)) {
                        throw new TemplateModelException("?last_index_of(...) expects a number as its second argument.");
                    }
                    int n2 = ((TemplateNumberModel)e).getAsNumber().intValue();
                    return new SimpleNumber(this.s.lastIndexOf(string, n2));
                }
                return new SimpleNumber(this.s.lastIndexOf(string));
            }
        }
    }

    static class left_padBI
    extends BuiltIn {
        left_padBI() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            TemplateModel templateModel = this.target.getAsTemplateModel(environment);
            if (templateModel instanceof TemplateScalarModel) {
                return new BIMethod(((TemplateScalarModel)templateModel).getAsString());
            }
            throw left_padBI.invalidTypeException(templateModel, this.target, environment, "string");
        }

        private class BIMethod
        implements TemplateMethodModelEx {
            private String s;

            private BIMethod(String string) {
                this.s = string;
            }

            public Object exec(List list) throws TemplateModelException {
                int n = list.size();
                if (n == 0) {
                    throw new TemplateModelException("?left_pad(...) expects at least 1 argument.");
                }
                if (n > 2) {
                    throw new TemplateModelException("?left_pad(...) expects at most 2 arguments.");
                }
                Object e = list.get(0);
                if (!(e instanceof TemplateNumberModel)) {
                    throw new TemplateModelException("?left_pad(...) expects a number as its 1st argument.");
                }
                int n2 = ((TemplateNumberModel)e).getAsNumber().intValue();
                if (n > 1) {
                    e = list.get(1);
                    if (!(e instanceof TemplateScalarModel)) {
                        throw new TemplateModelException("?left_pad(...) expects a string as its 2nd argument.");
                    }
                    String string = ((TemplateScalarModel)e).getAsString();
                    try {
                        return new SimpleScalar(StringUtil.leftPad(this.s, n2, string));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (string.length() == 0) {
                            throw new TemplateModelException("The 2nd argument of ?left_pad(...) can't be a 0 length string.");
                        }
                        throw new TemplateModelException("Error while executing the ?left_pad(...) built-in.", illegalArgumentException);
                    }
                }
                return new SimpleScalar(StringUtil.leftPad(this.s, n2));
            }
        }
    }

    static class lengthBI
    extends BuiltIn {
        lengthBI() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            return new SimpleNumber(this.target.getStringValue(environment).length());
        }
    }

    static class namespaceBI
    extends BuiltIn {
        namespaceBI() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            TemplateModel templateModel = this.target.getAsTemplateModel(environment);
            if (!(templateModel instanceof Macro)) {
                namespaceBI.invalidTypeException(templateModel, this.target, environment, "macro");
            }
            return environment.getMacroNamespace((Macro)templateModel);
        }
    }

    static class replaceBI
    extends BuiltIn {
        replaceBI() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            TemplateModel templateModel = this.target.getAsTemplateModel(environment);
            if (templateModel instanceof TemplateScalarModel) {
                return new BIMethod(((TemplateScalarModel)templateModel).getAsString());
            }
            throw replaceBI.invalidTypeException(templateModel, this.target, environment, "string");
        }

        private class BIMethod
        implements TemplateMethodModel {
            private String s;

            private BIMethod(String string) {
                this.s = string;
            }

            public Object exec(List list) throws TemplateModelException {
                boolean bl;
                int n = list.size();
                if (n < 2 || n > 3) {
                    throw new TemplateModelException("?replace(...) needs 2 or 3 arguments.");
                }
                String string = (String)list.get(0);
                String string2 = (String)list.get(1);
                String string3 = n > 2 ? (String)list.get(2) : "";
                boolean bl2 = string3.indexOf(105) >= 0;
                boolean bl3 = bl = string3.indexOf(102) >= 0;
                if (string3.indexOf(114) >= 0) {
                    throw new TemplateModelException("The regular expression classes are not available.");
                }
                return new SimpleScalar(StringUtil.replace(this.s, string, string2, bl2, bl));
            }
        }
    }

    static class right_padBI
    extends BuiltIn {
        right_padBI() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            TemplateModel templateModel = this.target.getAsTemplateModel(environment);
            if (templateModel instanceof TemplateScalarModel) {
                return new BIMethod(((TemplateScalarModel)templateModel).getAsString());
            }
            throw right_padBI.invalidTypeException(templateModel, this.target, environment, "string");
        }

        private class BIMethod
        implements TemplateMethodModelEx {
            private String s;

            private BIMethod(String string) {
                this.s = string;
            }

            public Object exec(List list) throws TemplateModelException {
                int n = list.size();
                if (n == 0) {
                    throw new TemplateModelException("?right_pad(...) expects at least 1 argument.");
                }
                if (n > 2) {
                    throw new TemplateModelException("?right_pad(...) expects at most 2 arguments.");
                }
                Object e = list.get(0);
                if (!(e instanceof TemplateNumberModel)) {
                    throw new TemplateModelException("?right_pad(...) expects a number as its 1st argument.");
                }
                int n2 = ((TemplateNumberModel)e).getAsNumber().intValue();
                if (n > 1) {
                    e = list.get(1);
                    if (!(e instanceof TemplateScalarModel)) {
                        throw new TemplateModelException("?right_pad(...) expects a string as its 2nd argument.");
                    }
                    String string = ((TemplateScalarModel)e).getAsString();
                    try {
                        return new SimpleScalar(StringUtil.rightPad(this.s, n2, string));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (string.length() == 0) {
                            throw new TemplateModelException("The 2nd argument of ?right_pad(...) can't be a 0 length string.");
                        }
                        throw new TemplateModelException("Error while executing the ?right_pad(...) built-in.", illegalArgumentException);
                    }
                }
                return new SimpleScalar(StringUtil.rightPad(this.s, n2));
            }
        }
    }

    static class rtfBI
    extends StringBuiltins.StringBuiltIn {
        rtfBI() {
        }

        TemplateModel calculateResult(String string, Environment environment) {
            return new SimpleScalar(StringUtil.RTFEnc(string));
        }
    }

    static class sizeBI
    extends BuiltIn {
        sizeBI() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            TemplateModel templateModel = this.target.getAsTemplateModel(environment);
            if (templateModel instanceof TemplateSequenceModel) {
                int n = ((TemplateSequenceModel)templateModel).size();
                return new SimpleNumber(n);
            }
            if (templateModel instanceof TemplateHashModelEx) {
                int n = ((TemplateHashModelEx)templateModel).size();
                return new SimpleNumber(n);
            }
            throw sizeBI.invalidTypeException(templateModel, this.target, environment, "extended-hash or sequence");
        }
    }

    static class splitBI
    extends BuiltIn {
        splitBI() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            TemplateModel templateModel = this.target.getAsTemplateModel(environment);
            if (templateModel instanceof TemplateScalarModel) {
                return new BIMethod(((TemplateScalarModel)templateModel).getAsString());
            }
            throw splitBI.invalidTypeException(templateModel, this.target, environment, "string");
        }

        private class BIMethod
        implements TemplateMethodModel {
            private String s;

            private BIMethod(String string) {
                this.s = string;
            }

            public Object exec(List list) throws TemplateModelException {
                boolean bl;
                int n = list.size();
                if (n != 1 && n != 2) {
                    throw new TemplateModelException("?split(...) expects 1 or 2 arguments.");
                }
                String string = (String)list.get(0);
                String string2 = n == 2 ? (String)list.get(1) : "";
                boolean bl2 = bl = string2.indexOf(105) >= 0;
                if (string2.indexOf(114) >= 0) {
                    throw new TemplateModelException("regular expression classes not available");
                }
                return new StringArraySequence(StringUtil.split(this.s, string, bl));
            }
        }
    }

    static class starts_withBI
    extends BuiltIn {
        starts_withBI() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            TemplateModel templateModel = this.target.getAsTemplateModel(environment);
            if (templateModel instanceof TemplateScalarModel) {
                return new BIMethod(((TemplateScalarModel)templateModel).getAsString());
            }
            throw starts_withBI.invalidTypeException(templateModel, this.target, environment, "string");
        }

        private class BIMethod
        implements TemplateMethodModelEx {
            private String s;

            private BIMethod(String string) {
                this.s = string;
            }

            public Object exec(List list) throws TemplateModelException {
                if (list.size() != 1) {
                    throw new TemplateModelException("?starts_with(...) expects exactly 1 argument.");
                }
                Object e = list.get(0);
                if (!(e instanceof TemplateScalarModel)) {
                    throw new TemplateModelException("?starts_with(...) expects a string argument");
                }
                String string = ((TemplateScalarModel)e).getAsString();
                return this.s.startsWith(string) ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
            }
        }
    }

    static class stringBI
    extends BuiltIn {
        stringBI() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            TemplateModel templateModel = this.target.getAsTemplateModel(environment);
            if (templateModel instanceof TemplateNumberModel) {
                return new NumberFormatter(EvaluationUtil.getNumber((TemplateNumberModel)templateModel, this.target, environment), environment);
            }
            if (templateModel instanceof TemplateDateModel) {
                TemplateDateModel templateDateModel = (TemplateDateModel)templateModel;
                int n = templateDateModel.getDateType();
                return new DateFormatter(EvaluationUtil.getDate(templateDateModel, this.target, environment), n, environment);
            }
            if (templateModel instanceof SimpleScalar) {
                return templateModel;
            }
            if (templateModel instanceof TemplateBooleanModel) {
                return new BooleanFormatter((TemplateBooleanModel)templateModel, environment);
            }
            if (templateModel instanceof TemplateScalarModel) {
                return new SimpleScalar(((TemplateScalarModel)templateModel).getAsString());
            }
            throw stringBI.invalidTypeException(templateModel, this.target, environment, "number, date, or string");
        }

        private static class BooleanFormatter
        implements TemplateScalarModel,
        TemplateMethodModel {
            private final TemplateBooleanModel bool;
            private final Environment env;

            BooleanFormatter(TemplateBooleanModel templateBooleanModel, Environment environment) {
                this.bool = templateBooleanModel;
                this.env = environment;
            }

            public String getAsString() throws TemplateModelException {
                if (this.bool instanceof TemplateScalarModel) {
                    return ((TemplateScalarModel)((Object)this.bool)).getAsString();
                }
                return this.env.getBooleanFormat(this.bool.getAsBoolean());
            }

            public Object exec(List list) throws TemplateModelException {
                if (list.size() != 2) {
                    throw new TemplateModelException("boolean?string(...) requires exactly 2 arguments.");
                }
                return new SimpleScalar((String)list.get(this.bool.getAsBoolean() ? 0 : 1));
            }
        }

        private static class DateFormatter
        implements TemplateScalarModel,
        TemplateHashModel,
        TemplateMethodModel {
            private final Date date;
            private final int dateType;
            private final Environment env;
            private final DateFormat defaultFormat;
            private String cachedValue;

            DateFormatter(Date date, int n, Environment environment) throws TemplateModelException {
                this.date = date;
                this.dateType = n;
                this.env = environment;
                this.defaultFormat = environment.getDateFormatObject(n);
            }

            public String getAsString() throws TemplateModelException {
                if (this.dateType == 0) {
                    throw new TemplateModelException("Can't convert the date to string, because it is not known which parts of the date variable are in use. Use ?date, ?time or ?datetime built-in, or ?string.<format> or ?string(format) built-in with this date.");
                }
                if (this.cachedValue == null) {
                    this.cachedValue = this.defaultFormat.format(this.date);
                }
                return this.cachedValue;
            }

            public TemplateModel get(String string) throws TemplateModelException {
                return new SimpleScalar(this.env.getDateFormatObject(this.dateType, string).format(this.date));
            }

            public Object exec(List list) throws TemplateModelException {
                if (list.size() != 1) {
                    throw new TemplateModelException("date?string(...) requires exactly 1 argument.");
                }
                return this.get((String)list.get(0));
            }

            public boolean isEmpty() {
                return false;
            }
        }

        private static class NumberFormatter
        implements TemplateScalarModel,
        TemplateHashModel,
        TemplateMethodModel {
            private final Number number;
            private final Environment env;
            private final NumberFormat defaultFormat;
            private String cachedValue;

            NumberFormatter(Number number, Environment environment) {
                this.number = number;
                this.env = environment;
                this.defaultFormat = environment.getNumberFormatObject(environment.getNumberFormat());
            }

            public String getAsString() {
                if (this.cachedValue == null) {
                    this.cachedValue = this.defaultFormat.format(this.number);
                }
                return this.cachedValue;
            }

            public TemplateModel get(String string) {
                return new SimpleScalar(this.env.getNumberFormatObject(string).format(this.number));
            }

            public Object exec(List list) throws TemplateModelException {
                if (list.size() != 1) {
                    throw new TemplateModelException("number?string(...) requires exactly 1 argument.");
                }
                return this.get((String)list.get(0));
            }

            public boolean isEmpty() {
                return false;
            }
        }
    }

    static class trimBI
    extends StringBuiltins.StringBuiltIn {
        trimBI() {
        }

        TemplateModel calculateResult(String string, Environment environment) {
            return new SimpleScalar(string.trim());
        }
    }

    static class urlBI
    extends StringBuiltins.StringBuiltIn {
        urlBI() {
        }

        TemplateModel calculateResult(String string, Environment environment) {
            return new urlBIResult(string, environment);
        }

        static class urlBIResult
        implements TemplateScalarModel,
        TemplateMethodModel {
            private final String target;
            private final Environment env;
            private String cachedResult;

            private urlBIResult(String string, Environment environment) {
                this.target = string;
                this.env = environment;
            }

            public String getAsString() throws TemplateModelException {
                if (this.cachedResult == null) {
                    String string = this.env.getEffectiveURLEscapingCharset();
                    if (string == null) {
                        throw new TemplateModelException("To do URL encoding, the framework that encloses FreeMarker must specify the output encoding or the URL encoding charset, so ask the programmers to fix it. Or, as a last chance, you can set the url_encoding_charset setting in the template, e.g. <#setting url_escaping_charset='ISO-8859-1'>, or give the charset explicitly to the buit-in, e.g. foo?url('ISO-8859-1').");
                    }
                    try {
                        this.cachedResult = StringUtil.URLEnc(this.target, string);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new TemplateModelException("Failed to execute URL encoding.", unsupportedEncodingException);
                    }
                }
                return this.cachedResult;
            }

            public Object exec(List list) throws TemplateModelException {
                if (list.size() != 1) {
                    throw new TemplateModelException("The \"url\" built-in needs exactly 1 parameter, the charset.");
                }
                try {
                    return new SimpleScalar(StringUtil.URLEnc(this.target, (String)list.get(0)));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new TemplateModelException("Failed to execute URL encoding.", unsupportedEncodingException);
                }
            }
        }
    }

    static class valuesBI
    extends BuiltIn {
        valuesBI() {
        }

        TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
            TemplateModel templateModel = this.target.getAsTemplateModel(environment);
            if (templateModel instanceof TemplateHashModelEx) {
                TemplateCollectionModel templateCollectionModel = ((TemplateHashModelEx)templateModel).values();
                valuesBI.assertNonNull(templateCollectionModel, this, environment);
                if (!(templateCollectionModel instanceof TemplateSequenceModel)) {
                    templateCollectionModel = new CollectionAndSequence(templateCollectionModel);
                }
                return templateCollectionModel;
            }
            throw valuesBI.invalidTypeException(templateModel, this.target, environment, "extended hash");
        }
    }

    static class xmlBI
    extends StringBuiltins.StringBuiltIn {
        xmlBI() {
        }

        TemplateModel calculateResult(String string, Environment environment) {
            return new SimpleScalar(StringUtil.XMLEnc(string));
        }
    }
}

