/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.LocalContext;
import freemarker.core.Macro;
import freemarker.core.TemplateElement;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

final class BodyInstruction
extends TemplateElement {
    private List bodyParameters;

    BodyInstruction(List list) {
        this.bodyParameters = list;
    }

    List getBodyParameters() {
        return this.bodyParameters;
    }

    void accept(Environment environment) throws IOException, TemplateException {
        Context context = new Context(environment);
        environment.visit(context);
    }

    public String getCanonicalForm() {
        StringBuffer stringBuffer = new StringBuffer("<#nested");
        if (this.bodyParameters != null) {
            for (int i = 0; i < this.bodyParameters.size(); ++i) {
                stringBuffer.append(' ');
                stringBuffer.append(this.bodyParameters.get(i));
            }
        }
        stringBuffer.append('>');
        return stringBuffer.toString();
    }

    public String getDescription() {
        return "nested macro content";
    }

    class Context
    implements LocalContext {
        Macro.Context invokingMacroContext;
        Environment.Namespace bodyVars;

        Context(Environment environment) throws TemplateException {
            this.invokingMacroContext = environment.getCurrentMacroContext();
            List list = this.invokingMacroContext.bodyParameterNames;
            if (BodyInstruction.this.bodyParameters != null) {
                for (int i = 0; i < BodyInstruction.this.bodyParameters.size(); ++i) {
                    Expression expression = (Expression)BodyInstruction.this.bodyParameters.get(i);
                    TemplateModel templateModel = expression.getAsTemplateModel(environment);
                    if (list == null || i >= list.size()) continue;
                    String string = (String)list.get(i);
                    if (this.bodyVars == null) {
                        this.bodyVars = new Environment.Namespace(environment);
                    }
                    this.bodyVars.put(string, templateModel);
                }
            }
        }

        public TemplateModel getLocalVariable(String string) throws TemplateModelException {
            return this.bodyVars == null ? null : this.bodyVars.get(string);
        }

        public Set getLocalVariableNames() {
            List list = this.invokingMacroContext.bodyParameterNames;
            if (list == null) {
                return Collections.EMPTY_SET;
            }
            return new HashSet(list);
        }
    }
}

