/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.TemplateElement;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateTransformModel;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

final class BlockAssignment
extends TemplateElement {
    private final String varName;
    private final Expression namespaceExp;
    private final int scope;

    BlockAssignment(TemplateElement templateElement, String string, int n, Expression expression) {
        this.nestedBlock = templateElement;
        this.varName = string;
        this.namespaceExp = expression;
        this.scope = n;
    }

    void accept(Environment environment) throws TemplateException, IOException {
        if (this.nestedBlock != null) {
            environment.visit(this.nestedBlock, new CaptureOutput(environment), null);
        }
    }

    public String getCanonicalForm() {
        String string;
        switch (this.scope) {
            case 2: {
                string = "local";
                break;
            }
            case 3: {
                string = "global";
                break;
            }
            default: {
                string = "assign";
            }
        }
        return "<#" + string + " " + this.varName + (this.namespaceExp != null ? " in " + this.namespaceExp.getCanonicalForm() : "") + ">" + this.nestedBlock.getCanonicalForm() + "</#" + string + ">";
    }

    public String getDescription() {
        return "block assignment to variable: " + this.varName;
    }

    boolean isIgnorable() {
        return false;
    }

    private class CaptureOutput
    implements TemplateTransformModel {
        private final Environment env;
        private final Environment.Namespace fnsModel;

        CaptureOutput(Environment environment) throws TemplateException {
            this.env = environment;
            TemplateModel templateModel = null;
            if (BlockAssignment.this.namespaceExp != null && !((templateModel = BlockAssignment.this.namespaceExp.getAsTemplateModel(environment)) instanceof Environment.Namespace)) {
                throw new TemplateException("namespace parameter does not specify a namespace. It is a " + templateModel.getClass().getName(), environment);
            }
            this.fnsModel = (Environment.Namespace)templateModel;
        }

        public Writer getWriter(Writer writer, Map map) {
            return new StringWriter(){

                public void close() {
                    SimpleScalar simpleScalar = new SimpleScalar(this.toString());
                    switch (BlockAssignment.this.scope) {
                        case 1: {
                            if (CaptureOutput.this.fnsModel != null) {
                                CaptureOutput.this.fnsModel.put(BlockAssignment.this.varName, simpleScalar);
                                break;
                            }
                            CaptureOutput.this.env.setVariable(BlockAssignment.this.varName, simpleScalar);
                            break;
                        }
                        case 2: {
                            CaptureOutput.this.env.setLocalVariable(BlockAssignment.this.varName, simpleScalar);
                            break;
                        }
                        case 3: {
                            CaptureOutput.this.env.setGlobalVariable(BlockAssignment.this.varName, simpleScalar);
                        }
                    }
                }
            };
        }
    }
}

