/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Assignment;
import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.ParseException;
import freemarker.core.TemplateElement;
import freemarker.core.TemplateObject;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.ArrayList;

final class AssignmentInstruction
extends TemplateElement {
    private int scope;
    private Expression namespaceExp;

    AssignmentInstruction(int n) {
        this.scope = n;
        this.nestedElements = new ArrayList(1);
    }

    void addAssignment(Assignment assignment) {
        this.nestedElements.add(assignment);
    }

    void setNamespaceExp(Expression expression) {
        this.namespaceExp = expression;
        for (int i = 0; i < this.nestedElements.size(); ++i) {
            ((Assignment)this.nestedElements.get(i)).setNamespaceExp(expression);
        }
    }

    void accept(Environment environment) throws TemplateException, IOException {
        for (int i = 0; i < this.nestedElements.size(); ++i) {
            Assignment assignment = (Assignment)this.nestedElements.get(i);
            environment.visit(assignment);
        }
    }

    public String getCanonicalForm() {
        String string = "<#local ";
        if (this.scope == 3) {
            string = "<#global ";
        } else if (this.scope == 1) {
            string = "<#assign ";
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < this.nestedElements.size(); ++i) {
            Assignment assignment = (Assignment)this.nestedElements.get(i);
            stringBuffer.append(assignment.getCanonicalForm());
            if (i >= this.nestedElements.size() - 1) continue;
            stringBuffer.append(" ");
        }
        if (this.namespaceExp != null) {
            stringBuffer.append(" in ");
            stringBuffer.append(this.namespaceExp.getCanonicalForm());
        }
        stringBuffer.append("/>");
        return stringBuffer.toString();
    }

    public String getDescription() {
        String string = "local ";
        if (this.scope == 3) {
            string = "global ";
        } else if (this.scope == 1) {
            string = "assign ";
        }
        string = string + "assignment";
        if (this.nestedElements.size() > 1) {
            string = string + "s";
        }
        return string;
    }

    public TemplateElement postParseCleanup(boolean bl) throws ParseException {
        super.postParseCleanup(bl);
        if (this.nestedElements.size() == 1) {
            Assignment assignment = (Assignment)this.nestedElements.get(0);
            assignment.setLocation(this.getTemplate(), (TemplateObject)this, (TemplateObject)this);
            return assignment;
        }
        return this;
    }
}

