/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.AssignmentInstruction;
import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.InvalidReferenceException;
import freemarker.core.TemplateElement;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateScalarModel;

final class Assignment
extends TemplateElement {
    private String variableName;
    private Expression value;
    private Expression namespaceExp;
    private int scope;
    static final int NAMESPACE = 1;
    static final int LOCAL = 2;
    static final int GLOBAL = 3;

    Assignment(String string, Expression expression, int n) {
        this.variableName = string;
        this.value = expression;
        this.scope = n;
    }

    void setNamespaceExp(Expression expression) {
        this.namespaceExp = expression;
    }

    void accept(Environment environment) throws TemplateException {
        TemplateModel templateModel = this.value.getAsTemplateModel(environment);
        Environment.Namespace namespace = null;
        if (this.namespaceExp != null) {
            boolean bl = false;
            try {
                namespace = (Environment.Namespace)this.namespaceExp.getAsTemplateModel(environment);
            }
            catch (ClassCastException classCastException) {
                bl = true;
            }
            if (bl || namespace == null) {
                throw new InvalidReferenceException(this.getStartLocation() + "\nInvalid reference to namespace: " + this.namespaceExp, environment);
            }
        }
        if (templateModel == null) {
            if (environment.isClassicCompatible()) {
                templateModel = TemplateScalarModel.EMPTY_STRING;
            } else {
                String string = "Error " + this.getStartLocation() + "\n" + this.value + " is undefined." + "\nIt cannot be assigned to " + this.variableName;
                throw new InvalidReferenceException(string, environment);
            }
        }
        if (this.scope == 2) {
            environment.setLocalVariable(this.variableName, templateModel);
        } else {
            if (namespace == null) {
                if (this.scope == 3) {
                    namespace = environment.getGlobalNamespace();
                } else if (this.scope == 1) {
                    namespace = environment.getCurrentNamespace();
                }
            }
            namespace.put(this.variableName, templateModel);
        }
    }

    public String getCanonicalForm() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!(this.parent instanceof AssignmentInstruction)) {
            if (this.scope == 2) {
                stringBuffer.append("<#local ");
            } else if (this.scope == 3) {
                stringBuffer.append("<#global ");
            } else {
                stringBuffer.append("<#assign ");
            }
        }
        stringBuffer.append(this.variableName);
        stringBuffer.append('=');
        stringBuffer.append(this.value.getCanonicalForm());
        if (!(this.parent instanceof AssignmentInstruction)) {
            if (this.namespaceExp != null) {
                stringBuffer.append(" in ");
                stringBuffer.append(this.namespaceExp.getCanonicalForm());
            }
            stringBuffer.append(">");
        }
        return stringBuffer.toString();
    }

    public String getDescription() {
        String string = "";
        if (!(this.parent instanceof AssignmentInstruction)) {
            string = "assignment: ";
            if (this.scope == 2) {
                string = "local " + string;
            } else if (this.scope == 3) {
                string = "global " + string;
            }
        }
        return string + this.variableName + "=" + this.value;
    }
}

