/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.ArithmeticEngine;
import freemarker.core.Environment;
import freemarker.core.EvaluationUtil;
import freemarker.core.Expression;
import freemarker.core.NonNumericalException;
import freemarker.template.SimpleNumber;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateNumberModel;

final class ArithmeticExpression
extends Expression {
    static final int SUBSTRACTION = 0;
    static final int MULTIPLICATION = 1;
    static final int DIVISION = 2;
    static final int MODULUS = 3;
    private static final char[] OPERATORS = new char[]{'-', '*', '/', '%'};
    private final Expression left;
    private final Expression right;
    private final int operation;

    ArithmeticExpression(Expression expression, Expression expression2, int n) {
        this.left = expression;
        this.right = expression2;
        this.operation = n;
    }

    TemplateModel _getAsTemplateModel(Environment environment) throws TemplateException {
        boolean bl;
        TemplateModel templateModel = this.left.getAsTemplateModel(environment);
        TemplateModel templateModel2 = this.right.getAsTemplateModel(environment);
        boolean bl2 = templateModel instanceof TemplateNumberModel;
        boolean bl3 = templateModel2 instanceof TemplateNumberModel;
        boolean bl4 = bl = bl2 && bl3;
        if (!bl) {
            String string = "Error " + this.getStartLocation();
            if (!bl2) {
                string = string + "\nExpression " + this.left + " is not numerical";
            }
            if (!bl3) {
                string = string + "\nExpression " + this.right + " is not numerical";
            }
            throw new NonNumericalException(string, environment);
        }
        Number number = EvaluationUtil.getNumber(templateModel, this.left, environment);
        Number number2 = EvaluationUtil.getNumber(templateModel2, this.right, environment);
        ArithmeticEngine arithmeticEngine = environment != null ? environment.getArithmeticEngine() : this.getTemplate().getArithmeticEngine();
        switch (this.operation) {
            case 0: {
                return new SimpleNumber(arithmeticEngine.subtract(number, number2));
            }
            case 1: {
                return new SimpleNumber(arithmeticEngine.multiply(number, number2));
            }
            case 2: {
                return new SimpleNumber(arithmeticEngine.divide(number, number2));
            }
            case 3: {
                return new SimpleNumber(arithmeticEngine.modulus(number, number2));
            }
        }
        throw new TemplateException("unknown operation : " + this.operation, environment);
    }

    public String getCanonicalForm() {
        return this.left.getCanonicalForm() + ' ' + OPERATORS[this.operation] + ' ' + this.right.getCanonicalForm();
    }

    boolean isLiteral() {
        return this.constantValue != null || this.left.isLiteral() && this.right.isLiteral();
    }

    Expression _deepClone(String string, Expression expression) {
        return new ArithmeticExpression(this.left.deepClone(string, expression), this.right.deepClone(string, expression), this.operation);
    }
}

