/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.template.TemplateException;
import freemarker.template.utility.OptimizerUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public abstract class ArithmeticEngine {
    public static final BigDecimalEngine BIGDECIMAL_ENGINE = new BigDecimalEngine();
    public static final ConservativeEngine CONSERVATIVE_ENGINE = new ConservativeEngine();
    protected int minScale = 12;
    protected int maxScale = 12;
    protected int roundingPolicy = 4;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;

    public abstract int compareNumbers(Number var1, Number var2) throws TemplateException;

    public abstract Number add(Number var1, Number var2) throws TemplateException;

    public abstract Number subtract(Number var1, Number var2) throws TemplateException;

    public abstract Number multiply(Number var1, Number var2) throws TemplateException;

    public abstract Number divide(Number var1, Number var2) throws TemplateException;

    public abstract Number modulus(Number var1, Number var2) throws TemplateException;

    public abstract Number toNumber(String var1);

    public void setMinScale(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("minScale < 0");
        }
        this.minScale = n;
    }

    public void setMaxScale(int n) {
        if (n < this.minScale) {
            throw new IllegalArgumentException("maxScale < minScale");
        }
        this.maxScale = n;
    }

    public void setRoundingPolicy(int n) {
        if (n != 2 && n != 1 && n != 3 && n != 5 && n != 6 && n != 4 && n != 7 && n != 0) {
            throw new IllegalArgumentException("invalid rounding policy");
        }
        this.roundingPolicy = n;
    }

    private static BigDecimal toBigDecimal(Number number) {
        return number instanceof BigDecimal ? (BigDecimal)number : new BigDecimal(number.toString());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class BigDecimalEngine
    extends ArithmeticEngine {
        public int compareNumbers(Number number, Number number2) {
            BigDecimal bigDecimal = ArithmeticEngine.toBigDecimal(number);
            BigDecimal bigDecimal2 = ArithmeticEngine.toBigDecimal(number2);
            return bigDecimal.compareTo(bigDecimal2);
        }

        public Number add(Number number, Number number2) {
            BigDecimal bigDecimal = ArithmeticEngine.toBigDecimal(number);
            BigDecimal bigDecimal2 = ArithmeticEngine.toBigDecimal(number2);
            return bigDecimal.add(bigDecimal2);
        }

        public Number subtract(Number number, Number number2) {
            BigDecimal bigDecimal = ArithmeticEngine.toBigDecimal(number);
            BigDecimal bigDecimal2 = ArithmeticEngine.toBigDecimal(number2);
            return bigDecimal.subtract(bigDecimal2);
        }

        public Number multiply(Number number, Number number2) {
            BigDecimal bigDecimal;
            BigDecimal bigDecimal2 = ArithmeticEngine.toBigDecimal(number);
            BigDecimal bigDecimal3 = bigDecimal2.multiply(bigDecimal = ArithmeticEngine.toBigDecimal(number2));
            if (bigDecimal3.scale() > this.maxScale) {
                bigDecimal3 = bigDecimal3.setScale(this.maxScale, this.roundingPolicy);
            }
            return bigDecimal3;
        }

        public Number divide(Number number, Number number2) {
            BigDecimal bigDecimal = ArithmeticEngine.toBigDecimal(number);
            BigDecimal bigDecimal2 = ArithmeticEngine.toBigDecimal(number2);
            return this.divide(bigDecimal, bigDecimal2);
        }

        public Number modulus(Number number, Number number2) {
            long l = number.longValue();
            long l2 = number2.longValue();
            return new Long(l % l2);
        }

        public Number toNumber(String string) {
            return new BigDecimal(string);
        }

        private BigDecimal divide(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
            int n = bigDecimal.scale();
            int n2 = bigDecimal2.scale();
            int n3 = Math.max(n, n2);
            n3 = Math.max(this.minScale, n3);
            return bigDecimal.divide(bigDecimal2, n3, this.roundingPolicy);
        }
    }

    public static class ConservativeEngine
    extends ArithmeticEngine {
        private static final int INTEGER = 0;
        private static final int LONG = 1;
        private static final int FLOAT = 2;
        private static final int DOUBLE = 3;
        private static final int BIGINTEGER = 4;
        private static final int BIGDECIMAL = 5;
        private static final Map classCodes = ConservativeEngine.createClassCodesMap();

        public int compareNumbers(Number number, Number number2) throws TemplateException {
            switch (ConservativeEngine.getCommonClassCode(number, number2)) {
                case 0: {
                    int n = number.intValue();
                    int n2 = number2.intValue();
                    return n < n2 ? -1 : (n == n2 ? 0 : 1);
                }
                case 1: {
                    long l = number.longValue();
                    long l2 = number2.longValue();
                    return l < l2 ? -1 : (l == l2 ? 0 : 1);
                }
                case 2: {
                    float f = number.floatValue();
                    float f2 = number2.floatValue();
                    return f < f2 ? -1 : (f == f2 ? 0 : 1);
                }
                case 3: {
                    double d = number.doubleValue();
                    double d2 = number2.doubleValue();
                    return d < d2 ? -1 : (d == d2 ? 0 : 1);
                }
                case 4: {
                    BigInteger bigInteger = ConservativeEngine.toBigInteger(number);
                    BigInteger bigInteger2 = ConservativeEngine.toBigInteger(number2);
                    return bigInteger.compareTo(bigInteger2);
                }
                case 5: {
                    BigDecimal bigDecimal = ArithmeticEngine.toBigDecimal(number);
                    BigDecimal bigDecimal2 = ArithmeticEngine.toBigDecimal(number2);
                    return bigDecimal.compareTo(bigDecimal2);
                }
            }
            throw new Error();
        }

        public Number add(Number number, Number number2) throws TemplateException {
            switch (ConservativeEngine.getCommonClassCode(number, number2)) {
                case 0: {
                    int n = number.intValue();
                    int n2 = number2.intValue();
                    int n3 = n + n2;
                    return (n3 ^ n) < 0 && (n3 ^ n2) < 0 ? (Number)new Long((long)n + (long)n2) : (Number)new Integer(n3);
                }
                case 1: {
                    long l = number.longValue();
                    long l2 = number2.longValue();
                    long l3 = l + l2;
                    return (l3 ^ l) < 0L && (l3 ^ l2) < 0L ? ConservativeEngine.toBigInteger(number).add(ConservativeEngine.toBigInteger(number2)) : new Long(l3);
                }
                case 2: {
                    return new Float(number.floatValue() + number2.floatValue());
                }
                case 3: {
                    return new Double(number.doubleValue() + number2.doubleValue());
                }
                case 4: {
                    BigInteger bigInteger = ConservativeEngine.toBigInteger(number);
                    BigInteger bigInteger2 = ConservativeEngine.toBigInteger(number2);
                    return bigInteger.add(bigInteger2);
                }
                case 5: {
                    BigDecimal bigDecimal = ArithmeticEngine.toBigDecimal(number);
                    BigDecimal bigDecimal2 = ArithmeticEngine.toBigDecimal(number2);
                    return bigDecimal.add(bigDecimal2);
                }
            }
            throw new Error();
        }

        public Number subtract(Number number, Number number2) throws TemplateException {
            switch (ConservativeEngine.getCommonClassCode(number, number2)) {
                case 0: {
                    int n = number.intValue();
                    int n2 = number2.intValue();
                    int n3 = n - n2;
                    return (n3 ^ n) < 0 && (n3 ^ ~n2) < 0 ? (Number)new Long((long)n - (long)n2) : (Number)new Integer(n3);
                }
                case 1: {
                    long l = number.longValue();
                    long l2 = number2.longValue();
                    long l3 = l - l2;
                    return (l3 ^ l) < 0L && (l3 ^ (l2 ^ 0xFFFFFFFFFFFFFFFFL)) < 0L ? ConservativeEngine.toBigInteger(number).subtract(ConservativeEngine.toBigInteger(number2)) : new Long(l3);
                }
                case 2: {
                    return new Float(number.floatValue() - number2.floatValue());
                }
                case 3: {
                    return new Double(number.doubleValue() - number2.doubleValue());
                }
                case 4: {
                    BigInteger bigInteger = ConservativeEngine.toBigInteger(number);
                    BigInteger bigInteger2 = ConservativeEngine.toBigInteger(number2);
                    return bigInteger.subtract(bigInteger2);
                }
                case 5: {
                    BigDecimal bigDecimal = ArithmeticEngine.toBigDecimal(number);
                    BigDecimal bigDecimal2 = ArithmeticEngine.toBigDecimal(number2);
                    return bigDecimal.subtract(bigDecimal2);
                }
            }
            throw new Error();
        }

        public Number multiply(Number number, Number number2) throws TemplateException {
            switch (ConservativeEngine.getCommonClassCode(number, number2)) {
                case 0: {
                    int n = number.intValue();
                    int n2 = number2.intValue();
                    int n3 = n * n2;
                    return n == 0 || n3 / n == n2 ? (Number)new Integer(n3) : (Number)new Long((long)n * (long)n2);
                }
                case 1: {
                    long l = number.longValue();
                    long l2 = number2.longValue();
                    long l3 = l * l2;
                    return l == 0L || l3 / l == l2 ? new Long(l3) : ConservativeEngine.toBigInteger(number).multiply(ConservativeEngine.toBigInteger(number2));
                }
                case 2: {
                    return new Float(number.floatValue() * number2.floatValue());
                }
                case 3: {
                    return new Double(number.doubleValue() * number2.doubleValue());
                }
                case 4: {
                    BigInteger bigInteger = ConservativeEngine.toBigInteger(number);
                    BigInteger bigInteger2 = ConservativeEngine.toBigInteger(number2);
                    return bigInteger.multiply(bigInteger2);
                }
                case 5: {
                    BigDecimal bigDecimal = ArithmeticEngine.toBigDecimal(number);
                    BigDecimal bigDecimal2 = ArithmeticEngine.toBigDecimal(number2);
                    BigDecimal bigDecimal3 = bigDecimal.multiply(bigDecimal2);
                    return bigDecimal3.scale() > this.maxScale ? bigDecimal3.setScale(this.maxScale, this.roundingPolicy) : bigDecimal3;
                }
            }
            throw new Error();
        }

        public Number divide(Number number, Number number2) throws TemplateException {
            switch (ConservativeEngine.getCommonClassCode(number, number2)) {
                case 0: {
                    int n = number.intValue();
                    int n2 = number2.intValue();
                    if (n % n2 == 0) {
                        return new Integer(n / n2);
                    }
                    return new Double((double)n / (double)n2);
                }
                case 1: {
                    long l = number.longValue();
                    long l2 = number2.longValue();
                    if (l % l2 == 0L) {
                        return new Long(l / l2);
                    }
                    return new Double((double)l / (double)l2);
                }
                case 2: {
                    return new Float(number.floatValue() / number2.floatValue());
                }
                case 3: {
                    return new Double(number.doubleValue() / number2.doubleValue());
                }
                case 4: {
                    BigInteger bigInteger = ConservativeEngine.toBigInteger(number);
                    BigInteger bigInteger2 = ConservativeEngine.toBigInteger(number2);
                    BigInteger[] bigIntegerArray = bigInteger.divideAndRemainder(bigInteger2);
                    if (bigIntegerArray[1].equals(BigInteger.ZERO)) {
                        return bigIntegerArray[0];
                    }
                    BigDecimal bigDecimal = new BigDecimal(bigInteger);
                    BigDecimal bigDecimal2 = new BigDecimal(bigInteger2);
                    return bigDecimal.divide(bigDecimal2, this.minScale, this.roundingPolicy);
                }
                case 5: {
                    BigDecimal bigDecimal = ArithmeticEngine.toBigDecimal(number);
                    BigDecimal bigDecimal3 = ArithmeticEngine.toBigDecimal(number2);
                    int n = bigDecimal.scale();
                    int n3 = bigDecimal3.scale();
                    int n4 = Math.max(n, n3);
                    n4 = Math.max(this.minScale, n4);
                    return bigDecimal.divide(bigDecimal3, n4, this.roundingPolicy);
                }
            }
            throw new Error();
        }

        public Number modulus(Number number, Number number2) throws TemplateException {
            switch (ConservativeEngine.getCommonClassCode(number, number2)) {
                case 0: {
                    return new Integer(number.intValue() % number2.intValue());
                }
                case 1: {
                    return new Long(number.longValue() % number2.longValue());
                }
                case 2: {
                    return new Float(number.floatValue() % number2.floatValue());
                }
                case 3: {
                    return new Double(number.doubleValue() % number2.doubleValue());
                }
                case 4: {
                    BigInteger bigInteger = ConservativeEngine.toBigInteger(number);
                    BigInteger bigInteger2 = ConservativeEngine.toBigInteger(number2);
                    return bigInteger.mod(bigInteger2);
                }
                case 5: {
                    throw new TemplateException("Can't calculate remainder on BigDecimals", Environment.getCurrentEnvironment());
                }
            }
            throw new Error();
        }

        public Number toNumber(String string) {
            return OptimizerUtil.optimizeNumberRepresentation(new BigDecimal(string));
        }

        private static Map createClassCodesMap() {
            HashMap<Class, Integer> hashMap = new HashMap<Class, Integer>(17);
            Integer n = new Integer(0);
            hashMap.put(class$java$lang$Byte == null ? (class$java$lang$Byte = ArithmeticEngine.class$("java.lang.Byte")) : class$java$lang$Byte, n);
            hashMap.put(class$java$lang$Short == null ? (class$java$lang$Short = ArithmeticEngine.class$("java.lang.Short")) : class$java$lang$Short, n);
            hashMap.put(class$java$lang$Integer == null ? (class$java$lang$Integer = ArithmeticEngine.class$("java.lang.Integer")) : class$java$lang$Integer, n);
            hashMap.put(class$java$lang$Long == null ? (class$java$lang$Long = ArithmeticEngine.class$("java.lang.Long")) : class$java$lang$Long, new Integer(1));
            hashMap.put(class$java$lang$Float == null ? (class$java$lang$Float = ArithmeticEngine.class$("java.lang.Float")) : class$java$lang$Float, new Integer(2));
            hashMap.put(class$java$lang$Double == null ? (class$java$lang$Double = ArithmeticEngine.class$("java.lang.Double")) : class$java$lang$Double, new Integer(3));
            hashMap.put(class$java$math$BigInteger == null ? (class$java$math$BigInteger = ArithmeticEngine.class$("java.math.BigInteger")) : class$java$math$BigInteger, new Integer(4));
            hashMap.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ArithmeticEngine.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new Integer(5));
            return hashMap;
        }

        private static int getClassCode(Number number) throws TemplateException {
            try {
                return (Integer)classCodes.get(number.getClass());
            }
            catch (NullPointerException nullPointerException) {
                if (number == null) {
                    throw new TemplateException("Unknown number type null", Environment.getCurrentEnvironment());
                }
                throw new TemplateException("Unknown number type " + number.getClass().getName(), Environment.getCurrentEnvironment());
            }
        }

        private static int getCommonClassCode(Number number, Number number2) throws TemplateException {
            int n;
            int n2 = ConservativeEngine.getClassCode(number);
            int n3 = n2 > (n = ConservativeEngine.getClassCode(number2)) ? n2 : n;
            switch (n3) {
                case 2: {
                    if ((n2 < n ? n2 : n) != 1) break;
                    return 3;
                }
                case 4: {
                    int n4;
                    int n5 = n4 = n2 < n ? n2 : n;
                    if (n4 != 3 && n4 != 2) break;
                    return 5;
                }
            }
            return n3;
        }

        private static BigInteger toBigInteger(Number number) {
            return number instanceof BigInteger ? (BigInteger)number : new BigInteger(number.toString());
        }
    }
}

